/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.net.URI;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.JarScanner;
import org.eclipse.jetty.webapp.WebAppContext;

public class MetaInfConfiguration
extends AbstractConfiguration {
    public static final String METAINF_TLDS = "org.eclipse.jetty.tlds";
    public static final String METAINF_FRAGMENTS = "org.eclipse.jetty.webFragments";
    public static final String METAINF_RESOURCES = "org.eclipse.jetty.resources";

    @Override
    public void preConfigure(final WebAppContext context) throws Exception {
        ArrayList<Resource> jars = new ArrayList<Resource>();
        jars.addAll(context.getMetaData().getOrderedContainerJars());
        jars.addAll(context.getMetaData().getWebInfJars());
        JarScanner scanner = new JarScanner(){

            @Override
            public void processEntry(URI jarUri, JarEntry entry) {
                try {
                    MetaInfConfiguration.this.processEntry(context, jarUri, entry);
                }
                catch (Exception e) {
                    Log.warn((String)("Problem processing jar entry " + entry), (Throwable)e);
                }
            }
        };
        if (jars != null) {
            URI[] uris = new URI[jars.size()];
            int i = 0;
            for (Resource r : jars) {
                uris[i++] = r.getURI();
            }
            scanner.scan(null, uris, true);
        }
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute(METAINF_FRAGMENTS, null);
        context.setAttribute(METAINF_RESOURCES, null);
        context.setAttribute(METAINF_TLDS, null);
    }

    public void addResource(WebAppContext context, String attribute, Resource jar) {
        ArrayList<Resource> list = (ArrayList<Resource>)context.getAttribute(attribute);
        if (list == null) {
            list = new ArrayList<Resource>();
            context.setAttribute(attribute, list);
        }
        if (!list.contains(jar)) {
            list.add(jar);
        }
    }

    protected void processEntry(WebAppContext context, URI jarUri, JarEntry entry) {
        String name = entry.getName();
        if (!name.startsWith("META-INF/")) {
            return;
        }
        try {
            if (name.equals("META-INF/web-fragment.xml") && context.isConfigurationDiscovered()) {
                this.addResource(context, METAINF_FRAGMENTS, Resource.newResource((URI)jarUri));
            } else if (name.equals("META-INF/resources/") && context.isConfigurationDiscovered()) {
                this.addResource(context, METAINF_RESOURCES, Resource.newResource((String)("jar:" + jarUri + "!/META-INF/resources")));
            } else {
                String lcname = name.toLowerCase();
                if (lcname.endsWith(".tld")) {
                    this.addResource(context, METAINF_TLDS, Resource.newResource((String)("jar:" + jarUri + "!/" + name)));
                }
            }
        }
        catch (Exception e) {
            context.getServletContext().log(jarUri + "!/" + name, (Throwable)e);
        }
    }
}

