/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.xml.XmlParser;

public class Descriptor {
    protected static XmlParser _parser;
    protected Resource _xml;
    protected XmlParser.Node _root;
    protected MetaDataComplete _metaDataComplete;
    protected int _majorVersion = 3;
    protected int _minorVersion = 0;
    protected ArrayList<String> _classNames = new ArrayList();
    protected boolean _distributable;
    protected boolean _validating;
    protected MetaData _metaData;
    protected boolean _isOrdered = false;
    protected List<String> _ordering = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlParser newParser() throws ClassNotFoundException {
        XmlParser xmlParser = new XmlParser();
        URL dtd22 = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/web-app_2_2.dtd", (boolean)true);
        URL dtd23 = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/web-app_2_3.dtd", (boolean)true);
        URL j2ee14xsd = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/j2ee_1_4.xsd", (boolean)true);
        URL webapp24xsd = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/web-app_2_4.xsd", (boolean)true);
        URL webapp25xsd = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/web-app_2_5.xsd", (boolean)true);
        URL webapp30xsd = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/web-app_3_0.xsd", (boolean)true);
        URL webcommon30xsd = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/web-common_3_0.xsd", (boolean)true);
        URL webfragment30xsd = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/web-fragment_3_0.xsd", (boolean)true);
        URL schemadtd = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/XMLSchema.dtd", (boolean)true);
        URL xmlxsd = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/xml.xsd", (boolean)true);
        URL webservice11xsd = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/j2ee_web_services_client_1_1.xsd", (boolean)true);
        URL webservice12xsd = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/javaee_web_services_client_1_2.xsd", (boolean)true);
        URL datatypesdtd = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/datatypes.dtd", (boolean)true);
        URL jsp20xsd = null;
        URL jsp21xsd = null;
        try {
            Class jsp_page = Loader.loadClass(WebXmlConfiguration.class, (String)"javax.servlet.jsp.JspPage");
            jsp20xsd = jsp_page.getResource("/javax/servlet/resources/jsp_2_0.xsd");
            jsp21xsd = jsp_page.getResource("/javax/servlet/resources/jsp_2_1.xsd");
        }
        catch (Exception e) {
            Log.ignore((Throwable)e);
        }
        finally {
            if (jsp20xsd == null) {
                jsp20xsd = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/jsp_2_0.xsd", (boolean)true);
            }
            if (jsp21xsd == null) {
                jsp21xsd = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/jsp_2_1.xsd", (boolean)true);
            }
        }
        Descriptor.redirect(xmlParser, "web-app_2_2.dtd", dtd22);
        Descriptor.redirect(xmlParser, "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", dtd22);
        Descriptor.redirect(xmlParser, "web.dtd", dtd23);
        Descriptor.redirect(xmlParser, "web-app_2_3.dtd", dtd23);
        Descriptor.redirect(xmlParser, "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", dtd23);
        Descriptor.redirect(xmlParser, "XMLSchema.dtd", schemadtd);
        Descriptor.redirect(xmlParser, "http://www.w3.org/2001/XMLSchema.dtd", schemadtd);
        Descriptor.redirect(xmlParser, "-//W3C//DTD XMLSCHEMA 200102//EN", schemadtd);
        Descriptor.redirect(xmlParser, "jsp_2_0.xsd", jsp20xsd);
        Descriptor.redirect(xmlParser, "http://java.sun.com/xml/ns/j2ee/jsp_2_0.xsd", jsp20xsd);
        Descriptor.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/jsp_2_1.xsd", jsp21xsd);
        Descriptor.redirect(xmlParser, "j2ee_1_4.xsd", j2ee14xsd);
        Descriptor.redirect(xmlParser, "http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", j2ee14xsd);
        Descriptor.redirect(xmlParser, "web-app_2_4.xsd", webapp24xsd);
        Descriptor.redirect(xmlParser, "http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", webapp24xsd);
        Descriptor.redirect(xmlParser, "web-app_2_5.xsd", webapp25xsd);
        Descriptor.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", webapp25xsd);
        Descriptor.redirect(xmlParser, "web-app_3_0.xsd", webapp30xsd);
        Descriptor.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd", webapp30xsd);
        Descriptor.redirect(xmlParser, "web-common_3_0.xsd", webcommon30xsd);
        Descriptor.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-common_3_0.xsd", webcommon30xsd);
        Descriptor.redirect(xmlParser, "web-fragment_3_0.xsd", webfragment30xsd);
        Descriptor.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-fragment_3_0.xsd", webfragment30xsd);
        Descriptor.redirect(xmlParser, "xml.xsd", xmlxsd);
        Descriptor.redirect(xmlParser, "http://www.w3.org/2001/xml.xsd", xmlxsd);
        Descriptor.redirect(xmlParser, "datatypes.dtd", datatypesdtd);
        Descriptor.redirect(xmlParser, "http://www.w3.org/2001/datatypes.dtd", datatypesdtd);
        Descriptor.redirect(xmlParser, "j2ee_web_services_client_1_1.xsd", webservice11xsd);
        Descriptor.redirect(xmlParser, "http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", webservice11xsd);
        Descriptor.redirect(xmlParser, "javaee_web_services_client_1_2.xsd", webservice12xsd);
        Descriptor.redirect(xmlParser, "http://www.ibm.com/webservices/xsd/javaee_web_services_client_1_2.xsd", webservice12xsd);
        return xmlParser;
    }

    protected static void redirect(XmlParser parser, String resource, URL source) {
        if (source != null) {
            parser.redirectEntity(resource, source);
        }
    }

    public Descriptor(Resource xml, MetaData md) {
        this._xml = xml;
        this._metaData = md;
    }

    public void parse() throws Exception {
        if (_parser == null) {
            _parser = Descriptor.newParser();
        }
        if (this._root == null) {
            this._root = _parser.parse(this._xml.getURL().toString());
            this.processVersion();
            this.processOrdering();
        }
    }

    public MetaDataComplete getMetaDataComplete() {
        return this._metaDataComplete;
    }

    public XmlParser.Node getRoot() {
        return this._root;
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public Resource getResource() {
        return this._xml;
    }

    public MetaData getMetaData() {
        return this._metaData;
    }

    public void processVersion() {
        String s;
        String version = this._root.getAttribute("version", "DTD");
        if ("DTD".equals(version)) {
            this._majorVersion = 2;
            this._minorVersion = 3;
            String dtd = _parser.getDTD();
            if (dtd != null && dtd.indexOf("web-app_2_2") >= 0) {
                this._majorVersion = 2;
                this._minorVersion = 2;
            }
        } else {
            int dot = version.indexOf(".");
            if (dot > 0) {
                this._majorVersion = Integer.parseInt(version.substring(0, dot));
                this._minorVersion = Integer.parseInt(version.substring(dot + 1));
            }
        }
        this._metaDataComplete = this._majorVersion < 2 && this._minorVersion < 5 ? MetaDataComplete.True : ((s = this._root.getAttribute("metadata-complete")) == null ? MetaDataComplete.NotSet : (Boolean.valueOf(s) != false ? MetaDataComplete.True : MetaDataComplete.False));
        Log.debug((String)(this._xml.toString() + ": Calculated metadatacomplete = " + (Object)((Object)this._metaDataComplete) + " with version=" + version));
    }

    public void processOrdering() {
        XmlParser.Node ordering = this._root.get("absolute-ordering");
        if (ordering == null) {
            return;
        }
        this._isOrdered = true;
        Iterator iter = ordering.iterator();
        XmlParser.Node node = null;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XmlParser.Node)) continue;
            node = (XmlParser.Node)o;
            if (node.getTag().equalsIgnoreCase("others")) {
                this._ordering.add("others");
                continue;
            }
            if (!node.getTag().equalsIgnoreCase("name")) continue;
            this._ordering.add(node.toString(false, true));
        }
    }

    public void addClassName(String className) {
        if (!this._classNames.contains(className)) {
            this._classNames.add(className);
        }
    }

    public ArrayList<String> getClassNames() {
        return this._classNames;
    }

    public void setDistributable(boolean distributable) {
        this._distributable = distributable;
    }

    public boolean isDistributable() {
        return this._distributable;
    }

    public void setValidating(boolean validating) {
        this._validating = validating;
    }

    public boolean isOrdered() {
        return this._isOrdered;
    }

    public List<String> getOrdering() {
        return this._ordering;
    }

    public static enum MetaDataComplete {
        NotSet,
        True,
        False;

    }
}

