/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.PatternMatcher;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebInfConfiguration
implements Configuration {
    public static final String TEMPDIR_CREATED = "org.eclipse.jetty.tmpdirCreated";
    public static final String CONTAINER_JAR_RESOURCES = "org.eclipse.jetty.containerJars";
    public static final String WEB_INF_JAR_RESOURCES = "org.eclipse.jetty.webInfJars";
    public static final String CONTAINER_JAR_PATTERN = "org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern";
    public static final String WEBINF_JAR_PATTERN = "org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern";
    public static final String RESOURCE_URLS = "org.eclipse.jetty.resources";

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        String tmp;
        this.resolveTempDirectory(context);
        this.unpack(context);
        File work = this.findWorkDirectory(context);
        if (work != null) {
            this.makeTempDirectory(work, context, false);
        }
        Pattern webInfPattern = (tmp = (String)context.getAttribute(WEBINF_JAR_PATTERN)) == null ? null : Pattern.compile(tmp);
        tmp = (String)context.getAttribute(CONTAINER_JAR_PATTERN);
        Pattern containerPattern = tmp == null ? null : Pattern.compile(tmp);
        final ArrayList containerJarResources = new ArrayList();
        context.setAttribute(CONTAINER_JAR_RESOURCES, containerJarResources);
        PatternMatcher containerJarNameMatcher = new PatternMatcher(){

            public void matched(URI uri) throws Exception {
                containerJarResources.add(Resource.newResource((URI)uri));
            }
        };
        for (ClassLoader loader = context.getClassLoader(); loader != null && loader instanceof URLClassLoader; loader = loader.getParent()) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            if (urls == null) continue;
            URI[] containerUris = new URI[urls.length];
            int i = 0;
            for (URL u : urls) {
                containerUris[i++] = u.toURI();
            }
            containerJarNameMatcher.match(containerPattern, containerUris, false);
        }
        final ArrayList webInfJarResources = new ArrayList();
        context.setAttribute(WEB_INF_JAR_RESOURCES, webInfJarResources);
        PatternMatcher webInfJarNameMatcher = new PatternMatcher(){

            public void matched(URI uri) throws Exception {
                webInfJarResources.add(Resource.newResource((URI)uri));
            }
        };
        List<Resource> jars = this.findJars(context);
        URI[] uris = null;
        if (jars != null) {
            uris = new URI[jars.size()];
            int i = 0;
            for (Resource r : jars) {
                uris[i++] = r.getURI();
            }
        }
        webInfJarNameMatcher.match(webInfPattern, uris, true);
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        List resources;
        if (context.isStarted()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Cannot configure webapp " + (Object)((Object)context) + " after it is started"));
            }
            return;
        }
        Resource web_inf = context.getWebInf();
        if (web_inf != null && web_inf.isDirectory() && context.getClassLoader() instanceof WebAppClassLoader) {
            Resource lib;
            Resource classes = web_inf.addPath("classes/");
            if (classes.exists()) {
                ((WebAppClassLoader)context.getClassLoader()).addClassPath(classes.toString());
            }
            if ((lib = web_inf.addPath("lib/")).exists() || lib.isDirectory()) {
                ((WebAppClassLoader)context.getClassLoader()).addJars(lib);
            }
        }
        if ((resources = (List)context.getAttribute(RESOURCE_URLS)) != null) {
            Resource[] collection = new Resource[resources.size() + 1];
            int i = 0;
            collection[i++] = context.getBaseResource();
            for (Resource resource : resources) {
                collection[i++] = resource;
            }
            context.setBaseResource((Resource)new ResourceCollection(collection));
        }
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        Boolean containerCreated = (Boolean)context.getAttribute(TEMPDIR_CREATED);
        if (context.getTempDirectory() != null && containerCreated != null && containerCreated.booleanValue() && !this.isTempWorkDirectory(context.getTempDirectory())) {
            IO.delete((File)context.getTempDirectory());
            this.setTempDirectory(null, context);
        }
    }

    public void resolveTempDirectory(WebAppContext context) {
        File tmpDir = context.getTempDirectory();
        if (tmpDir != null && tmpDir.isDirectory() && tmpDir.canWrite()) {
            return;
        }
        Object t = context.getAttribute("javax.servlet.context.tempdir");
        if (t != null) {
            if (t instanceof File && (tmpDir = (File)t).isDirectory() && tmpDir.canWrite()) {
                context.setTempDirectory(tmpDir);
                return;
            }
            if (t instanceof String) {
                try {
                    tmpDir = new File((String)t);
                    if (tmpDir.isDirectory() && tmpDir.canWrite()) {
                        context.setAttribute("javax.servlet.context.tempdir", tmpDir);
                        context.setTempDirectory(tmpDir);
                        return;
                    }
                }
                catch (Exception e) {
                    Log.warn((String)"EXCEPTION ", (Throwable)e);
                }
            }
        }
        String temp = this.getCanonicalNameForWebAppTmpDir(context);
        try {
            File work = new File(System.getProperty("jetty.home"), "work");
            if (!(work.exists() && work.canWrite() && work.isDirectory())) {
                work = null;
            }
            if (work != null) {
                this.makeTempDirectory(work, context, false);
            } else {
                this.makeTempDirectory(new File(System.getProperty("java.io.tmpdir")), context, true);
            }
        }
        catch (Exception e) {
            tmpDir = null;
            Log.ignore((Throwable)e);
        }
        if (context.getTempDirectory() == null) {
            try {
                tmpDir = File.createTempFile("JettyContext", "");
                if (tmpDir.exists()) {
                    tmpDir.delete();
                }
                tmpDir.mkdir();
                tmpDir.deleteOnExit();
                this.setTempDirectory(tmpDir, context);
            }
            catch (IOException e) {
                Log.warn((String)"tmpdir", (Throwable)e);
                System.exit(1);
            }
        }
    }

    public void makeTempDirectory(File parent, WebAppContext context, boolean deleteExisting) throws IOException {
        if (parent != null && parent.exists() && parent.canWrite() && parent.isDirectory()) {
            String temp = this.getCanonicalNameForWebAppTmpDir(context);
            File tmpDir = new File(parent, temp);
            if (deleteExisting && tmpDir.exists()) {
                if (!IO.delete((File)tmpDir) && Log.isDebugEnabled()) {
                    Log.debug((String)("Failed to delete temp dir " + tmpDir));
                }
                if (tmpDir.exists()) {
                    String old = tmpDir.toString();
                    tmpDir = File.createTempFile(temp + "_", "");
                    if (tmpDir.exists()) {
                        tmpDir.delete();
                    }
                    Log.warn((String)("Can't reuse " + old + ", using " + tmpDir));
                }
            }
            if (!tmpDir.exists()) {
                tmpDir.mkdir();
            }
            if (!this.isTempWorkDirectory(tmpDir)) {
                tmpDir.deleteOnExit();
                File sentinel = new File(tmpDir, ".active");
                if (!sentinel.exists()) {
                    sentinel.mkdir();
                }
            }
            this.setTempDirectory(tmpDir, context);
        }
    }

    public void setTempDirectory(File tmpDir, WebAppContext context) {
        context.setAttribute(TEMPDIR_CREATED, Boolean.TRUE);
        context.setAttribute("javax.servlet.context.tempdir", tmpDir);
        context.setTempDirectory(tmpDir);
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Set temp dir " + tmpDir));
        }
    }

    public void unpack(WebAppContext context) throws IOException {
        Resource web_app = context.getBaseResource();
        if (web_app == null) {
            Resource jarWebApp;
            String war = context.getWar();
            if (war == null || war.length() == 0) {
                war = context.getResourceBase();
            }
            if ((web_app = context.newResource(war)).getAlias() != null) {
                Log.debug((String)(web_app + " anti-aliased to " + web_app.getAlias()));
                web_app = context.newResource(web_app.getAlias());
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Try webapp=" + web_app + ", exists=" + web_app.exists() + ", directory=" + web_app.isDirectory()));
            }
            if (web_app.exists() && !web_app.isDirectory() && !web_app.toString().startsWith("jar:") && (jarWebApp = context.newResource("jar:" + web_app + "!/")).exists() && jarWebApp.isDirectory()) {
                web_app = jarWebApp;
            }
            if (web_app.exists() && (context.isCopyWebDir() && web_app.getFile() != null && web_app.getFile().isDirectory() || context.isExtractWAR() && web_app.getFile() != null && !web_app.getFile().isDirectory() || context.isExtractWAR() && web_app.getFile() == null || !web_app.isDirectory())) {
                File extractedWebAppDir = new File(context.getTempDirectory(), "webapp");
                if (web_app.getFile() != null && web_app.getFile().isDirectory()) {
                    Log.info((String)("Copy " + web_app.getFile() + " to " + extractedWebAppDir));
                    IO.copyDir((File)web_app.getFile(), (File)extractedWebAppDir);
                } else if (!extractedWebAppDir.exists()) {
                    extractedWebAppDir.mkdir();
                    Log.info((String)("Extract " + war + " to " + extractedWebAppDir));
                    JarResource.extract((Resource)web_app, (File)extractedWebAppDir, (boolean)false);
                } else if (web_app.lastModified() > extractedWebAppDir.lastModified()) {
                    extractedWebAppDir.delete();
                    extractedWebAppDir.mkdir();
                    Log.info((String)("Extract " + war + " to " + extractedWebAppDir));
                    JarResource.extract((Resource)web_app, (File)extractedWebAppDir, (boolean)false);
                }
                web_app = Resource.newResource((String)extractedWebAppDir.getCanonicalPath());
            }
            if (!web_app.exists() || !web_app.isDirectory()) {
                Log.warn((String)("Web application not found " + war));
                throw new FileNotFoundException(war);
            }
            context.setBaseResource(web_app);
            if (Log.isDebugEnabled()) {
                Log.debug((String)("webapp=" + web_app));
            }
        }
    }

    public File findWorkDirectory(WebAppContext context) throws IOException {
        Resource web_inf;
        if (context.getBaseResource() != null && (web_inf = context.getWebInf()) != null && web_inf.exists()) {
            return new File(web_inf.getFile(), "work");
        }
        return null;
    }

    public boolean isTempWorkDirectory(File tmpDir) {
        if (tmpDir == null) {
            return false;
        }
        if (tmpDir.getName().equalsIgnoreCase("work")) {
            return true;
        }
        File t = tmpDir.getParentFile();
        if (t == null) {
            return false;
        }
        return t.getName().equalsIgnoreCase("work");
    }

    public String getCanonicalNameForWebAppTmpDir(WebAppContext context) {
        int port;
        String host;
        StringBuffer canonicalName = new StringBuffer();
        canonicalName.append("Jetty");
        Connector[] connectors = context.getServer().getConnectors();
        canonicalName.append("_");
        String string = host = connectors == null || connectors[0] == null ? "" : connectors[0].getHost();
        if (host == null) {
            host = "0.0.0.0";
        }
        canonicalName.append(host.replace('.', '_'));
        canonicalName.append("_");
        int n = port = connectors == null || connectors[0] == null ? 0 : connectors[0].getLocalPort();
        if (port < 0) {
            port = connectors[0].getPort();
        }
        canonicalName.append(port);
        canonicalName.append("_");
        try {
            String tmp;
            Resource resource = context.getBaseResource();
            if (resource == null) {
                if (context.getWar() == null || context.getWar().length() == 0) {
                    resource = context.newResource(context.getResourceBase());
                }
                resource = context.newResource(context.getWar());
            }
            if ((tmp = URIUtil.decodePath((String)resource.getURL().getPath())).endsWith("/")) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            if (tmp.endsWith("!")) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            int i = tmp.lastIndexOf("/");
            canonicalName.append(tmp.substring(i + 1, tmp.length()));
        }
        catch (Exception e) {
            Log.warn((String)"Can't generate resourceBase as part of webapp tmp dir name", (Throwable)e);
        }
        canonicalName.append("_");
        String contextPath = context.getContextPath();
        contextPath = contextPath.replace('/', '_');
        contextPath = contextPath.replace('\\', '_');
        canonicalName.append(contextPath);
        canonicalName.append("_");
        String[] vhosts = context.getVirtualHosts();
        if (vhosts == null || vhosts.length <= 0) {
            canonicalName.append("");
        } else {
            canonicalName.append(vhosts[0]);
        }
        String hash = Integer.toString(canonicalName.toString().hashCode(), 36);
        canonicalName.append("_");
        canonicalName.append(hash);
        for (int i = 0; i < canonicalName.length(); ++i) {
            char c = canonicalName.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            canonicalName.setCharAt(i, '.');
        }
        return canonicalName.toString();
    }

    protected List<Resource> findJars(WebAppContext context) throws Exception {
        ArrayList<Resource> jarResources = new ArrayList<Resource>();
        Resource web_inf = context.getWebInf();
        Resource web_inf_lib = web_inf.addPath("/lib");
        if (web_inf_lib.exists() && web_inf_lib.isDirectory()) {
            String[] files = web_inf_lib.list();
            for (int f = 0; files != null && f < files.length; ++f) {
                try {
                    String extension;
                    Resource file = web_inf_lib.addPath(files[f]);
                    String fnlc = file.getName().toLowerCase();
                    int dot = fnlc.lastIndexOf(46);
                    String string = extension = dot < 0 ? null : fnlc.substring(dot);
                    if (extension == null || !extension.equals(".jar") && !extension.equals(".zip")) continue;
                    jarResources.add(file);
                    continue;
                }
                catch (Exception ex) {
                    Log.warn((String)"EXCEPTION ", (Throwable)ex);
                }
            }
        }
        return jarResources;
    }
}

