/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ExecutionStrategy
implements Runnable {
    protected final Producer _producer;
    protected final Executor _executor;

    protected ExecutionStrategy(Producer producer, Executor executor) {
        this._producer = producer;
        this._executor = executor;
    }

    public static class EatWhatYouKill
    extends ExecutionStrategy {
        private final AtomicInteger _threads = new AtomicInteger(0);
        private final AtomicReference<Boolean> _producing = new AtomicReference<Boolean>(Boolean.FALSE);
        private volatile boolean _dispatched;

        public EatWhatYouKill(Producer producer, Executor executor) {
            super(producer, executor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this._dispatched = false;
            this._threads.incrementAndGet();
            try {
                boolean complete = false;
                while (!complete) {
                    if (!this._producing.compareAndSet(false, true)) {
                        break;
                    }
                    Runnable task = null;
                    try {
                        task = this._producer.produce();
                        complete = task == null || this._producer.isMoreToProduce();
                    }
                    finally {
                        this._producing.set(false);
                    }
                    if (!complete && !this._dispatched) {
                        this._dispatched = true;
                        this._executor.execute(this);
                    }
                    if (task == null) continue;
                    task.run();
                }
            }
            finally {
                if (this._threads.decrementAndGet() == 0) {
                    this._producer.onCompleted();
                }
            }
        }
    }

    public static class Iterative
    extends ExecutionStrategy {
        public Iterative(Producer producer, Executor executor) {
            super(producer, executor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block5: {
                try {
                    Runnable task;
                    while (true) {
                        if ((task = this._producer.produce()) == null) {
                            break block5;
                        }
                        if (!this._producer.isMoreToProduce()) break;
                        this._executor.execute(task);
                    }
                    task.run();
                }
                finally {
                    this._producer.onCompleted();
                }
            }
        }
    }

    public static interface Producer {
        public Runnable produce();

        public boolean isMoreToProduce();

        public void onCompleted();
    }
}

