/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import org.eclipse.jetty.start.StartLog;

public class PathMatchers {
    private static final char[] GLOB_CHARS = "*?".toCharArray();
    private static final char[] SYNTAXED_GLOB_CHARS = "{}[]|:".toCharArray();
    private static final Path EMPTY_PATH = Paths.get(".", new String[0]);

    private static Path asPath(String pattern) {
        String test = pattern;
        if (test.startsWith("glob:")) {
            test = test.substring("glob:".length());
        } else if (test.startsWith("regex:")) {
            test = test.substring("regex:".length());
        }
        return Paths.get(test, new String[0]);
    }

    public static PathMatcher getMatcher(String rawpattern) {
        FileSystem fs = FileSystems.getDefault();
        String pattern = rawpattern;
        char lastchar = pattern.charAt(pattern.length() - 1);
        if (lastchar == '/' || lastchar == '\\') {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        if (pattern.startsWith("glob:") || pattern.startsWith("regex:")) {
            StartLog.debug("Using Standard %s pattern: %s", fs.getClass().getName(), pattern);
            return fs.getPathMatcher(pattern);
        }
        if (PathMatchers.isAbsolute(pattern)) {
            String pat = "glob:" + pattern;
            StartLog.debug("Using absolute path pattern: %s", pat);
            return fs.getPathMatcher(pat);
        }
        String pat = "glob:**/" + pattern;
        StartLog.debug("Using relative path pattern: %s", pat);
        return fs.getPathMatcher(pat);
    }

    public static PathMatcher getNonHidden() {
        return new NonHiddenMatcher();
    }

    public static Path getSearchRoot(String pattern) {
        String rootPath;
        StringBuilder root = new StringBuilder();
        int start = 0;
        boolean syntaxed = false;
        if (pattern.startsWith("glob:")) {
            start = "glob:".length();
            syntaxed = true;
        } else if (pattern.startsWith("regex:")) {
            start = "regex:".length();
            syntaxed = true;
        }
        int len = pattern.length();
        int lastSep = 0;
        for (int i = start; i < len; ++i) {
            int cp = pattern.codePointAt(i);
            if (cp < 127) {
                char c = (char)cp;
                if (c == '/') {
                    root.append(c);
                    lastSep = root.length();
                    continue;
                }
                if (c == '\\') {
                    root.append("\\");
                    lastSep = root.length();
                    int count = PathMatchers.countChars(pattern, i + 1, '\\');
                    if (count <= 0) continue;
                    i += count;
                    continue;
                }
                if (PathMatchers.isGlob(c, syntaxed)) break;
                root.append(c);
                continue;
            }
            root.appendCodePoint(cp);
        }
        if ((rootPath = root.substring(0, lastSep)).length() <= 0) {
            return EMPTY_PATH;
        }
        return PathMatchers.asPath(rootPath);
    }

    private static int countChars(String pattern, int offset, char c) {
        int count = 0;
        int len = pattern.length();
        for (int i = offset; i < len && pattern.charAt(i) == c; ++i) {
            ++count;
        }
        return count;
    }

    public static boolean isAbsolute(String pattern) {
        Path searchRoot = PathMatchers.getSearchRoot(pattern);
        if (searchRoot == EMPTY_PATH) {
            return false;
        }
        return searchRoot.isAbsolute();
    }

    private static boolean isGlob(char c, boolean syntaxed) {
        for (char g : GLOB_CHARS) {
            if (c != g) continue;
            return true;
        }
        if (syntaxed) {
            for (char g : SYNTAXED_GLOB_CHARS) {
                if (c != g) continue;
                return true;
            }
        }
        return false;
    }

    private static class NonHiddenMatcher
    implements PathMatcher {
        private NonHiddenMatcher() {
        }

        @Override
        public boolean matches(Path path) {
            try {
                return !Files.isHidden(path);
            }
            catch (IOException e) {
                StartLog.debug(e);
                return false;
            }
        }
    }
}

