/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.CommandLineBuilder;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.StartEnvironment;
import org.eclipse.jetty.start.StartLog;

class JPMSArgs {
    private final Set<String> _adds = new LinkedHashSet<String>();
    private final Map<String, Set<String>> _patches = new LinkedHashMap<String, Set<String>>();
    private final Map<String, Set<String>> _opens = new LinkedHashMap<String, Set<String>>();
    private final Map<String, Set<String>> _exports = new LinkedHashMap<String, Set<String>>();
    private final Map<String, Set<String>> _reads = new LinkedHashMap<String, Set<String>>();

    JPMSArgs() {
    }

    void collect(Module module, StartEnvironment environment) throws IOException {
        for (String jpmsArg : module.getJPMS()) {
            jpmsArg = environment.getProperties().expand(jpmsArg);
            String directive = "add-modules:";
            if (jpmsArg.startsWith("add-modules:")) {
                String[] names = jpmsArg.substring(directive.length()).split(",");
                Arrays.stream(names).map(String::trim).collect(Collectors.toCollection(() -> this._adds));
                continue;
            }
            directive = "patch-module:";
            if (jpmsArg.startsWith("patch-module:")) {
                this.parseJPMSKeyValue(environment.getBaseHome(), module, jpmsArg, directive, true, this._patches);
                continue;
            }
            directive = "add-opens:";
            if (jpmsArg.startsWith("add-opens:")) {
                this.parseJPMSKeyValue(environment.getBaseHome(), module, jpmsArg, directive, false, this._opens);
                continue;
            }
            directive = "add-exports:";
            if (jpmsArg.startsWith("add-exports:")) {
                this.parseJPMSKeyValue(environment.getBaseHome(), module, jpmsArg, directive, false, this._exports);
                continue;
            }
            directive = "add-reads:";
            if (jpmsArg.startsWith("add-reads:")) {
                this.parseJPMSKeyValue(environment.getBaseHome(), module, jpmsArg, directive, false, this._reads);
                continue;
            }
            throw new IllegalArgumentException("Invalid [jpms] directive " + directive + " in module " + module.getName() + ": " + jpmsArg);
        }
        StartLog.debug("Expanded JPMS directives for module %s:%n  add-modules: %s%n  patch-modules: %s%n  add-opens: %s%n  add-exports: %s%n  add-reads: %s", module, this._adds, this._patches, this._opens, this._exports, this._reads);
    }

    private void parseJPMSKeyValue(BaseHome baseHome, Module module, String line, String directive, boolean valueIsFile, Map<String, Set<String>> output) throws IOException {
        String valueString = line.substring(directive.length());
        int equals = valueString.indexOf(61);
        if (equals <= 0) {
            throw new IllegalArgumentException("Invalid [jpms] directive " + directive + " in module " + module.getName() + ": " + line);
        }
        String delimiter = valueIsFile ? FS.pathSeparator() : ",";
        String key = valueString.substring(0, equals).trim();
        String[] values = valueString.substring(equals + 1).split(delimiter);
        Set result = output.computeIfAbsent(key, k -> new LinkedHashSet());
        for (String value : values) {
            value = value.trim();
            if (valueIsFile) {
                List<Path> paths = baseHome.getPaths(value);
                paths.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.toCollection(() -> result));
                continue;
            }
            result.add(value);
        }
    }

    void toCommandLine(CommandLineBuilder cmd) {
        if (!this._adds.isEmpty()) {
            cmd.addOption("--add-modules");
            cmd.addArg(String.join((CharSequence)",", this._adds));
        }
        for (Map.Entry<String, Set<String>> entry : this._patches.entrySet()) {
            cmd.addOption("--patch-module");
            cmd.addArg(entry.getKey(), String.join((CharSequence)File.pathSeparator, (Iterable<? extends CharSequence>)entry.getValue()));
        }
        for (Map.Entry<String, Set<String>> entry : this._opens.entrySet()) {
            cmd.addOption("--add-opens");
            cmd.addArg(entry.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
        }
        for (Map.Entry<String, Set<String>> entry : this._exports.entrySet()) {
            cmd.addOption("--add-exports");
            cmd.addArg(entry.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
        }
        for (Map.Entry<String, Set<String>> entry : this._reads.entrySet()) {
            cmd.addOption("--add-reads");
            cmd.addArg(entry.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
        }
    }
}

