/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.fileinits;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileInitializer;
import org.eclipse.jetty.start.StartLog;

public class LocalFileInitializer
extends FileInitializer {
    public LocalFileInitializer(BaseHome basehome) {
        super(basehome, new String[0]);
    }

    @Override
    public boolean create(URI uri, String location) throws IOException {
        Path destination = this.getDestination(uri, location);
        if (destination == null) {
            StartLog.error("Bad file arg %s", uri);
            return false;
        }
        boolean isDir = location.endsWith("/");
        if (FS.exists(destination)) {
            if (isDir) {
                if (!Files.isDirectory(destination, new LinkOption[0])) {
                    throw new IOException("Invalid: path should be a directory (but isn't): " + location);
                }
                if (!FS.canReadDirectory(destination)) {
                    throw new IOException("Unable to read directory: " + location);
                }
            } else if (!FS.canReadFile(destination)) {
                throw new IOException("Unable to read file: " + location);
            }
            return false;
        }
        if (isDir) {
            boolean mkdir = FS.ensureDirectoryExists(destination);
            if (mkdir) {
                StartLog.info("mkdir %s", this._basehome.toShortForm(destination));
            }
            return mkdir;
        }
        throw new IOException("Unable to create " + this._basehome.toShortForm(destination));
    }
}

