/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spring;

import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.xml.ConfigurationProcessor;
import org.eclipse.jetty.xml.XmlParser;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SpringConfigurationProcessor
implements ConfigurationProcessor {
    private static final Logger LOG = Log.getLogger(SpringConfigurationProcessor.class);
    private Map<String, Object> _idMap;
    private Map<String, String> _propertyMap;
    private XmlBeanFactory _beanFactory;
    private String _main;

    public void init(URL url, XmlParser.Node config, Map<String, Object> idMap, Map<String, String> properties) {
        try {
            this._idMap = idMap;
            this._propertyMap = properties;
            UrlResource resource = url != null ? new UrlResource(url) : new ByteArrayResource(("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE beans PUBLIC \"-//SPRING//DTD BEAN//EN\" \"http://www.springframework.org/dtd/spring-beans.dtd\">" + config).getBytes("UTF-8"));
            this._beanFactory = new XmlBeanFactory((Resource)resource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object configure(Object obj) throws Exception {
        this.doConfigure();
        return this._beanFactory.configureBean(obj, this._main);
    }

    public Object configure() throws Exception {
        this.doConfigure();
        return this._beanFactory.getBean(this._main);
    }

    private void doConfigure() {
        this._beanFactory.registerSingleton("properties", this._propertyMap);
        for (String bean : this._beanFactory.getBeanDefinitionNames()) {
            LOG.debug("{} - {}", new Object[]{bean, Arrays.asList(this._beanFactory.getAliases(bean))});
            String[] aliases = this._beanFactory.getAliases(bean);
            if (!"Main".equals(bean) && (aliases == null || !Arrays.asList(aliases).contains("Main"))) continue;
            this._main = bean;
            break;
        }
        if (this._main == null) {
            this._main = this._beanFactory.getBeanDefinitionNames()[0];
        }
        LOG.debug("idMap {}", new Object[]{this._idMap});
        for (String id : this._idMap.keySet()) {
            LOG.debug("register {}", new Object[]{id});
            this._beanFactory.registerSingleton(id, this._idMap.get(id));
        }
        for (String id : this._idMap.keySet()) {
            if (!this._beanFactory.containsBeanDefinition(id)) continue;
            LOG.debug("reconfigure {}", new Object[]{id});
            this._beanFactory.configureBean(this._idMap.get(id), id);
        }
        for (String id : this._beanFactory.getSingletonNames()) {
            this._idMap.put(id, this._beanFactory.getBean(id));
        }
    }
}

