/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Push cache based on the HTTP 'Referer' header")
public class PushCacheFilter
implements Filter {
    private static final Logger LOG = Log.getLogger(PushCacheFilter.class);
    private final ConcurrentMap<String, PrimaryResource> _cache = new ConcurrentHashMap<String, PrimaryResource>();
    private long _associatePeriod = 4000L;
    private volatile long _renew = System.nanoTime();
    private String _renewPath = "/__renewPushCache__";
    private final Set<Integer> _ports = new HashSet<Integer>();
    private final Set<String> _hosts = new HashSet<String>();

    public void init(FilterConfig config) throws ServletException {
        String ports;
        String hosts;
        String renew;
        String associatePeriod = config.getInitParameter("associatePeriod");
        if (associatePeriod != null) {
            this._associatePeriod = Long.valueOf(associatePeriod);
        }
        if ((renew = config.getInitParameter("renewPath")) != null) {
            this._renewPath = renew;
        }
        if ((hosts = config.getInitParameter("hosts")) != null) {
            for (String h : hosts.split(",")) {
                this._hosts.add(h);
            }
        }
        if ((ports = config.getInitParameter("ports")) != null) {
            for (String p : ports.split(",")) {
                this._ports.add(Integer.parseInt(p));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("p={} renew={} hosts={} ports={}", new Object[]{this._associatePeriod, this._renewPath, this._hosts, this._ports});
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        PrimaryResource primaryResource;
        String path;
        long now = System.nanoTime();
        HttpServletRequest request = (HttpServletRequest)req;
        if (Boolean.TRUE == req.getAttribute("org.eclipse.jetty.pushed")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("PUSH {}", new Object[]{request.getRequestURI()});
            }
            chain.doFilter(req, resp);
            return;
        }
        HttpFields fields = Request.getBaseRequest((ServletRequest)req).getHttpFields();
        boolean conditional = false;
        String referrer = null;
        block4: for (int i = 0; i < fields.size(); ++i) {
            HttpField field = fields.getField(i);
            HttpHeader header = field.getHeader();
            if (header == null) continue;
            switch (header) {
                case IF_MATCH: 
                case IF_MODIFIED_SINCE: 
                case IF_NONE_MATCH: 
                case IF_UNMODIFIED_SINCE: {
                    conditional = true;
                    break block4;
                }
                case REFERER: {
                    referrer = field.getValue();
                }
                default: {
                    continue block4;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} referrer={} conditional={}", new Object[]{request.getMethod(), request.getRequestURI(), referrer, conditional});
        }
        if ((path = URIUtil.addPaths((String)request.getServletPath(), (String)request.getPathInfo())).endsWith(this._renewPath)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Renew {}", now);
            }
            this._renew = now;
            resp.getOutputStream().print("PUSH CACHE RESET");
            resp.flushBuffer();
            return;
        }
        if (referrer != null) {
            boolean referred_from_here;
            HttpURI referrerURI = new HttpURI(referrer);
            String host = referrerURI.getHost();
            int port = referrerURI.getPort();
            if (port <= 0) {
                port = request.isSecure() ? 443 : 80;
            }
            boolean bl = referred_from_here = this._hosts.size() > 0 ? this._hosts.contains(host) : request.getServerName().equals(host);
            if (referred_from_here &= this._ports.size() > 0 ? this._ports.contains(port) : port == request.getServerPort()) {
                long primaryTimestamp;
                String referrerPathNoContext;
                PrimaryResource primaryResource2;
                String referrerPath = referrerURI.getPath();
                if (referrerPath.startsWith(request.getContextPath()) && (primaryResource2 = (PrimaryResource)this._cache.get(referrerPathNoContext = referrerPath.substring(request.getContextPath().length()))) != null && (primaryTimestamp = primaryResource2._timestamp.get()) != 0L) {
                    RequestDispatcher dispatcher = request.getServletContext().getRequestDispatcher(path);
                    if (now - primaryTimestamp < TimeUnit.MILLISECONDS.toNanos(this._associatePeriod)) {
                        if (primaryResource2._associated.putIfAbsent(path, dispatcher) == null && LOG.isDebugEnabled()) {
                            LOG.debug("Associated {} -> {}", new Object[]{referrerPathNoContext, dispatcher});
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Not associated {} -> {}, outside associate period of {}ms", new Object[]{referrerPathNoContext, dispatcher, this._associatePeriod});
                    }
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("External referrer {}", new Object[]{referrer});
            }
        }
        if ((primaryResource = (PrimaryResource)this._cache.get(path)) == null) {
            PrimaryResource t = new PrimaryResource();
            primaryResource = this._cache.putIfAbsent(path, t);
            primaryResource = primaryResource == null ? t : primaryResource;
            primaryResource._timestamp.compareAndSet(0L, now);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cached {}", new Object[]{path});
            }
        } else {
            long last = primaryResource._timestamp.get();
            if (last < this._renew && primaryResource._timestamp.compareAndSet(last, now)) {
                primaryResource._associated.clear();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Clear associated {}", new Object[]{path});
                }
            }
        }
        if (!conditional && !primaryResource._associated.isEmpty()) {
            for (RequestDispatcher dispatcher : primaryResource._associated.values()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Pushing {} <- {}", new Object[]{dispatcher, path});
                }
                ((Dispatcher)dispatcher).push((ServletRequest)request);
            }
        }
        chain.doFilter(req, resp);
    }

    public void destroy() {
        this._cache.clear();
    }

    @ManagedAttribute(value="The push cache contents")
    public Map<String, String> getCache() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : this._cache.entrySet()) {
            PrimaryResource resource = (PrimaryResource)entry.getValue();
            String value = String.format("size=%d: %s", resource._associated.size(), new TreeSet(resource._associated.keySet()));
            result.put((String)entry.getKey(), value);
        }
        return result;
    }

    private static class PrimaryResource {
        private final ConcurrentMap<String, RequestDispatcher> _associated = new ConcurrentHashMap<String, RequestDispatcher>();
        private final AtomicLong _timestamp = new AtomicLong();

        private PrimaryResource() {
        }
    }
}

