/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GzipOutputStream
extends DeflaterOutputStream {
    private static final byte[] GZIP_HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
    private final CRC32 _crc = new CRC32();

    public GzipOutputStream(OutputStream out, Deflater deflater, int size) throws IOException {
        super(out, deflater, size);
        out.write(GZIP_HEADER);
    }

    @Override
    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        super.write(buf, off, len);
        this._crc.update(buf, off, len);
    }

    @Override
    public void finish() throws IOException {
        if (!this.def.finished()) {
            super.finish();
            byte[] trailer = new byte[8];
            this.writeInt((int)this._crc.getValue(), trailer, 0);
            this.writeInt(this.def.getTotalIn(), trailer, 4);
            this.out.write(trailer);
        }
    }

    private void writeInt(int i, byte[] buf, int offset) {
        int o = offset;
        buf[o++] = (byte)(i & 0xFF);
        buf[o++] = (byte)(i >>> 8 & 0xFF);
        buf[o++] = (byte)(i >>> 16 & 0xFF);
        buf[o++] = (byte)(i >>> 24 & 0xFF);
    }
}

