/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.ByteBuffer;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.StatisticsServlet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.InputSource;

public class StatisticsServletTest {
    private Server _server;
    private LocalConnector _connector;

    @BeforeEach
    public void createServer() {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        this._server.addConnector((Connector)this._connector);
    }

    @AfterEach
    public void destroyServer() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void getStats() throws Exception {
        StatisticsHandler statsHandler = new StatisticsHandler();
        this._server.setHandler((Handler)statsHandler);
        ServletContextHandler statsContext = new ServletContextHandler((HandlerContainer)statsHandler, "/");
        statsContext.addServlet(new ServletHolder((Servlet)new TestServlet()), "/test1");
        ServletHolder servletHolder = new ServletHolder((Servlet)new StatisticsServlet());
        servletHolder.setInitParameter("restrictToLocalhost", "false");
        statsContext.addServlet(servletHolder, "/stats");
        statsContext.setSessionHandler(new SessionHandler());
        this._server.start();
        this.getResponse("/test1");
        String response = this.getResponse("/stats?xml=true");
        Stats stats = this.parseStats(response);
        Assertions.assertEquals((int)1, (int)stats.responses2xx);
        this.getResponse("/stats?statsReset=true");
        response = this.getResponse("/stats?xml=true");
        stats = this.parseStats(response);
        Assertions.assertEquals((int)1, (int)stats.responses2xx);
        this.getResponse("/test1");
        this.getResponse("/nothing");
        response = this.getResponse("/stats?xml=true");
        stats = this.parseStats(response);
        MatcherAssert.assertThat((String)("2XX Response Count" + response), (Object)stats.responses2xx, (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((String)("4XX Response Count" + response), (Object)stats.responses4xx, (Matcher)Matchers.is((Object)1));
    }

    public String getResponse(String path) throws Exception {
        HttpTester.Request request = new HttpTester.Request();
        request.setMethod("GET");
        request.setURI(path);
        request.setVersion(HttpVersion.HTTP_1_1);
        request.setHeader("Host", "test");
        ByteBuffer responseBuffer = this._connector.getResponse(request.generate());
        return HttpTester.parseResponse((ByteBuffer)responseBuffer).getContent();
    }

    public Stats parseStats(String xml) throws Exception {
        XPath xPath = XPathFactory.newInstance().newXPath();
        String responses4xx = xPath.evaluate("//responses4xx", new InputSource(new StringReader(xml)));
        String responses2xx = xPath.evaluate("//responses2xx", new InputSource(new StringReader(xml)));
        return new Stats(Integer.parseInt(responses2xx), Integer.parseInt(responses4xx));
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
            PrintWriter writer = resp.getWriter();
            writer.write("Yup!!");
        }
    }

    public static class Stats {
        int responses2xx;
        int responses4xx;

        public Stats(int responses2xx, int responses4xx) {
            this.responses2xx = responses2xx;
            this.responses4xx = responses4xx;
        }
    }
}

