/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.servlet.Source;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ServletHandlerTest {
    FilterHolder fh1 = new FilterHolder(new Source(Source.Origin.DESCRIPTOR, "foo.xml"));
    FilterMapping fm1 = new FilterMapping();
    FilterHolder fh2 = new FilterHolder(new Source(Source.Origin.DESCRIPTOR, "foo.xml"));
    FilterMapping fm2 = new FilterMapping();
    FilterHolder fh3 = new FilterHolder(Source.JAVAX_API);
    FilterMapping fm3 = new FilterMapping();
    FilterHolder fh4 = new FilterHolder(Source.JAVAX_API);
    FilterMapping fm4 = new FilterMapping();
    FilterHolder fh5 = new FilterHolder(Source.JAVAX_API);
    FilterMapping fm5 = new FilterMapping();
    ServletHolder sh1 = new ServletHolder(new Source(Source.Origin.DESCRIPTOR, "foo.xml"));
    ServletMapping sm1 = new ServletMapping();
    ServletHolder sh2 = new ServletHolder(new Source(Source.Origin.DESCRIPTOR, "foo.xml"));
    ServletMapping sm2 = new ServletMapping();
    ServletHolder sh3 = new ServletHolder(new Source(Source.Origin.DESCRIPTOR, "foo.xml"));
    ServletMapping sm3 = new ServletMapping();

    @BeforeEach
    public void initMappings() {
        this.fh1.setName("fh1");
        this.fm1.setPathSpec("/*");
        this.fm1.setFilterHolder(this.fh1);
        this.fh2.setName("fh2");
        this.fm2.setPathSpec("/*");
        this.fm2.setFilterHolder(this.fh2);
        this.fh3.setName("fh3");
        this.fm3.setPathSpec("/*");
        this.fm3.setFilterHolder(this.fh3);
        this.fh4.setName("fh4");
        this.fm4.setPathSpec("/*");
        this.fm4.setFilterHolder(this.fh4);
        this.fh5.setName("fh5");
        this.fm5.setPathSpec("/*");
        this.fm5.setFilterHolder(this.fh5);
        this.sh1.setName("s1");
        this.sm1.setDefault(false);
        this.sm1.setPathSpec("/foo/*");
        this.sm1.setServletName("s1");
        this.sh2.setName("s2");
        this.sm2.setDefault(false);
        this.sm2.setPathSpec("/foo/*");
        this.sm2.setServletName("s2");
        this.sh3.setName("s3");
        this.sm3.setDefault(true);
        this.sm3.setPathSpec("/foo/*");
        this.sm3.setServletName("s3");
    }

    @Test
    public void testAddFilterIgnoresDuplicates() throws Exception {
        ServletHandler handler = new ServletHandler();
        FilterHolder h = new FilterHolder();
        h.setName("x");
        handler.addFilter(h);
        FilterHolder[] holders = handler.getFilters();
        Assertions.assertNotNull((Object)holders);
        Assertions.assertTrue((holders[0] == h ? 1 : 0) != 0);
        handler.addFilter(h);
        holders = handler.getFilters();
        Assertions.assertNotNull((Object)holders);
        Assertions.assertTrue((holders.length == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((holders[0] == h ? 1 : 0) != 0);
        FilterHolder h2 = new FilterHolder();
        h2.setName("x");
        handler.addFilter(h2);
        holders = handler.getFilters();
        Assertions.assertNotNull((Object)holders);
        Assertions.assertTrue((holders.length == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((holders[1] == h2 ? 1 : 0) != 0);
    }

    @Test
    public void testAddFilterIgnoresDuplicates2() throws Exception {
        ServletHandler handler = new ServletHandler();
        FilterHolder h = new FilterHolder();
        h.setName("x");
        FilterMapping m = new FilterMapping();
        m.setPathSpec("/*");
        m.setFilterHolder(h);
        handler.addFilter(h, m);
        FilterHolder[] holders = handler.getFilters();
        Assertions.assertNotNull((Object)holders);
        Assertions.assertTrue((holders[0] == h ? 1 : 0) != 0);
        FilterMapping m2 = new FilterMapping();
        m2.setPathSpec("/*");
        m2.setFilterHolder(h);
        handler.addFilter(h, m2);
        holders = handler.getFilters();
        Assertions.assertNotNull((Object)holders);
        Assertions.assertTrue((holders.length == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((holders[0] == h ? 1 : 0) != 0);
        FilterHolder h2 = new FilterHolder();
        h2.setName("x");
        FilterMapping m3 = new FilterMapping();
        m3.setPathSpec("/*");
        m3.setFilterHolder(h);
        handler.addFilter(h2, m3);
        holders = handler.getFilters();
        Assertions.assertNotNull((Object)holders);
        Assertions.assertTrue((holders.length == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((holders[1] == h2 ? 1 : 0) != 0);
    }

    @Test
    public void testAddFilterWithMappingIgnoresDuplicateFilters() throws Exception {
        ServletHandler handler = new ServletHandler();
        FilterHolder h = new FilterHolder();
        h.setName("x");
        handler.addFilterWithMapping(h, "/*", 0);
        FilterHolder[] holders = handler.getFilters();
        Assertions.assertNotNull((Object)holders);
        Assertions.assertTrue((holders[0] == h ? 1 : 0) != 0);
        handler.addFilterWithMapping(h, "/*", 1);
        holders = handler.getFilters();
        Assertions.assertNotNull((Object)holders);
        Assertions.assertTrue((holders.length == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((holders[0] == h ? 1 : 0) != 0);
        FilterHolder h2 = new FilterHolder();
        h2.setName("x");
        handler.addFilterWithMapping(h2, "/*", 0);
        holders = handler.getFilters();
        Assertions.assertNotNull((Object)holders);
        Assertions.assertTrue((holders.length == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((holders[1] == h2 ? 1 : 0) != 0);
    }

    @Test
    public void testAddFilterWithMappingIngoresDuplicateFilters2() throws Exception {
        ServletHandler handler = new ServletHandler();
        FilterHolder h = new FilterHolder();
        h.setName("x");
        handler.addFilterWithMapping(h, "/*", EnumSet.allOf(DispatcherType.class));
        FilterHolder[] holders = handler.getFilters();
        Assertions.assertNotNull((Object)holders);
        Assertions.assertTrue((holders[0] == h ? 1 : 0) != 0);
        handler.addFilterWithMapping(h, "/x", EnumSet.allOf(DispatcherType.class));
        holders = handler.getFilters();
        Assertions.assertNotNull((Object)holders);
        Assertions.assertTrue((holders.length == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((holders[0] == h ? 1 : 0) != 0);
        FilterHolder h2 = new FilterHolder();
        h2.setName("x");
        handler.addFilterWithMapping(h2, "/*", EnumSet.allOf(DispatcherType.class));
        holders = handler.getFilters();
        Assertions.assertNotNull((Object)holders);
        Assertions.assertTrue((holders.length == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((holders[1] == h2 ? 1 : 0) != 0);
    }

    @Test
    public void testDuplicateMappingsForbidden() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.setAllowDuplicateMappings(false);
        handler.addServlet(this.sh1);
        handler.addServlet(this.sh2);
        handler.updateNameMappings();
        handler.addServletMapping(this.sm1);
        handler.addServletMapping(this.sm2);
        try {
            handler.updateMappings();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testDuplicateMappingsWithDefaults() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.setAllowDuplicateMappings(false);
        handler.addServlet(this.sh1);
        handler.addServlet(this.sh3);
        handler.updateNameMappings();
        handler.addServletMapping(this.sm3);
        handler.addServletMapping(this.sm1);
        handler.updateMappings();
        MappedResource entry = handler.getMappedServlet("/foo/*");
        Assertions.assertNotNull((Object)entry);
        Assertions.assertEquals((Object)"s1", (Object)((ServletHolder)entry.getResource()).getName());
    }

    @Test
    public void testDuplicateMappingsSameServlet() throws Exception {
        ServletHolder sh4 = new ServletHolder();
        sh4.setName("s1");
        ServletMapping sm4 = new ServletMapping();
        sm4.setPathSpec("/foo/*");
        sm4.setServletName("s1");
        ServletHandler handler = new ServletHandler();
        handler.setAllowDuplicateMappings(true);
        handler.addServlet(this.sh1);
        handler.addServlet(sh4);
        handler.updateNameMappings();
        handler.addServletMapping(this.sm1);
        handler.addServletMapping(sm4);
        handler.updateMappings();
    }

    @Test
    public void testDuplicateMappingsAllowed() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.setAllowDuplicateMappings(true);
        handler.addServlet(this.sh1);
        handler.addServlet(this.sh2);
        handler.updateNameMappings();
        handler.addServletMapping(this.sm1);
        handler.addServletMapping(this.sm2);
        handler.updateMappings();
        MappedResource entry = handler.getMappedServlet("/foo/*");
        Assertions.assertNotNull((Object)entry);
        Assertions.assertEquals((Object)"s2", (Object)((ServletHolder)entry.getResource()).getName());
    }

    @Test
    public void testAllNonProgrammaticFilterMappings() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.addFilter(this.fh1);
        handler.addFilter(this.fh2);
        handler.addFilterMapping(this.fm1);
        handler.addFilterMapping(this.fm2);
        FilterMapping[] mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertTrue((this.fm1 == mappings[0] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm2 == mappings[1] ? 1 : 0) != 0);
        FilterHolder of1 = new FilterHolder(new Source(Source.Origin.DESCRIPTOR, "foo.xml"));
        FilterMapping ofm1 = new FilterMapping();
        ofm1.setFilterHolder(of1);
        ofm1.setPathSpec("/*");
        handler.addFilter(of1);
        handler.addFilterMapping(ofm1);
        mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertTrue((this.fm1 == mappings[0] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm2 == mappings[1] ? 1 : 0) != 0);
        Assertions.assertTrue((ofm1 == mappings[2] ? 1 : 0) != 0);
    }

    @Test
    public void testAllBeforeFilterMappings() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.addFilter(this.fh4);
        handler.prependFilterMapping(this.fm4);
        FilterMapping[] mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)1, (int)mappings.length);
        handler.addFilter(this.fh5);
        handler.prependFilterMapping(this.fm5);
        mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)2, (int)mappings.length);
        Assertions.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm5 == mappings[1] ? 1 : 0) != 0);
    }

    @Test
    public void testAllAfterFilterMappings() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.addFilter(this.fh4);
        handler.addFilterMapping(this.fm4);
        FilterMapping[] mappings = handler.getFilterMappings();
        Assertions.assertEquals((int)1, (int)mappings.length);
        Assertions.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        handler.addFilter(this.fh5);
        handler.addFilterMapping(this.fm5);
        mappings = handler.getFilterMappings();
        Assertions.assertEquals((int)2, (int)mappings.length);
        Assertions.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm5 == mappings[1] ? 1 : 0) != 0);
    }

    @Test
    public void testMatchAfterAndBefore() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.addFilter(this.fh3);
        handler.addFilterMapping(this.fm3);
        FilterMapping[] mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)1, (int)mappings.length);
        Assertions.assertTrue((this.fm3 == mappings[0] ? 1 : 0) != 0);
        handler.addFilter(this.fh4);
        handler.prependFilterMapping(this.fm4);
        mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)2, (int)mappings.length);
        Assertions.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm3 == mappings[1] ? 1 : 0) != 0);
    }

    @Test
    public void testMatchBeforeAndAfter() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.addFilter(this.fh3);
        handler.prependFilterMapping(this.fm3);
        FilterMapping[] mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)1, (int)mappings.length);
        Assertions.assertTrue((this.fm3 == mappings[0] ? 1 : 0) != 0);
        handler.addFilter(this.fh4);
        handler.addFilterMapping(this.fm4);
        mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)2, (int)mappings.length);
        Assertions.assertTrue((this.fm3 == mappings[0] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm4 == mappings[1] ? 1 : 0) != 0);
    }

    @Test
    public void testExistingFilterMappings() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.addFilter(this.fh1);
        handler.addFilter(this.fh2);
        handler.addFilterMapping(this.fm1);
        handler.addFilterMapping(this.fm2);
        FilterMapping[] mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertTrue((this.fm1 == mappings[0] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm2 == mappings[1] ? 1 : 0) != 0);
        handler.addFilter(this.fh4);
        handler.prependFilterMapping(this.fm4);
        mappings = handler.getFilterMappings();
        Assertions.assertEquals((int)3, (int)mappings.length);
        Assertions.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        handler.addFilter(this.fh5);
        handler.addFilterMapping(this.fm5);
        mappings = handler.getFilterMappings();
        Assertions.assertEquals((int)4, (int)mappings.length);
        Assertions.assertTrue((this.fm5 == mappings[mappings.length - 1] ? 1 : 0) != 0);
    }

    @Test
    public void testFilterMappingsMix() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.addFilter(this.fh1);
        handler.addFilterMapping(this.fm1);
        FilterMapping[] mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertTrue((this.fm1 == mappings[0] ? 1 : 0) != 0);
        handler.addFilter(this.fh4);
        handler.prependFilterMapping(this.fm4);
        mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)2, (int)mappings.length);
        Assertions.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm1 == mappings[1] ? 1 : 0) != 0);
        handler.addFilter(this.fh3);
        handler.addFilterMapping(this.fm3);
        mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)3, (int)mappings.length);
        Assertions.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm1 == mappings[1] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm3 == mappings[2] ? 1 : 0) != 0);
        handler.addFilter(this.fh5);
        handler.prependFilterMapping(this.fm5);
        mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)4, (int)mappings.length);
        Assertions.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm5 == mappings[1] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm1 == mappings[2] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm3 == mappings[3] ? 1 : 0) != 0);
        FilterHolder f = new FilterHolder(Source.EMBEDDED);
        f.setName("non-programmatic");
        FilterMapping fm = new FilterMapping();
        fm.setFilterHolder(f);
        fm.setPathSpec("/*");
        handler.addFilter(f);
        handler.addFilterMapping(fm);
        mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)5, (int)mappings.length);
        Assertions.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm5 == mappings[1] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm1 == mappings[2] ? 1 : 0) != 0);
        Assertions.assertTrue((fm == mappings[3] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm3 == mappings[4] ? 1 : 0) != 0);
        FilterHolder pf = new FilterHolder(Source.JAVAX_API);
        pf.setName("programmaticA");
        FilterMapping pfm = new FilterMapping();
        pfm.setFilterHolder(pf);
        pfm.setPathSpec("/*");
        handler.addFilter(pf);
        handler.addFilterMapping(pfm);
        mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)6, (int)mappings.length);
        Assertions.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm5 == mappings[1] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm1 == mappings[2] ? 1 : 0) != 0);
        Assertions.assertTrue((fm == mappings[3] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm3 == mappings[4] ? 1 : 0) != 0);
        Assertions.assertTrue((pfm == mappings[5] ? 1 : 0) != 0);
        FilterHolder pf2 = new FilterHolder(Source.JAVAX_API);
        pf2.setName("programmaticB");
        FilterMapping pfm2 = new FilterMapping();
        pfm2.setFilterHolder(pf2);
        pfm2.setPathSpec("/*");
        handler.addFilter(pf2);
        handler.prependFilterMapping(pfm2);
        mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)7, (int)mappings.length);
        Assertions.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm5 == mappings[1] ? 1 : 0) != 0);
        Assertions.assertTrue((pfm2 == mappings[2] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm1 == mappings[3] ? 1 : 0) != 0);
        Assertions.assertTrue((fm == mappings[4] ? 1 : 0) != 0);
        Assertions.assertTrue((this.fm3 == mappings[5] ? 1 : 0) != 0);
        Assertions.assertTrue((pfm == mappings[6] ? 1 : 0) != 0);
    }

    @Test
    public void testAddFilterWithMappingAPI() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.addFilterWithMapping(this.fh1, "/*", EnumSet.allOf(DispatcherType.class));
        handler.updateMappings();
        FilterMapping[] mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertTrue((this.fh1 == mappings[0].getFilterHolder() ? 1 : 0) != 0);
        this.fh4.setServletHandler(handler);
        handler.addFilter(this.fh4);
        this.fh4.getRegistration().addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/*"});
        handler.updateMappings();
        mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)2, (int)mappings.length);
        Assertions.assertTrue((this.fh4 == mappings[0].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((this.fh1 == mappings[1].getFilterHolder() ? 1 : 0) != 0);
        this.fh3.setServletHandler(handler);
        handler.addFilter(this.fh3);
        this.fh3.getRegistration().addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        handler.updateMappings();
        mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)3, (int)mappings.length);
        Assertions.assertTrue((this.fh4 == mappings[0].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((this.fh1 == mappings[1].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((this.fh3 == mappings[2].getFilterHolder() ? 1 : 0) != 0);
        this.fh5.setServletHandler(handler);
        handler.addFilter(this.fh5);
        this.fh5.getRegistration().addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/*"});
        handler.updateMappings();
        mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)4, (int)mappings.length);
        Assertions.assertTrue((this.fh4 == mappings[0].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((this.fh5 == mappings[1].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((this.fh1 == mappings[2].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((this.fh3 == mappings[3].getFilterHolder() ? 1 : 0) != 0);
        FilterHolder f = new FilterHolder(Source.EMBEDDED);
        f.setName("non-programmatic");
        handler.addFilterWithMapping(f, "/*", EnumSet.allOf(DispatcherType.class));
        handler.updateMappings();
        mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)5, (int)mappings.length);
        Assertions.assertTrue((this.fh4 == mappings[0].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((this.fh5 == mappings[1].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((this.fh1 == mappings[2].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((f == mappings[3].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((this.fh3 == mappings[4].getFilterHolder() ? 1 : 0) != 0);
        FilterHolder pf = new FilterHolder(Source.JAVAX_API);
        pf.setServletHandler(handler);
        pf.setName("programmaticA");
        handler.addFilter(pf);
        pf.getRegistration().addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        handler.updateMappings();
        mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)6, (int)mappings.length);
        Assertions.assertTrue((this.fh4 == mappings[0].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((this.fh5 == mappings[1].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((this.fh1 == mappings[2].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((f == mappings[3].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((this.fh3 == mappings[4].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((pf == mappings[5].getFilterHolder() ? 1 : 0) != 0);
        FilterHolder pf2 = new FilterHolder(Source.JAVAX_API);
        pf2.setServletHandler(handler);
        pf2.setName("programmaticB");
        handler.addFilter(pf2);
        pf2.getRegistration().addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/*"});
        handler.updateMappings();
        mappings = handler.getFilterMappings();
        Assertions.assertNotNull((Object)mappings);
        Assertions.assertEquals((int)7, (int)mappings.length);
        Assertions.assertTrue((this.fh4 == mappings[0].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((this.fh5 == mappings[1].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((pf2 == mappings[2].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((this.fh1 == mappings[3].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((f == mappings[4].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((this.fh3 == mappings[5].getFilterHolder() ? 1 : 0) != 0);
        Assertions.assertTrue((pf == mappings[6].getFilterHolder() ? 1 : 0) != 0);
    }
}

