/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ErrorPageTest {
    private Server _server;
    private LocalConnector _connector;
    private StacklessLogging _stackless;

    @BeforeEach
    public void init() throws Exception {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        ServletContextHandler context = new ServletContextHandler(0);
        this._server.addConnector((Connector)this._connector);
        this._server.setHandler((Handler)context);
        context.setContextPath("/");
        context.addServlet(DefaultServlet.class, "/");
        context.addServlet(FailServlet.class, "/fail/*");
        context.addServlet(FailClosedServlet.class, "/fail-closed/*");
        context.addServlet(ErrorServlet.class, "/error/*");
        context.addServlet(AppServlet.class, "/app/*");
        context.addServlet(LongerAppServlet.class, "/longer.app/*");
        ErrorPageErrorHandler error = new ErrorPageErrorHandler();
        context.setErrorHandler((ErrorHandler)error);
        error.addErrorPage(599, "/error/599");
        error.addErrorPage(400, "/error/400");
        error.addErrorPage(IllegalStateException.class.getCanonicalName(), "/error/TestException");
        error.addErrorPage(BadMessageException.class, "/error/BadMessageException");
        error.addErrorPage("org.eclipse.jetty.server.error_page.global", "/error/GlobalErrorPage");
        this._server.start();
        this._stackless = new StacklessLogging(new Class[]{ServletHandler.class});
    }

    @AfterEach
    public void destroy() throws Exception {
        this._stackless.close();
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testSendErrorClosedResponse() throws Exception {
        String response = this._connector.getResponse("GET /fail-closed/ HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 599 599"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"DISPATCH: ERROR"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /599"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 599"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$FailClosedServlet-"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /fail-closed/"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"This shouldn't be seen")));
    }

    @Test
    public void testErrorCode() throws Exception {
        String response = this._connector.getResponse("GET /fail/code?code=599 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 599 599"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /599"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 599"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$FailServlet-"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /fail/code"));
    }

    @Test
    public void testErrorException() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannel.class});){
            String response = this._connector.getResponse("GET /fail/exception HTTP/1.0\r\n\r\n");
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 Server Error"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /TestException"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 500"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: javax.servlet.ServletException: java.lang.IllegalStateException"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: class javax.servlet.ServletException"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$FailServlet-"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /fail/exception"));
        }
    }

    @Test
    public void testGlobalErrorCode() throws Exception {
        String response = this._connector.getResponse("GET /fail/global?code=598 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 598 598"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /GlobalErrorPage"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 598"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$FailServlet-"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /fail/global"));
    }

    @Test
    public void testGlobalErrorException() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannel.class});){
            String response = this._connector.getResponse("GET /fail/global?code=NAN HTTP/1.0\r\n\r\n");
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 Server Error"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /GlobalErrorPage"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 500"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: java.lang.NumberFormatException: For input string: \"NAN\""));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: class java.lang.NumberFormatException"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$FailServlet-"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /fail/global"));
        }
    }

    @Test
    public void testBadMessage() throws Exception {
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{Dispatcher.class});){
            String response = this._connector.getResponse("GET /app?baa=%88%A4 HTTP/1.0\r\n\r\n");
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 400 Bad query encoding"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /BadMessageException"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_MESSAGE: Bad query encoding"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 400"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: org.eclipse.jetty.http.BadMessageException: 400: Bad query encoding"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: class org.eclipse.jetty.http.BadMessageException"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$AppServlet-"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /app"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"getParameterMap()= {}"));
        }
    }

    public static class ErrorServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter writer = response.getWriter();
            writer.println("DISPATCH: " + request.getDispatcherType().name());
            writer.println("ERROR_PAGE: " + request.getPathInfo());
            writer.println("ERROR_MESSAGE: " + request.getAttribute("javax.servlet.error.message"));
            writer.println("ERROR_CODE: " + request.getAttribute("javax.servlet.error.status_code"));
            writer.println("ERROR_EXCEPTION: " + request.getAttribute("javax.servlet.error.exception"));
            writer.println("ERROR_EXCEPTION_TYPE: " + request.getAttribute("javax.servlet.error.exception_type"));
            writer.println("ERROR_SERVLET: " + request.getAttribute("javax.servlet.error.servlet_name"));
            writer.println("ERROR_REQUEST_URI: " + request.getAttribute("javax.servlet.error.request_uri"));
            writer.println("getParameterMap()= " + request.getParameterMap());
        }
    }

    public static class FailClosedServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.sendError(599);
            try {
                response.setStatus(200);
                response.getWriter().append("This shouldn't be seen");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class FailServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String code = request.getParameter("code");
            if (code == null) {
                throw new ServletException((Throwable)new IllegalStateException());
            }
            response.sendError(Integer.parseInt(code));
        }
    }

    public static class LongerAppServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter writer = response.getWriter();
            writer.println(request.getRequestURI());
        }
    }

    public static class AppServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            request.getRequestDispatcher("/longer.app/").forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

