/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AsyncContextDispatchWithQueryStrings {
    private Server _server = new Server();
    private ServletContextHandler _contextHandler = new ServletContextHandler(0);
    private LocalConnector _connector = new LocalConnector(this._server);

    @BeforeEach
    public void setUp() throws Exception {
        this._connector.setIdleTimeout(30000L);
        this._server.setConnectors(new Connector[]{this._connector});
        this._contextHandler.setContextPath("/");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new TestServlet()), "/initialCall");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new TestServlet()), "/firstDispatchWithNewQueryString");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new TestServlet()), "/secondDispatchNewValueForExistingQueryString");
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{this._contextHandler, new DefaultHandler()});
        this._server.setHandler((Handler)handlers);
        this._server.start();
    }

    @Test
    public void testMultipleDispatchesWithNewQueryStrings() throws Exception {
        String request = "GET /initialCall?initialParam=right HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)responseString, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
    }

    @AfterEach
    public void tearDown() throws Exception {
        this._server.stop();
        this._server.join();
    }

    private class TestServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private TestServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String uri = request.getRequestURI();
            String queryString = request.getQueryString();
            if ("/initialCall".equals(uri)) {
                AsyncContext async = request.startAsync();
                async.dispatch("/firstDispatchWithNewQueryString?newQueryString=initialValue");
                Assertions.assertEquals((Object)"initialParam=right", (Object)queryString);
            } else if ("/firstDispatchWithNewQueryString".equals(uri)) {
                AsyncContext async = request.startAsync();
                async.dispatch("/secondDispatchNewValueForExistingQueryString?newQueryString=newValue");
                Assertions.assertEquals((Object)"newQueryString=initialValue&initialParam=right", (Object)queryString);
            } else {
                response.setContentType("text/html");
                response.setStatus(200);
                response.getWriter().println("<h1>woohhooooo</h1>");
                Assertions.assertEquals((Object)"newQueryString=newValue&initialParam=right", (Object)queryString);
            }
        }
    }
}

