/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.log.Log;

public class StatisticsServlet
extends HttpServlet {
    boolean _restrictToLocalhost = true;
    private Server _server = null;
    private StatisticsHandler _statsHandler;
    private MemoryMXBean _memoryBean;
    private Connector[] _connectors;

    public void init() throws ServletException {
        this._memoryBean = ManagementFactory.getMemoryMXBean();
        ServletContext context = this.getServletContext();
        ContextHandler.Context scontext = (ContextHandler.Context)context;
        this._server = scontext.getContextHandler().getServer();
        Handler handler = this._server.getChildHandlerByClass(StatisticsHandler.class);
        if (handler != null) {
            this._statsHandler = (StatisticsHandler)handler;
        } else {
            Log.info((String)"Installing Statistics Handler");
            this._statsHandler = new StatisticsHandler();
            this._server.setHandler((Handler)this._statsHandler);
        }
        this._connectors = this._server.getConnectors();
        if (this.getInitParameter("restrictToLocalhost") != null) {
            this._restrictToLocalhost = "true".equals(this.getInitParameter("restrictToLocalhost"));
        }
    }

    public void doPost(HttpServletRequest sreq, HttpServletResponse sres) throws ServletException, IOException {
        this.doGet(sreq, sres);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this._restrictToLocalhost && !"127.0.0.1".equals(req.getRemoteAddr())) {
            resp.sendError(503);
            return;
        }
        if (req.getParameter("xml") != null && "true".equals(req.getParameter("xml"))) {
            this.sendXmlResponse(resp);
        } else {
            this.sendTextResponse(resp);
        }
    }

    private void sendXmlResponse(HttpServletResponse response) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<statistics>\n");
        sb.append("  <requests>\n");
        sb.append("    <statsOnMs>").append(this._statsHandler.getStatsOnMs()).append("</statsOnMs>\n");
        sb.append("    <requests>").append(this._statsHandler.getRequests()).append("</requests>\n");
        sb.append("    <requestsTimedout>").append(this._statsHandler.getRequestsTimedout()).append("</requestsTimedout>\n");
        sb.append("    <requestsResumed>").append(this._statsHandler.getRequestsResumed()).append("</requestsResumed>\n");
        sb.append("    <requestsActive>").append(this._statsHandler.getRequestsActive()).append("</requestsActive>\n");
        sb.append("    <requestsActiveMin>").append(this._statsHandler.getRequestsActiveMin()).append("</requestsActiveMin>\n");
        sb.append("    <requestsActiveMax>").append(this._statsHandler.getRequestsActiveMax()).append("</requestsActiveMax>\n");
        sb.append("    <requestsDurationTotal>").append(this._statsHandler.getRequestsDurationTotal()).append("</requestsDurationTotal>\n");
        sb.append("    <requestsDurationAve>").append(this._statsHandler.getRequestsDurationAve()).append("</requestsDurationAve>\n");
        sb.append("    <requestsDurationMin>").append(this._statsHandler.getRequestsDurationMin()).append("</requestsDurationMin>\n");
        sb.append("    <requestsDurationMax>").append(this._statsHandler.getRequestsDurationMax()).append("</requestsDurationMax>\n");
        sb.append("    <requestsActiveDurationAve>").append(this._statsHandler.getRequestsActiveDurationAve()).append("</requestsActiveDurationAve>\n");
        sb.append("    <requestsActiveDurationMin>").append(this._statsHandler.getRequestsActiveDurationMin()).append("</requestsActiveDurationMin>\n");
        sb.append("    <requestsActiveDurationMax>").append(this._statsHandler.getRequestsActiveDurationMax()).append("</requestsActiveDurationMax>\n");
        sb.append("  </requests>\n");
        sb.append("  <responses>\n");
        sb.append("    <responses1xx>").append(this._statsHandler.getResponses1xx()).append("</responses1xx>\n");
        sb.append("    <responses2xx>").append(this._statsHandler.getResponses2xx()).append("</responses2xx>\n");
        sb.append("    <responses3xx>").append(this._statsHandler.getResponses3xx()).append("</responses3xx>\n");
        sb.append("    <responses4xx>").append(this._statsHandler.getResponses4xx()).append("</responses4xx>\n");
        sb.append("    <responses5xx>").append(this._statsHandler.getResponses5xx()).append("</responses5xx>\n");
        sb.append("    <responsesBytesTotal>").append(this._statsHandler.getResponsesBytesTotal()).append("</responsesBytesTotal>\n");
        sb.append("  </responses>\n");
        sb.append("  <connections>\n");
        for (Connector connector : this._connectors) {
            sb.append("    <connector>\n");
            sb.append("      <name>").append(connector.getName()).append("</name>\n");
            sb.append("      <statsOn>").append(connector.getStatsOn()).append("</statsOn>\n");
            if (connector.getStatsOn()) {
                sb.append("    <statsOnMs>").append(connector.getStatsOnMs()).append("</statsOnMs>\n");
                sb.append("    <connections>").append(connector.getConnections()).append("</connections>\n");
                sb.append("    <connectionsOpen>").append(connector.getConnectionsOpen()).append("</connectionsOpen>\n");
                sb.append("    <connectionsOpenMin>").append(connector.getConnectionsOpenMin()).append("</connectionsOpenMin>\n");
                sb.append("    <connectionsOpenMax>").append(connector.getConnectionsOpenMax()).append("</connectionsOpenMax>\n");
                sb.append("    <connectionsDurationTotal>").append(connector.getConnectionsDurationTotal()).append("</connectionsDurationTotal>\n");
                sb.append("    <connectionsDurationAve>").append(connector.getConnectionsDurationAve()).append("</connectionsDurationAve>\n");
                sb.append("    <connectionsDurationMin>").append(connector.getConnectionsDurationMin()).append("</connectionsDurationMin>\n");
                sb.append("    <connectionsDurationMax>").append(connector.getConnectionsDurationMax()).append("</connectionsDurationMax>\n");
                sb.append("    <requests>").append(connector.getRequests()).append("</requests>\n");
                sb.append("    <connectionsRequestsAve>").append(connector.getConnectionsRequestsAve()).append("</connectionsRequestsAve>\n");
                sb.append("    <connectionsRequestsMin>").append(connector.getConnectionsRequestsMin()).append("</connectionsRequestsMin>\n");
                sb.append("    <connectionsRequestsMax>").append(connector.getConnectionsRequestsMax()).append("</connectionsRequestsMax>\n");
            }
            sb.append("    </connector>\n");
        }
        sb.append("  </connections>\n");
        sb.append("  <memory>\n");
        sb.append("    <heapMemoryUsage>").append(this._memoryBean.getHeapMemoryUsage().getUsed()).append("</heapMemoryUsage>\n");
        sb.append("    <nonHeapMemoryUsage>").append(this._memoryBean.getNonHeapMemoryUsage().getUsed()).append("</nonHeapMemoryUsage>\n");
        sb.append("  </memory>\n");
        sb.append("</statistics>\n");
        response.setContentType("text/xml");
        PrintWriter pout = null;
        pout = response.getWriter();
        pout.write(sb.toString());
    }

    private void sendTextResponse(HttpServletResponse response) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<h1>Statistics:</h1>\n");
        sb.append("<h2>Requests:</h2>\n");
        sb.append("Statistics gathering started " + this._statsHandler.getStatsOnMs() + "ms ago").append("<br />\n");
        sb.append("Total requests: " + this._statsHandler.getRequests()).append("<br />\n");
        sb.append("Total requests timed out: " + this._statsHandler.getRequestsTimedout()).append("<br />\n");
        sb.append("Total requests resumed: " + this._statsHandler.getRequestsResumed()).append("<br />\n");
        sb.append("Current requests active: " + this._statsHandler.getRequestsActive()).append("<br />\n");
        sb.append("Min concurrent requests active: " + this._statsHandler.getRequestsActiveMin()).append("<br />\n");
        sb.append("Max concurrent requests active: " + this._statsHandler.getRequestsActiveMax()).append("<br />\n");
        sb.append("Total requests duration: " + this._statsHandler.getRequestsDurationTotal()).append("<br />\n");
        sb.append("Average request duration: " + this._statsHandler.getRequestsDurationAve()).append("<br />\n");
        sb.append("Min request duration: " + this._statsHandler.getRequestsDurationMin()).append("<br />\n");
        sb.append("Max request duration: " + this._statsHandler.getRequestsDurationMax()).append("<br />\n");
        sb.append("Average request active duration: " + this._statsHandler.getRequestsActiveDurationAve()).append("<br />\n");
        sb.append("Min request active duration: " + this._statsHandler.getRequestsActiveDurationMin()).append("<br />\n");
        sb.append("Max request active duration: " + this._statsHandler.getRequestsActiveDurationMax()).append("<br />\n");
        sb.append("<h2>Responses:</h2>\n");
        sb.append("1xx responses: " + this._statsHandler.getResponses1xx()).append("<br />\n");
        sb.append("2xx responses: " + this._statsHandler.getResponses2xx()).append("<br />\n");
        sb.append("3xx responses: " + this._statsHandler.getResponses3xx()).append("<br />\n");
        sb.append("4xx responses: " + this._statsHandler.getResponses4xx()).append("<br />\n");
        sb.append("5xx responses: " + this._statsHandler.getResponses5xx()).append("<br />\n");
        sb.append("Bytes sent total: " + this._statsHandler.getResponsesBytesTotal()).append("<br />\n");
        sb.append("<h2>Connections:</h2>\n");
        for (Connector connector : this._connectors) {
            sb.append("<h3>" + connector.getName() + "</h3>");
            if (connector.getStatsOn()) {
                sb.append("Statistics gathering started " + connector.getStatsOnMs() + "ms ago").append("<br />\n");
                sb.append("Total connections: " + connector.getConnections()).append("<br />\n");
                sb.append("Current connections open: " + connector.getConnectionsOpen());
                sb.append("Min concurrent connections open: " + connector.getConnectionsOpenMin()).append("<br />\n");
                sb.append("Max concurrent connections open: " + connector.getConnectionsOpenMax()).append("<br />\n");
                sb.append("Total connections duration: " + connector.getConnectionsDurationTotal()).append("<br />\n");
                sb.append("Average connection duration: " + connector.getConnectionsDurationAve()).append("<br />\n");
                sb.append("Min connection duration: " + connector.getConnectionsDurationMin()).append("<br />\n");
                sb.append("Max connection duration: " + connector.getConnectionsDurationMax()).append("<br />\n");
                sb.append("Total requests: " + connector.getRequests()).append("<br />\n");
                sb.append("Average requests per connection: " + connector.getConnectionsRequestsAve()).append("<br />\n");
                sb.append("Min requests per connection: " + connector.getConnectionsRequestsMin()).append("<br />\n");
                sb.append("Max requests per connection: " + connector.getConnectionsRequestsMax()).append("<br />\n");
                continue;
            }
            sb.append("Statistics gathering off.\n");
        }
        sb.append("<h2>Memory:</h2>\n");
        sb.append("Heap memory usage: " + this._memoryBean.getHeapMemoryUsage().getUsed() + " bytes").append("<br />\n");
        sb.append("Non-heap memory usage: " + this._memoryBean.getNonHeapMemoryUsage().getUsed() + " bytes").append("<br />\n");
        response.setContentType("text/html");
        PrintWriter pout = null;
        pout = response.getWriter();
        pout.write(sb.toString());
    }
}

