/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.EventListener;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.BaseHolder;
import org.eclipse.jetty.servlet.Source;

public class ListenerHolder
extends BaseHolder<EventListener> {
    private EventListener _listener;

    public ListenerHolder() {
        this(Source.EMBEDDED);
    }

    public ListenerHolder(Source source) {
        super(source);
    }

    public ListenerHolder(Class<? extends EventListener> listenerClass) {
        super(Source.EMBEDDED);
        this.setHeldClass(listenerClass);
    }

    public EventListener getListener() {
        return this._listener;
    }

    public void setListener(EventListener listener) {
        this.setInstance(listener);
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        if (!EventListener.class.isAssignableFrom(this.getHeldClass())) {
            String msg = this.getHeldClass() + " is not a java.util.EventListener";
            super.stop();
            throw new IllegalStateException(msg);
        }
        ContextHandler contextHandler = ContextHandler.getCurrentContext().getContextHandler();
        if (contextHandler != null) {
            this._listener = (EventListener)this.getInstance();
            if (this._listener == null) {
                try {
                    this._listener = this.createInstance();
                }
                catch (ServletException ex) {
                    Throwable cause = ex.getRootCause();
                    if (cause instanceof InstantiationException) {
                        throw (InstantiationException)cause;
                    }
                    if (cause instanceof IllegalAccessException) {
                        throw (IllegalAccessException)cause;
                    }
                    throw ex;
                }
            }
            contextHandler.addEventListener(this._listener);
        }
    }

    @Override
    protected synchronized EventListener createInstance() throws Exception {
        ServletContext ctx;
        EventListener listener = (EventListener)super.createInstance();
        if (listener == null && (ctx = this.getServletContext()) != null) {
            listener = ctx.createListener(this.getHeldClass());
        }
        return listener;
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        if (this._listener != null) {
            try {
                ContextHandler contextHandler = ContextHandler.getCurrentContext().getContextHandler();
                if (contextHandler != null) {
                    contextHandler.removeEventListener(this._listener);
                }
                this.getServletHandler().destroyListener(this._listener);
            }
            finally {
                this._listener = null;
            }
        }
    }

    public String toString() {
        return super.toString() + ": " + this.getClassName();
    }
}

