/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Ignore
public class RequestLogHandlerTest {
    private static final Logger LOG = Log.getLogger(RequestLogHandlerTest.class);
    @Parameterized.Parameter(value=0)
    public Handler testHandler;
    @Parameterized.Parameter(value=1)
    public String requestPath;
    @Parameterized.Parameter(value=2)
    public String expectedLogEntry;

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{new HelloHandler(), "/test/", "GET /test/ HTTP/1.1 200"});
        data.add(new Object[]{new AsyncOnTimeoutCompleteHandler(), "/test/", "GET /test/ HTTP/1.1 200"});
        data.add(new Object[]{new AsyncOnTimeoutCompleteUnhandledHandler(), "/test/", "GET /test/ HTTP/1.1 200"});
        data.add(new Object[]{new AsyncOnTimeoutDispatchHandler(), "/test/", "GET /test/ HTTP/1.1 200"});
        data.add(new Object[]{new AsyncOnStartIOExceptionHandler(), "/test/", "GET /test/ HTTP/1.1 500"});
        data.add(new Object[]{new ResponseSendErrorHandler(), "/test/", "GET /test/ HTTP/1.1 500"});
        data.add(new Object[]{new ServletExceptionHandler(), "/test/", "GET /test/ HTTP/1.1 500"});
        data.add(new Object[]{new IOExceptionHandler(), "/test/", "GET /test/ HTTP/1.1 500"});
        data.add(new Object[]{new RuntimeExceptionHandler(), "/test/", "GET /test/ HTTP/1.1 500"});
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testLogHandlerCollection() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        CaptureLog captureLog = new CaptureLog();
        RequestLogHandler requestLog = new RequestLogHandler();
        requestLog.setRequestLog((RequestLog)captureLog);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{this.testHandler, requestLog});
        server.setHandler((Handler)handlers);
        try {
            server.start();
            String host = connector.getHost();
            if (host == null) {
                host = "localhost";
            }
            int port = connector.getLocalPort();
            URI serverUri = new URI("http", null, host, port, this.requestPath, null, null);
            HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
            try {
                connection.setAllowUserInteraction(false);
                int statusCode = connection.getResponseCode();
                LOG.debug("Response Status Code: {}", (long)statusCode);
                if (statusCode == 200) {
                    String content = this.getResponseContent(connection);
                    LOG.debug("Response Content: {}", new Object[]{content});
                }
            }
            finally {
                connection.disconnect();
            }
            this.assertRequestLog(captureLog);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testLogHandlerCollection_ErrorHandler_ServerBean() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        ErrorHandler errorHandler = new ErrorHandler();
        server.addBean((Object)errorHandler);
        CaptureLog captureLog = new CaptureLog();
        RequestLogHandler requestLog = new RequestLogHandler();
        requestLog.setRequestLog((RequestLog)captureLog);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{this.testHandler, requestLog});
        server.setHandler((Handler)handlers);
        try {
            server.start();
            String host = connector.getHost();
            if (host == null) {
                host = "localhost";
            }
            int port = connector.getLocalPort();
            URI serverUri = new URI("http", null, host, port, this.requestPath, null, null);
            HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
            try {
                connection.setAllowUserInteraction(false);
                int statusCode = connection.getResponseCode();
                LOG.debug("Response Status Code: {}", (long)statusCode);
                if (statusCode == 200) {
                    String content = this.getResponseContent(connection);
                    LOG.debug("Response Content: {}", new Object[]{content});
                }
            }
            finally {
                connection.disconnect();
            }
            this.assertRequestLog(captureLog);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testLogHandlerCollection_AltErrorHandler() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        AltErrorHandler errorDispatcher = new AltErrorHandler();
        server.addBean((Object)errorDispatcher);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        ContextHandler errorContext = new ContextHandler("/errorpage");
        errorContext.setHandler((Handler)new AltErrorHandler());
        ContextHandler testContext = new ContextHandler("/test");
        testContext.setHandler(this.testHandler);
        contexts.addHandler((Handler)errorContext);
        contexts.addHandler((Handler)testContext);
        RequestLogHandler requestLog = new RequestLogHandler();
        CaptureLog captureLog = new CaptureLog();
        requestLog.setRequestLog((RequestLog)captureLog);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{contexts, requestLog});
        server.setHandler((Handler)handlers);
        try {
            server.start();
            String host = connector.getHost();
            if (host == null) {
                host = "localhost";
            }
            int port = connector.getLocalPort();
            URI serverUri = new URI("http", null, host, port, this.requestPath, null, null);
            HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
            try {
                connection.setAllowUserInteraction(false);
                int statusCode = connection.getResponseCode();
                LOG.debug("Response Status Code: {}", (long)statusCode);
                if (statusCode == 200) {
                    String content = this.getResponseContent(connection);
                    LOG.debug("Response Content: {}", new Object[]{content});
                }
            }
            finally {
                connection.disconnect();
            }
            this.assertRequestLog(captureLog);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testLogHandlerCollection_OKErrorHandler() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        OKErrorHandler errorDispatcher = new OKErrorHandler();
        server.addBean((Object)errorDispatcher);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        ContextHandler errorContext = new ContextHandler("/errorpage");
        errorContext.setHandler((Handler)new AltErrorHandler());
        ContextHandler testContext = new ContextHandler("/test");
        testContext.setHandler(this.testHandler);
        contexts.addHandler((Handler)errorContext);
        contexts.addHandler((Handler)testContext);
        RequestLogHandler requestLog = new RequestLogHandler();
        CaptureLog captureLog = new CaptureLog();
        requestLog.setRequestLog((RequestLog)captureLog);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{contexts, requestLog});
        server.setHandler((Handler)handlers);
        try {
            server.start();
            String host = connector.getHost();
            if (host == null) {
                host = "localhost";
            }
            int port = connector.getLocalPort();
            URI serverUri = new URI("http", null, host, port, this.requestPath, null, null);
            HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
            try {
                connection.setAllowUserInteraction(false);
                int statusCode = connection.getResponseCode();
                LOG.debug("Response Status Code: {}", (long)statusCode);
                if (statusCode == 200) {
                    String content = this.getResponseContent(connection);
                    LOG.debug("Response Content: {}", new Object[]{content});
                }
            }
            finally {
                connection.disconnect();
            }
            this.assertRequestLog(captureLog);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testLogHandlerCollection_DispatchErrorHandler() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        DispatchErrorHandler errorDispatcher = new DispatchErrorHandler();
        server.addBean((Object)errorDispatcher);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        ContextHandler errorContext = new ContextHandler("errorok");
        errorContext.setHandler((Handler)new OKErrorHandler());
        ContextHandler testContext = new ContextHandler("test");
        testContext.setHandler(this.testHandler);
        contexts.addHandler((Handler)errorContext);
        contexts.addHandler((Handler)testContext);
        RequestLogHandler requestLog = new RequestLogHandler();
        CaptureLog captureLog = new CaptureLog();
        requestLog.setRequestLog((RequestLog)captureLog);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{contexts, requestLog});
        server.setHandler((Handler)handlers);
        try {
            server.start();
            String host = connector.getHost();
            if (host == null) {
                host = "localhost";
            }
            int port = connector.getLocalPort();
            URI serverUri = new URI("http", null, host, port, this.requestPath, null, null);
            HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
            try {
                connection.setAllowUserInteraction(false);
                int statusCode = connection.getResponseCode();
                LOG.debug("Response Status Code: {}", (long)statusCode);
                if (statusCode == 200) {
                    String content = this.getResponseContent(connection);
                    LOG.debug("Response Content: {}", new Object[]{content});
                }
            }
            finally {
                connection.disconnect();
            }
            this.assertRequestLog(captureLog);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testLogHandlerWrapped() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        CaptureLog captureLog = new CaptureLog();
        RequestLogHandler requestLog = new RequestLogHandler();
        requestLog.setRequestLog((RequestLog)captureLog);
        requestLog.setHandler(this.testHandler);
        server.setHandler((Handler)requestLog);
        try {
            server.start();
            String host = connector.getHost();
            if (host == null) {
                host = "localhost";
            }
            int port = connector.getLocalPort();
            URI serverUri = new URI("http", null, host, port, this.requestPath, null, null);
            HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
            try {
                connection.setAllowUserInteraction(false);
                int statusCode = connection.getResponseCode();
                LOG.info("Response Status Code: {}", new Object[]{statusCode});
                if (statusCode == 200) {
                    String content = this.getResponseContent(connection);
                    LOG.info("Response Content: {}", new Object[]{content});
                }
            }
            finally {
                connection.disconnect();
            }
            this.assertRequestLog(captureLog);
        }
        finally {
            server.stop();
        }
    }

    private void assertRequestLog(CaptureLog captureLog) {
        int captureCount = captureLog.captured.size();
        if (captureCount != 1) {
            LOG.warn("Capture Log size is {}, expected to be 1", new Object[]{captureCount});
            if (captureCount > 1) {
                for (int i = 0; i < captureCount; ++i) {
                    LOG.warn("[{}] {}", new Object[]{i, captureLog.captured.get(i)});
                }
            }
            Assert.assertThat((String)"Capture Log Entry Count", (Object)captureLog.captured.size(), (Matcher)Matchers.is((Object)1));
        }
        String actual = captureLog.captured.get(0);
        Assert.assertThat((String)"Capture Log", (Object)actual, (Matcher)Matchers.is((Object)this.expectedLogEntry));
    }

    /*
     * Exception decompiling
     */
    private String getResponseContent(HttpURLConnection connection) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class AltErrorHandler
    extends ErrorHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (baseRequest.isHandled() || response.isCommitted()) {
                return;
            }
            String reason = response instanceof Response ? ((Response)response).getReason() : null;
            int status = response.getStatus();
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            out.printf("Error %d: %s%n", status, reason);
            baseRequest.setHandled(true);
        }
    }

    public static class DispatchErrorHandler
    extends ErrorHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (baseRequest.isHandled() || response.isCommitted()) {
                return;
            }
            RequestDispatcher dispatcher = request.getRequestDispatcher("/errorok/");
            Assert.assertThat((String)"Dispatcher", (Object)dispatcher, (Matcher)Matchers.notNullValue());
            try {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException e) {
                throw new IOException("Dispatch.forward failed", e);
            }
        }
    }

    public static class OKErrorHandler
    extends ErrorHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (baseRequest.isHandled() || response.isCommitted()) {
                return;
            }
            String reason = response instanceof Response ? ((Response)response).getReason() : null;
            int status = response.getStatus();
            response.setStatus(200);
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            out.printf("Error %d: %s%n", status, reason);
            baseRequest.setHandled(true);
        }
    }

    private static class AsyncOnStartIOExceptionHandler
    extends AbstractTestHandler
    implements AsyncListener {
        private AsyncOnStartIOExceptionHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            AsyncContext ac = request.startAsync();
            ac.setTimeout(1000L);
            ac.addListener((AsyncListener)this);
            baseRequest.setHandled(true);
        }

        public void onTimeout(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            event.getAsyncContext().complete();
            throw new IOException("Whoops");
        }

        public void onError(AsyncEvent event) throws IOException {
            LOG.warn("onError() -> {}", new Object[]{event});
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private static class AsyncOnTimeoutDispatchHandler
    extends AbstractTestHandler
    implements AsyncListener {
        private AsyncOnTimeoutDispatchHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute("deep") == null) {
                AsyncContext ac = request.startAsync();
                ac.setTimeout(1000L);
                ac.addListener((AsyncListener)this);
                baseRequest.setHandled(true);
                request.setAttribute("deep", (Object)true);
            }
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            event.getAsyncContext().dispatch();
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private static class AsyncOnTimeoutCompleteUnhandledHandler
    extends AbstractTestHandler
    implements AsyncListener {
        private AsyncOnTimeoutCompleteUnhandledHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            AsyncContext ac = request.startAsync();
            ac.setTimeout(1000L);
            ac.addListener((AsyncListener)this);
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            event.getAsyncContext().complete();
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private static class AsyncOnTimeoutCompleteHandler
    extends AbstractTestHandler
    implements AsyncListener {
        private AsyncOnTimeoutCompleteHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            AsyncContext ac = request.startAsync();
            ac.setTimeout(1000L);
            ac.addListener((AsyncListener)this);
            baseRequest.setHandled(true);
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            event.getAsyncContext().complete();
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private static class RuntimeExceptionHandler
    extends AbstractTestHandler {
        private RuntimeExceptionHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            throw new RuntimeException("Whoops");
        }
    }

    private static class IOExceptionHandler
    extends AbstractTestHandler {
        private IOExceptionHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            throw new IOException("Whoops");
        }
    }

    private static class ServletExceptionHandler
    extends AbstractTestHandler {
        private ServletExceptionHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            throw new ServletException("Whoops");
        }
    }

    private static class ResponseSendErrorHandler
    extends AbstractTestHandler {
        private ResponseSendErrorHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.sendError(500, "Whoops");
            baseRequest.setHandled(true);
        }
    }

    private static class HelloHandler
    extends AbstractTestHandler {
        private HelloHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.setContentType("text/plain");
            response.getWriter().print("Hello World");
            baseRequest.setHandled(true);
        }
    }

    private static abstract class AbstractTestHandler
    extends AbstractHandler {
        private AbstractTestHandler() {
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }
    }

    public static class CaptureLog
    extends AbstractLifeCycle
    implements RequestLog {
        public List<String> captured = new ArrayList<String>();

        public void log(Request request, Response response) {
            this.captured.add(String.format("%s %s %s %03d", request.getMethod(), request.getRequestURI(), request.getProtocol(), response.getStatus()));
        }
    }
}

