/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ServerConnectorTest {
    private URI toServerURI(ServerConnector connector) throws URISyntaxException {
        String host = connector.getHost();
        if (host == null) {
            host = "localhost";
        }
        int port = connector.getLocalPort();
        return new URI(String.format("http://%s:%d/", host, port));
    }

    private String getResponse(URI uri) throws MalformedURLException, IOException {
        HttpURLConnection http = (HttpURLConnection)uri.toURL().openConnection();
        Assert.assertThat((String)"Valid Response Code", (Object)http.getResponseCode(), (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)200), (Matcher)Matchers.is((Object)404)));
        try (InputStream in = http.getInputStream();){
            String string = IO.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReuseAddress_Default() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.addConnector((Connector)connector);
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)new ReuseInfoHandler());
        handlers.addHandler((Handler)new DefaultHandler());
        server.setHandler((Handler)handlers);
        try {
            server.start();
            URI uri = this.toServerURI(connector);
            String response = this.getResponse(uri);
            Assert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"connector.getReuseAddress() = true"));
            Assert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"connector._reuseAddress() = true"));
            Assert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"socket.getReuseAddress() = true"));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReuseAddress_True() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        connector.setReuseAddress(true);
        server.addConnector((Connector)connector);
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)new ReuseInfoHandler());
        handlers.addHandler((Handler)new DefaultHandler());
        server.setHandler((Handler)handlers);
        try {
            server.start();
            URI uri = this.toServerURI(connector);
            String response = this.getResponse(uri);
            Assert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"connector.getReuseAddress() = true"));
            Assert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"connector._reuseAddress() = true"));
            Assert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"socket.getReuseAddress() = true"));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReuseAddress_False() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        connector.setReuseAddress(false);
        server.addConnector((Connector)connector);
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)new ReuseInfoHandler());
        handlers.addHandler((Handler)new DefaultHandler());
        server.setHandler((Handler)handlers);
        try {
            server.start();
            URI uri = this.toServerURI(connector);
            String response = this.getResponse(uri);
            Assert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"connector.getReuseAddress() = false"));
            Assert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"connector._reuseAddress() = false"));
            Assert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"socket.getReuseAddress() = false"));
        }
        finally {
            server.stop();
        }
    }

    public static class ReuseInfoHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.setContentType("text/plain");
            EndPoint endPoint = baseRequest.getHttpChannel().getEndPoint();
            Assert.assertThat((String)"Endpoint", (Object)endPoint, (Matcher)Matchers.instanceOf(ChannelEndPoint.class));
            ChannelEndPoint channelEndPoint = (ChannelEndPoint)endPoint;
            Socket socket = channelEndPoint.getSocket();
            ServerConnector connector = (ServerConnector)baseRequest.getHttpChannel().getConnector();
            PrintWriter out = response.getWriter();
            out.printf("connector.getReuseAddress() = %b%n", connector.getReuseAddress());
            try {
                Field fld = connector.getClass().getDeclaredField("_reuseAddress");
                Assert.assertThat((String)"Field[_reuseAddress]", (Object)fld, (Matcher)Matchers.notNullValue());
                fld.setAccessible(true);
                Object val = fld.get(connector);
                out.printf("connector._reuseAddress() = %b%n", val);
            }
            catch (Throwable t) {
                t.printStackTrace(out);
            }
            out.printf("socket.getReuseAddress() = %b%n", socket.getReuseAddress());
            baseRequest.setHandled(true);
        }
    }
}

