/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiPartInputStreamParser;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.StdErrLog;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RequestTest {
    private static final Logger LOG = Log.getLogger(RequestTest.class);
    private Server _server;
    private LocalConnector _connector;
    private RequestHandler _handler;

    @Before
    public void init() throws Exception {
        this._server = new Server();
        HttpConnectionFactory http = new HttpConnectionFactory();
        http.setInputBufferSize(1024);
        http.getHttpConfiguration().setRequestHeaderSize(512);
        http.getHttpConfiguration().setResponseHeaderSize(512);
        http.getHttpConfiguration().setOutputBufferSize(2048);
        http.getHttpConfiguration().addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        this._connector = new LocalConnector(this._server, (ConnectionFactory)http);
        this._server.addConnector((Connector)this._connector);
        this._handler = new RequestHandler();
        this._server.setHandler((Handler)this._handler);
        this._server.start();
    }

    @After
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testParamExtraction() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                Map map = null;
                map = request.getParameterMap();
                Assert.assertEquals((Object)"aaa\ufffdbbb", (Object)((String[])map.get("param"))[0]);
                Assert.assertEquals((Object)"value", (Object)((String[])map.get("other"))[0]);
                return true;
            }
        };
        String request = "GET /?param=aaa%ZZbbb&other=value HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/html;charset=utf8\nConnection: close\n\n";
        String responses = this._connector.getResponses(request);
        Assert.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testEmptyHeaders() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                Assert.assertNotNull((Object)request.getLocale());
                Assert.assertTrue((boolean)request.getLocales().hasMoreElements());
                Assert.assertNull((Object)request.getContentType());
                Assert.assertNull((Object)request.getCharacterEncoding());
                Assert.assertEquals((long)0L, (long)request.getQueryString().length());
                Assert.assertEquals((long)-1L, (long)request.getContentLength());
                Assert.assertNull((Object)request.getCookies());
                Assert.assertNull((Object)request.getHeader("Name"));
                Assert.assertFalse((boolean)request.getHeaders("Name").hasMoreElements());
                Assert.assertEquals((long)-1L, (long)request.getDateHeader("Name"));
                return true;
            }
        };
        String request = "GET /? HTTP/1.1\r\nHost: whatever\r\nConnection: close\nContent-Type: \nAccept-Language: \nCookie: \nName: \n\n";
        String responses = this._connector.getResponses(request);
        Assert.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testMultiPartNoConfig() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                try {
                    Part foo = request.getPart("stuff");
                    return false;
                }
                catch (IllegalStateException e) {
                    Assert.assertTrue((boolean)e.getMessage().startsWith("No multipart config"));
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        String multipart = "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"\r\nContent-Type: text/plain;charset=ISO-8859-1\r\n\r\n000000000000000000000000000000000000000000000000000\r\n--AaB03x--\r\n";
        String request = "GET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data; boundary=\"AaB03x\"\r\nContent-Length: " + multipart.getBytes().length + "\r\n" + "Connection: close\r\n" + "\r\n" + multipart;
        String responses = this._connector.getResponses(request);
        Assert.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testMultiPart() throws Exception {
        final File testTmpDir = File.createTempFile("reqtest", null);
        if (testTmpDir.exists()) {
            testTmpDir.delete();
        }
        testTmpDir.mkdir();
        testTmpDir.deleteOnExit();
        Assert.assertTrue((testTmpDir.list().length == 0 ? 1 : 0) != 0);
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath("/foo");
        contextHandler.setResourceBase(".");
        contextHandler.setHandler((Handler)new MultiPartRequestHandler(testTmpDir));
        contextHandler.addEventListener((EventListener)new Request.MultiPartCleanerListener(){

            public void requestDestroyed(ServletRequestEvent sre) {
                MultiPartInputStreamParser m = (MultiPartInputStreamParser)sre.getServletRequest().getAttribute("org.eclipse.jetty.multiPartInputStream");
                ContextHandler.Context c = (ContextHandler.Context)sre.getServletRequest().getAttribute("org.eclipse.jetty.multiPartContext");
                Assert.assertNotNull((Object)m);
                Assert.assertNotNull((Object)c);
                Assert.assertTrue((c == sre.getServletContext() ? 1 : 0) != 0);
                Assert.assertTrue((!m.getParsedParts().isEmpty() ? 1 : 0) != 0);
                Assert.assertTrue((testTmpDir.list().length == 2 ? 1 : 0) != 0);
                super.requestDestroyed(sre);
                String[] files = testTmpDir.list();
                Assert.assertTrue((files.length == 0 ? 1 : 0) != 0);
            }
        });
        this._server.stop();
        this._server.setHandler((Handler)contextHandler);
        this._server.start();
        String multipart = "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"; filename=\"foo.upload\"\r\nContent-Type: text/plain;charset=ISO-8859-1\r\n\r\n000000000000000000000000000000000000000000000000000\r\n--AaB03x--\r\n";
        String request = "GET /foo/x.html HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data; boundary=\"AaB03x\"\r\nContent-Length: " + multipart.getBytes().length + "\r\n" + "Connection: close\r\n" + "\r\n" + multipart;
        String responses = this._connector.getResponses(request);
        Assert.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testBadMultiPart() throws Exception {
        final File testTmpDir = File.createTempFile("badmptest", null);
        if (testTmpDir.exists()) {
            testTmpDir.delete();
        }
        testTmpDir.mkdir();
        testTmpDir.deleteOnExit();
        Assert.assertTrue((testTmpDir.list().length == 0 ? 1 : 0) != 0);
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath("/foo");
        contextHandler.setResourceBase(".");
        contextHandler.setHandler((Handler)new BadMultiPartRequestHandler(testTmpDir));
        contextHandler.addEventListener((EventListener)new Request.MultiPartCleanerListener(){

            public void requestDestroyed(ServletRequestEvent sre) {
                MultiPartInputStreamParser m = (MultiPartInputStreamParser)sre.getServletRequest().getAttribute("org.eclipse.jetty.multiPartInputStream");
                ContextHandler.Context c = (ContextHandler.Context)sre.getServletRequest().getAttribute("org.eclipse.jetty.multiPartContext");
                Assert.assertNotNull((Object)m);
                Assert.assertNotNull((Object)c);
                Assert.assertTrue((c == sre.getServletContext() ? 1 : 0) != 0);
                super.requestDestroyed(sre);
                String[] files = testTmpDir.list();
                Assert.assertTrue((files.length == 0 ? 1 : 0) != 0);
            }
        });
        this._server.stop();
        this._server.setHandler((Handler)contextHandler);
        this._server.start();
        String multipart = "--AaB03x\r\ncontent-disposition: form-data; name=\"xxx\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data;  filename=\"foo.upload\"\r\nContent-Type: text/plain;charset=ISO-8859-1\r\n\r\n000000000000000000000000000000000000000000000000000\r\n--AaB03x--\r\n";
        String request = "GET /foo/x.html HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data; boundary=\"AaB03x\"\r\nContent-Length: " + multipart.getBytes().length + "\r\n" + "Connection: close\r\n" + "\r\n" + multipart;
        String responses = this._connector.getResponses(request);
        Assert.assertTrue((boolean)responses.startsWith("HTTP/1.1 500"));
    }

    @Test
    public void testBadUtf8ParamExtraction() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                String value = request.getParameter("param");
                return value.startsWith("aaa") && value.endsWith("bb");
            }
        };
        String request = "GET /?param=aaa%E7bbb HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/html;charset=utf8\nConnection: close\n\n";
        LOG.info("Expecting NotUtf8Exception byte 62 in state 3...", new Object[0]);
        String responses = this._connector.getResponses(request);
        Assert.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testInvalidHostHeader() throws Exception {
        ContextHandler context = new ContextHandler();
        context.addVirtualHosts(new String[]{"something"});
        this._server.stop();
        this._server.setHandler((Handler)context);
        this._server.start();
        String request = "GET / HTTP/1.1\nHost: whatever.com:xxxx\nContent-Type: text/html;charset=utf8\nConnection: close\n\n";
        String responses = this._connector.getResponses(request);
        Assert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 400"));
    }

    @Test
    public void testContentTypeEncoding() throws Exception {
        final ArrayList results = new ArrayList();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                results.add(request.getContentType());
                results.add(request.getCharacterEncoding());
                return true;
            }
        };
        this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\nContent-Type: text/test\n\nGET / HTTP/1.1\nHost: whatever\nContent-Type: text/html;charset=utf8\n\nGET / HTTP/1.1\nHost: whatever\nContent-Type: text/html; charset=\"utf8\"\n\nGET / HTTP/1.1\nHost: whatever\nContent-Type: text/html; other=foo ; blah=\"charset=wrong;\" ; charset =   \" x=z; \"   ; more=values \nConnection: close\n\n");
        int i = 0;
        Assert.assertEquals((Object)"text/test", results.get(i++));
        Assert.assertEquals(null, results.get(i++));
        Assert.assertEquals((Object)"text/html;charset=utf8", results.get(i++));
        Assert.assertEquals((Object)"UTF-8", results.get(i++));
        Assert.assertEquals((Object)"text/html; charset=\"utf8\"", results.get(i++));
        Assert.assertEquals((Object)"UTF-8", results.get(i++));
        Assert.assertTrue((boolean)((String)results.get(i++)).startsWith("text/html"));
        Assert.assertEquals((Object)" x=z; ", results.get(i++));
    }

    @Test
    public void testHostPort() throws Exception {
        final ArrayList results = new ArrayList();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                results.add(request.getRequestURL().toString());
                results.add(request.getRemoteAddr());
                results.add(request.getServerName());
                results.add(String.valueOf(request.getServerPort()));
                return true;
            }
        };
        results.clear();
        String response = this._connector.getResponses("GET / HTTP/1.1\nHost: myhost\nConnection: close\n\n");
        int i = 0;
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assert.assertEquals((Object)"http://myhost/", results.get(i++));
        Assert.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assert.assertEquals((Object)"myhost", results.get(i++));
        Assert.assertEquals((Object)"80", results.get(i++));
        results.clear();
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: myhost:8888\nConnection: close\n\n");
        i = 0;
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assert.assertEquals((Object)"http://myhost:8888/", results.get(i++));
        Assert.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assert.assertEquals((Object)"myhost", results.get(i++));
        Assert.assertEquals((Object)"8888", results.get(i++));
        results.clear();
        response = this._connector.getResponses("GET http://myhost:8888/ HTTP/1.0\n\n");
        i = 0;
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assert.assertEquals((Object)"http://myhost:8888/", results.get(i++));
        Assert.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assert.assertEquals((Object)"myhost", results.get(i++));
        Assert.assertEquals((Object)"8888", results.get(i++));
        results.clear();
        response = this._connector.getResponses("GET http://myhost:8888/ HTTP/1.1\nHost: wrong:666\nConnection: close\n\n");
        i = 0;
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assert.assertEquals((Object)"http://myhost:8888/", results.get(i++));
        Assert.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assert.assertEquals((Object)"myhost", results.get(i++));
        Assert.assertEquals((Object)"8888", results.get(i++));
        results.clear();
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: 1.2.3.4\nConnection: close\n\n");
        i = 0;
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assert.assertEquals((Object)"http://1.2.3.4/", results.get(i++));
        Assert.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assert.assertEquals((Object)"1.2.3.4", results.get(i++));
        Assert.assertEquals((Object)"80", results.get(i++));
        results.clear();
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: 1.2.3.4:8888\nConnection: close\n\n");
        i = 0;
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assert.assertEquals((Object)"http://1.2.3.4:8888/", results.get(i++));
        Assert.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assert.assertEquals((Object)"1.2.3.4", results.get(i++));
        Assert.assertEquals((Object)"8888", results.get(i++));
        results.clear();
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: [::1]\nConnection: close\n\n");
        i = 0;
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assert.assertEquals((Object)"http://[::1]/", results.get(i++));
        Assert.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assert.assertEquals((Object)"[::1]", results.get(i++));
        Assert.assertEquals((Object)"80", results.get(i++));
        results.clear();
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: [::1]:8888\nConnection: close\n\n");
        i = 0;
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assert.assertEquals((Object)"http://[::1]:8888/", results.get(i++));
        Assert.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assert.assertEquals((Object)"[::1]", results.get(i++));
        Assert.assertEquals((Object)"8888", results.get(i++));
        results.clear();
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: [::1]\nx-forwarded-for: remote\nx-forwarded-proto: https\nConnection: close\n\n");
        i = 0;
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assert.assertEquals((Object)"https://[::1]/", results.get(i++));
        Assert.assertEquals((Object)"remote", results.get(i++));
        Assert.assertEquals((Object)"[::1]", results.get(i++));
        Assert.assertEquals((Object)"443", results.get(i++));
        results.clear();
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: [::1]:8888\nConnection: close\nx-forwarded-for: remote\nx-forwarded-proto: https\n\n");
        i = 0;
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assert.assertEquals((Object)"https://[::1]:8888/", results.get(i++));
        Assert.assertEquals((Object)"remote", results.get(i++));
        Assert.assertEquals((Object)"[::1]", results.get(i++));
        Assert.assertEquals((Object)"8888", results.get(i++));
    }

    @Test
    public void testContent() throws Exception {
        final AtomicInteger length = new AtomicInteger();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                int len = request.getContentLength();
                ServletInputStream in = request.getInputStream();
                for (int i = 0; i < len; ++i) {
                    int b = in.read();
                    if (b >= 0) continue;
                    return false;
                }
                if (in.read() > 0) {
                    return false;
                }
                length.set(len);
                return true;
            }
        };
        String content = "";
        for (int l = 0; l < 1024; ++l) {
            String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data-test\r\nContent-Length: " + l + "\r\n" + "Connection: close\r\n" + "\r\n" + content;
            Log.getRootLogger().debug("test l={}", (long)l);
            String response = this._connector.getResponses(request);
            Log.getRootLogger().debug(response, new Object[0]);
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
            Assert.assertEquals((long)l, (long)length.get());
            content = content + "x";
        }
    }

    @Test
    public void test8859EncodedForm() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                request.setCharacterEncoding(StandardCharsets.ISO_8859_1.name());
                String actual = request.getParameter("name2");
                return "test\u00e4".equals(actual);
            }
        };
        String content = "name1=test&name2=test%E4&name3=&name4=test";
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\n" + "Content-Length: " + content.length() + "\r\n" + "Connection: close\r\n" + "\r\n" + content;
        String response = this._connector.getResponses(request);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
    }

    @Test
    public void testUTF8EncodedForm() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                String actual = request.getParameter("name2");
                return "test\u00e4".equals(actual);
            }
        };
        String content = "name1=test&name2=test%C3%A4&name3=&name4=test";
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\n" + "Content-Length: " + content.length() + "\r\n" + "Connection: close\r\n" + "\r\n" + content;
        String response = this._connector.getResponses(request);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
    }

    @Test
    public void testPartialRead() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                BufferedReader reader = request.getReader();
                byte[] b = ("read=" + ((Reader)reader).read() + "\n").getBytes(StandardCharsets.UTF_8);
                response.setContentLength(b.length);
                response.getOutputStream().write(b);
                response.flushBuffer();
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plane\r\nContent-Length: 10\r\n\r\n0123456789\r\nGET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plane\r\nContent-Length: 10\r\nConnection: close\r\n\r\nABCDEFGHIJ\r\n";
        String responses = this._connector.getResponses(request);
        int index = responses.indexOf("read=48");
        Assert.assertTrue((index > 0 ? 1 : 0) != 0);
        index = responses.indexOf("read=65", index + 7);
        Assert.assertTrue((index > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryAfterRead() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                BufferedReader reader = request.getReader();
                String in = IO.toString((Reader)reader);
                String param = request.getParameter("param");
                byte[] b = ("read='" + in + "' param=" + param + "\n").getBytes(StandardCharsets.UTF_8);
                response.setContentLength(b.length);
                response.getOutputStream().write(b);
                response.flushBuffer();
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String request = "POST /?param=right HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: 11\r\nConnection: close\r\n\r\nparam=wrong\r\n";
        String responses = this._connector.getResponses(request);
        Assert.assertTrue((responses.indexOf("read='param=wrong' param=right") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSessionAfterRedirect() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.sendRedirect("/foo");
                try {
                    request.getSession(true);
                    Assert.fail((String)"Session should not be created after response committed");
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (Exception e) {
                    Assert.fail((String)"Session creation after response commit should throw IllegalStateException");
                }
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String response = this._connector.getResponses("GET / HTTP/1.1\nHost: myhost\nConnection: close\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 302 Found"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Location: http://myhost/foo"));
    }

    @Test
    public void testPartialInput() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                ServletInputStream in = request.getInputStream();
                byte[] b = ("read=" + in.read() + "\n").getBytes(StandardCharsets.UTF_8);
                response.setContentLength(b.length);
                response.getOutputStream().write(b);
                response.flushBuffer();
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plane\r\nContent-Length: 10\r\n\r\n0123456789\r\nGET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plane\r\nContent-Length: 10\r\nConnection: close\r\n\r\nABCDEFGHIJ\r\n";
        String responses = this._connector.getResponses(request);
        int index = responses.indexOf("read=48");
        Assert.assertTrue((index > 0 ? 1 : 0) != 0);
        index = responses.indexOf("read=65", index + 7);
        Assert.assertTrue((index > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConnectionClose() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.getOutputStream().println("Hello World");
                return true;
            }
        };
        String response = this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\n\n", 200L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        Assert.assertFalse((response.indexOf("Connection: close") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Hello World") > 0 ? 1 : 0) != 0);
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\nConnection: close\n\n");
        Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Connection: close") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Hello World") > 0 ? 1 : 0) != 0);
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\nConnection: Other, close\n\n");
        Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Connection: close") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Hello World") > 0 ? 1 : 0) != 0);
        response = this._connector.getResponses("GET / HTTP/1.0\nHost: whatever\n\n");
        Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        Assert.assertFalse((response.indexOf("Connection: close") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Hello World") > 0 ? 1 : 0) != 0);
        response = this._connector.getResponses("GET / HTTP/1.0\nHost: whatever\nConnection: Other, close\n\n");
        Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Hello World") > 0 ? 1 : 0) != 0);
        response = this._connector.getResponses("GET / HTTP/1.0\nHost: whatever\nConnection: Other,,keep-alive\n\n", 200L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Connection: keep-alive") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Hello World") > 0 ? 1 : 0) != 0);
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.setHeader("Connection", "TE");
                response.addHeader("Connection", "Other");
                response.getOutputStream().println("Hello World");
                return true;
            }
        };
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\n\n", 200L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Connection: TE,Other") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Hello World") > 0 ? 1 : 0) != 0);
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\nConnection: close\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: close"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testCookies() throws Exception {
        final ArrayList cookies = new ArrayList();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                Cookie[] ca = request.getCookies();
                if (ca != null) {
                    cookies.addAll(Arrays.asList(ca));
                }
                response.getOutputStream().println("Hello World");
                return true;
            }
        };
        cookies.clear();
        String response = this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\nConnection: close\n\n");
        Assert.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assert.assertEquals((long)0L, (long)cookies.size());
        cookies.clear();
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\nCookie: name=quoted=\\\"value\\\"\nConnection: close\n\n");
        Assert.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assert.assertEquals((long)1L, (long)cookies.size());
        Assert.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"quoted=\\\"value\\\"", (Object)((Cookie)cookies.get(0)).getValue());
        cookies.clear();
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\nCookie: name=value; other=\"quoted=;value\"\nConnection: close\n\n");
        Assert.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assert.assertEquals((long)2L, (long)cookies.size());
        Assert.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"value", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((Object)"other", (Object)((Cookie)cookies.get(1)).getName());
        Assert.assertEquals((Object)"quoted=;value", (Object)((Cookie)cookies.get(1)).getValue());
        cookies.clear();
        response = this._connector.getResponses("GET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: name=value; other=\"quoted=;value\"\n\nGET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: name=value; other=\"quoted=;value\"\nConnection: close\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response.substring(15), (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertEquals((long)4L, (long)cookies.size());
        Assert.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"value", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((Object)"other", (Object)((Cookie)cookies.get(1)).getName());
        Assert.assertEquals((Object)"quoted=;value", (Object)((Cookie)cookies.get(1)).getValue());
        Assert.assertSame(cookies.get(0), cookies.get(2));
        Assert.assertSame(cookies.get(1), cookies.get(3));
        cookies.clear();
        response = this._connector.getResponses("GET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: name=value; other=\"quoted=;value\"\n\nGET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: name=value; other=\"othervalue\"\nConnection: close\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response.substring(15), (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertEquals((long)4L, (long)cookies.size());
        Assert.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"value", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((Object)"other", (Object)((Cookie)cookies.get(1)).getName());
        Assert.assertEquals((Object)"quoted=;value", (Object)((Cookie)cookies.get(1)).getValue());
        Assert.assertNotSame(cookies.get(0), cookies.get(2));
        Assert.assertNotSame(cookies.get(1), cookies.get(3));
        cookies.clear();
        response = this._connector.getResponses("POST / HTTP/1.1\r\nHost: whatever\r\nCookie: name0=value0; name1 = value1 ; \"name2\"  =  \"\\\"value2\\\"\"  \nCookie: $Version=2; name3=value3=value3;$path=/path;$domain=acme.com;$port=8080; name4=; name5 =  ; name6\nCookie: name7=value7;\nConnection: close\r\n\r\n");
        Assert.assertEquals((Object)"name0", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"value0", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((Object)"name1", (Object)((Cookie)cookies.get(1)).getName());
        Assert.assertEquals((Object)"value1", (Object)((Cookie)cookies.get(1)).getValue());
        Assert.assertEquals((Object)"name2", (Object)((Cookie)cookies.get(2)).getName());
        Assert.assertEquals((Object)"\"value2\"", (Object)((Cookie)cookies.get(2)).getValue());
        Assert.assertEquals((Object)"name3", (Object)((Cookie)cookies.get(3)).getName());
        Assert.assertEquals((Object)"value3=value3", (Object)((Cookie)cookies.get(3)).getValue());
        Assert.assertEquals((long)2L, (long)((Cookie)cookies.get(3)).getVersion());
        Assert.assertEquals((Object)"/path", (Object)((Cookie)cookies.get(3)).getPath());
        Assert.assertEquals((Object)"acme.com", (Object)((Cookie)cookies.get(3)).getDomain());
        Assert.assertEquals((Object)"$port=8080", (Object)((Cookie)cookies.get(3)).getComment());
        Assert.assertEquals((Object)"name4", (Object)((Cookie)cookies.get(4)).getName());
        Assert.assertEquals((Object)"", (Object)((Cookie)cookies.get(4)).getValue());
        Assert.assertEquals((Object)"name5", (Object)((Cookie)cookies.get(5)).getName());
        Assert.assertEquals((Object)"", (Object)((Cookie)cookies.get(5)).getValue());
        Assert.assertEquals((Object)"name6", (Object)((Cookie)cookies.get(6)).getName());
        Assert.assertEquals((Object)"", (Object)((Cookie)cookies.get(6)).getValue());
        Assert.assertEquals((Object)"name7", (Object)((Cookie)cookies.get(7)).getName());
        Assert.assertEquals((Object)"value7", (Object)((Cookie)cookies.get(7)).getValue());
        cookies.clear();
        response = this._connector.getResponses("GET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: __utmz=14316.133020.1.1.utr=gna.de|ucn=(real)|utd=reral|utct=/games/hen-one,gnt-50-ba-keys:key,2072262.html\nConnection: close\n\n");
        Assert.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assert.assertEquals((long)1L, (long)cookies.size());
        Assert.assertEquals((Object)"__utmz", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"14316.133020.1.1.utr=gna.de|ucn=(real)|utd=reral|utct=/games/hen-one,gnt-50-ba-keys:key,2072262.html", (Object)((Cookie)cookies.get(0)).getValue());
    }

    @Test
    public void testCookieLeak() throws Exception {
        final String[] cookie = new String[10];
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                for (int i = 0; i < cookie.length; ++i) {
                    cookie[i] = null;
                }
                Cookie[] cookies = request.getCookies();
                for (int i = 0; cookies != null && i < cookies.length; ++i) {
                    cookie[i] = cookies[i].getValue();
                }
                return true;
            }
        };
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nCookie: other=cookie\r\n\r\nPOST / HTTP/1.1\r\nHost: whatever\r\nCookie: name=value\r\nConnection: close\r\n\r\n";
        this._connector.getResponses(request);
        Assert.assertEquals((Object)"value", (Object)cookie[0]);
        Assert.assertEquals(null, (Object)cookie[1]);
        request = "POST / HTTP/1.1\r\nHost: whatever\r\nCookie: name=value\r\n\r\nPOST / HTTP/1.1\r\nHost: whatever\r\nCookie:\r\nConnection: close\r\n\r\n";
        this._connector.getResponses(request);
        Assert.assertEquals(null, (Object)cookie[0]);
        Assert.assertEquals(null, (Object)cookie[1]);
        request = "POST / HTTP/1.1\r\nHost: whatever\r\nCookie: name=value\r\nCookie: other=cookie\r\n\r\nPOST / HTTP/1.1\r\nHost: whatever\r\nCookie: name=value\r\nCookie:\r\nConnection: close\r\n\r\n";
        this._connector.getResponses(request);
        Assert.assertEquals((Object)"value", (Object)cookie[0]);
        Assert.assertEquals(null, (Object)cookie[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHashDOSKeys() throws Exception {
        ((StdErrLog)Log.getLogger(HttpChannel.class)).setHideStacks(true);
        LOG.info("Expecting maxFormKeys limit and Closing HttpParser exceptions...", new Object[0]);
        this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", (Object)-1);
        this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormKeys", (Object)1000);
        StringBuilder buf = new StringBuilder(4000000);
        buf.append("a=b");
        File evil_keys = new File("/tmp/keys_mapping_to_zero_2m");
        if (evil_keys.exists()) {
            LOG.info("Using real evil keys!", new Object[0]);
            try (BufferedReader in = new BufferedReader(new FileReader(evil_keys));){
                String key = null;
                while ((key = in.readLine()) != null) {
                    buf.append("&").append(key).append("=").append("x");
                }
            }
        } else {
            for (int i = 0; i < 2000; ++i) {
                buf.append("&").append("K").append(i).append("=").append("x");
            }
        }
        buf.append("&c=d");
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                return "b".equals(request.getParameter("a")) && request.getParameter("c") == null;
            }
        };
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\n" + "Content-Length: " + buf.length() + "\r\n" + "Connection: close\r\n" + "\r\n" + buf;
        try {
            long start = System.currentTimeMillis();
            String response = this._connector.getResponses(request);
            Assert.assertTrue((boolean)response.contains("Form too many keys"));
            long now = System.currentTimeMillis();
            Assert.assertTrue((now - start < 5000L ? 1 : 0) != 0);
        }
        finally {
            ((StdErrLog)Log.getLogger(HttpChannel.class)).setHideStacks(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHashDOSSize() throws Exception {
        ((StdErrLog)Log.getLogger(HttpChannel.class)).setHideStacks(true);
        LOG.info("Expecting maxFormSize limit and too much data exceptions...", new Object[0]);
        this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", (Object)3396);
        this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormKeys", (Object)1000);
        StringBuilder buf = new StringBuilder(4000000);
        buf.append("a=b");
        for (int i = 0; i < 500; ++i) {
            buf.append("&").append("K").append(i).append("=").append("x");
        }
        buf.append("&c=d");
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                return "b".equals(request.getParameter("a")) && request.getParameter("c") == null;
            }
        };
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\n" + "Content-Length: " + buf.length() + "\r\n" + "Connection: close\r\n" + "\r\n" + buf;
        try {
            long start = System.currentTimeMillis();
            String response = this._connector.getResponses(request);
            Assert.assertTrue((boolean)response.contains("Form too large:"));
            long now = System.currentTimeMillis();
            Assert.assertTrue((now - start < 5000L ? 1 : 0) != 0);
        }
        finally {
            ((StdErrLog)Log.getLogger(HttpChannel.class)).setHideStacks(false);
        }
    }

    @Test(expected=UnsupportedEncodingException.class)
    public void testNotSupportedCharacterEncoding() throws UnsupportedEncodingException {
        Request request = new Request(null, null);
        request.setCharacterEncoding("doesNotExist");
    }

    private class BadMultiPartRequestHandler
    extends AbstractHandler {
        File tmpDir;

        public BadMultiPartRequestHandler(File tmpDir) {
            this.tmpDir = tmpDir;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ((Request)request).setHandled(true);
            try {
                MultipartConfigElement mpce = new MultipartConfigElement(this.tmpDir.getAbsolutePath(), -1L, -1L, 2);
                request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)mpce);
                String string = request.getParameter("xxx");
            }
            catch (RuntimeException e) {
                response.sendError(500);
            }
        }
    }

    private class MultiPartRequestHandler
    extends AbstractHandler {
        File tmpDir;

        public MultiPartRequestHandler(File tmpDir) {
            this.tmpDir = tmpDir;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ((Request)request).setHandled(true);
            try {
                MultipartConfigElement mpce = new MultipartConfigElement(this.tmpDir.getAbsolutePath(), -1L, -1L, 2);
                request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)mpce);
                String field1 = request.getParameter("field1");
                Assert.assertNotNull((Object)field1);
                Part foo = request.getPart("stuff");
                Assert.assertNotNull((Object)foo);
                Assert.assertTrue((foo.getSize() > 0L ? 1 : 0) != 0);
                response.setStatus(200);
            }
            catch (IllegalStateException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("No multipart config"));
                response.setStatus(200);
            }
            catch (Exception e) {
                response.sendError(500);
            }
        }
    }

    private class RequestHandler
    extends AbstractHandler {
        private RequestTester _checker;
        private String _content;

        private RequestHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ((Request)request).setHandled(true);
            if (request.getContentLength() > 0 && !MimeTypes.Type.FORM_ENCODED.asString().equals(request.getContentType()) && !request.getContentType().startsWith("multipart/form-data")) {
                this._content = IO.toString((InputStream)request.getInputStream());
            }
            if (this._checker != null && this._checker.check(request, response)) {
                response.setStatus(200);
            } else {
                response.sendError(500);
            }
        }
    }

    static interface RequestTester {
        public boolean check(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
    }
}

