/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.AbstractHttpTest;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.toolchain.test.http.SimpleHttpResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HttpManyWaysToCommitTest
extends AbstractHttpTest {
    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{HttpVersion.HTTP_1_0.asString()}, {HttpVersion.HTTP_1_1.asString()}};
        return Arrays.asList(data);
    }

    public HttpManyWaysToCommitTest(String httpVersion) {
        super(httpVersion);
    }

    @Test
    public void testHandlerDoesNotSetHandled() throws Exception {
        server.setHandler((Handler)new DoesNotSetHandledHandler(false));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 404", (Object)response.getCode(), (Matcher)Matchers.is((Object)"404"));
    }

    @Test
    public void testHandlerDoesNotSetHandledAndThrow() throws Exception {
        server.setHandler((Handler)new DoesNotSetHandledHandler(true));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 500", (Object)response.getCode(), (Matcher)Matchers.is((Object)"500"));
    }

    @Test
    public void testHandlerSetsHandledTrueOnly() throws Exception {
        server.setHandler((Handler)new OnlySetHandledHandler(false));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        this.assertHeader(response, "content-length", "0");
    }

    @Test
    public void testHandlerSetsHandledTrueOnlyAndThrow() throws Exception {
        server.setHandler((Handler)new OnlySetHandledHandler(true));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 500", (Object)response.getCode(), (Matcher)Matchers.is((Object)"500"));
    }

    @Test
    public void testHandlerSetsHandledAndWritesSomeContent() throws Exception {
        server.setHandler((Handler)new SetHandledWriteSomeDataHandler(false));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        this.assertResponseBody(response, "foobar");
        this.assertHeader(response, "content-length", "6");
    }

    @Test
    public void testHandlerSetsHandledAndWritesSomeContentAndThrow() throws Exception {
        server.setHandler((Handler)new SetHandledWriteSomeDataHandler(true));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 500", (Object)response.getCode(), (Matcher)Matchers.is((Object)"500"));
        Assert.assertThat((String)"response body is not foobar", (Object)response.getBody(), (Matcher)Matchers.not((Matcher)Matchers.is((Object)"foobar")));
    }

    @Test
    public void testHandlerExplicitFlush() throws Exception {
        server.setHandler((Handler)new ExplicitFlushHandler(false));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        this.assertResponseBody(response, "foobar");
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
    }

    @Test
    public void testHandlerExplicitFlushAndThrow() throws Exception {
        server.setHandler((Handler)new ExplicitFlushHandler(true));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"response body is foobar", (Object)response.getBody(), (Matcher)Matchers.is((Object)"foobar"));
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
    }

    @Test
    public void testHandledAndFlushWithoutContent() throws Exception {
        server.setHandler((Handler)new SetHandledAndFlushWithoutContentHandler(false));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
    }

    @Test
    public void testHandledAndFlushWithoutContentAndThrow() throws Exception {
        server.setHandler((Handler)new SetHandledAndFlushWithoutContentHandler(true));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
    }

    @Test
    public void testHandledWriteFlushWriteMore() throws Exception {
        server.setHandler((Handler)new WriteFlushWriteMoreHandler(false));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        this.assertResponseBody(response, "foobar");
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
    }

    @Test
    public void testHandledWriteFlushWriteMoreAndThrow() throws Exception {
        server.setHandler((Handler)new WriteFlushWriteMoreHandler(true));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
    }

    @Test
    public void testHandledOverflow() throws Exception {
        server.setHandler((Handler)new OverflowHandler(false));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        this.assertResponseBody(response, "foobar");
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
    }

    @Test
    public void testHandledOverflow2() throws Exception {
        server.setHandler((Handler)new Overflow2Handler(false));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        this.assertResponseBody(response, "foobarfoobar");
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
    }

    @Test
    public void testHandledOverflow3() throws Exception {
        server.setHandler((Handler)new Overflow3Handler(false));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        this.assertResponseBody(response, "foobarfoobar");
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
    }

    @Test
    public void testHandledBufferOverflowAndThrow() throws Exception {
        server.setHandler((Handler)new OverflowHandler(true));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        this.assertResponseBody(response, "foobar");
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
    }

    @Test
    public void testSetContentLengthAndWriteExactlyThatAmountOfBytes() throws Exception {
        server.setHandler((Handler)new SetContentLengthAndWriteThatAmountOfBytesHandler(false));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"response body is foo", (Object)response.getBody(), (Matcher)Matchers.is((Object)"foo"));
        this.assertHeader(response, "content-length", "3");
    }

    @Test
    public void testSetContentLengthAndWriteExactlyThatAmountOfBytesAndThrow() throws Exception {
        server.setHandler((Handler)new SetContentLengthAndWriteThatAmountOfBytesHandler(true));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"response body is foo", (Object)response.getBody(), (Matcher)Matchers.is((Object)"foo"));
    }

    @Test
    public void testSetContentLengthAndWriteMoreBytes() throws Exception {
        server.setHandler((Handler)new SetContentLengthAndWriteMoreBytesHandler(false));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"response body is foo", (Object)response.getBody(), (Matcher)Matchers.is((Object)"foo"));
        this.assertHeader(response, "content-length", "3");
    }

    @Test
    public void testSetContentLengthAndWriteMoreAndThrow() throws Exception {
        server.setHandler((Handler)new SetContentLengthAndWriteMoreBytesHandler(true));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"response body is foo", (Object)response.getBody(), (Matcher)Matchers.is((Object)"foo"));
    }

    @Test
    public void testWriteAndSetContentLength() throws Exception {
        server.setHandler((Handler)new WriteAndSetContentLengthHandler(false));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"response body is foo", (Object)response.getBody(), (Matcher)Matchers.is((Object)"foo"));
        this.assertHeader(response, "content-length", "3");
    }

    @Test
    public void testWriteAndSetContentLengthAndThrow() throws Exception {
        server.setHandler((Handler)new WriteAndSetContentLengthHandler(true));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"response body is foo", (Object)response.getBody(), (Matcher)Matchers.is((Object)"foo"));
    }

    @Test
    public void testWriteAndSetContentLengthTooSmall() throws Exception {
        server.setHandler((Handler)new WriteAndSetContentLengthTooSmallHandler(false));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 500", (Object)response.getCode(), (Matcher)Matchers.is((Object)"500"));
        Assert.assertThat((String)"response body is not foo", (Object)response.getBody(), (Matcher)Matchers.not((Matcher)Matchers.is((Object)"foo")));
    }

    @Test
    public void testWriteAndSetContentLengthTooSmallAndThrow() throws Exception {
        server.setHandler((Handler)new WriteAndSetContentLengthTooSmallHandler(true));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 500", (Object)response.getCode(), (Matcher)Matchers.is((Object)"500"));
        Assert.assertThat((String)"response body is not foo", (Object)response.getBody(), (Matcher)Matchers.not((Matcher)Matchers.is((Object)"foo")));
    }

    private class WriteAndSetContentLengthTooSmallHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private WriteAndSetContentLengthTooSmallHandler(boolean throwException) {
            super(HttpManyWaysToCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.getWriter().write("foobar");
            response.setContentLength(3);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class WriteAndSetContentLengthHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private WriteAndSetContentLengthHandler(boolean throwException) {
            super(HttpManyWaysToCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.getWriter().write("foo");
            response.setContentLength(3);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class SetContentLengthAndWriteMoreBytesHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private SetContentLengthAndWriteMoreBytesHandler(boolean throwException) {
            super(HttpManyWaysToCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setContentLength(3);
            response.getWriter().write("foobar");
            super.handle(target, baseRequest, request, response);
        }
    }

    private class SetContentLengthAndWriteThatAmountOfBytesHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private SetContentLengthAndWriteThatAmountOfBytesHandler(boolean throwException) {
            super(HttpManyWaysToCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setContentLength(3);
            response.getWriter().write("foo");
            super.handle(target, baseRequest, request, response);
        }
    }

    private class Overflow3Handler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private Overflow3Handler(boolean throwException) {
            super(HttpManyWaysToCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setBufferSize(8);
            response.getWriter().write("fo");
            response.getWriter().write("ob");
            response.getWriter().write("ar");
            response.getWriter().write("fo");
            response.getWriter().write("ob");
            response.getWriter().write("ar");
            super.handle(target, baseRequest, request, response);
        }
    }

    private class Overflow2Handler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private Overflow2Handler(boolean throwException) {
            super(HttpManyWaysToCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setBufferSize(8);
            response.getWriter().write("fo");
            response.getWriter().write("obarfoobar");
            super.handle(target, baseRequest, request, response);
        }
    }

    private class OverflowHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private OverflowHandler(boolean throwException) {
            super(HttpManyWaysToCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setBufferSize(4);
            response.getWriter().write("foobar");
            super.handle(target, baseRequest, request, response);
        }
    }

    private class WriteFlushWriteMoreHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private WriteFlushWriteMoreHandler(boolean throwException) {
            super(HttpManyWaysToCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.getWriter().write("foo");
            response.flushBuffer();
            response.getWriter().write("bar");
            super.handle(target, baseRequest, request, response);
        }
    }

    private class SetHandledAndFlushWithoutContentHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private SetHandledAndFlushWithoutContentHandler(boolean throwException) {
            super(HttpManyWaysToCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.flushBuffer();
            super.handle(target, baseRequest, request, response);
        }
    }

    private class ExplicitFlushHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private ExplicitFlushHandler(boolean throwException) {
            super(HttpManyWaysToCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.getWriter().write("foobar");
            response.flushBuffer();
            super.handle(target, baseRequest, request, response);
        }
    }

    private class SetHandledWriteSomeDataHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private SetHandledWriteSomeDataHandler(boolean throwException) {
            super(HttpManyWaysToCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.getWriter().write("foobar");
            super.handle(target, baseRequest, request, response);
        }
    }

    private class OnlySetHandledHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private OnlySetHandledHandler(boolean throwException) {
            super(HttpManyWaysToCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class DoesNotSetHandledHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private DoesNotSetHandledHandler(boolean throwException) {
            super(HttpManyWaysToCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(false);
            super.handle(target, baseRequest, request, response);
        }
    }
}

