/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.AbstractHttpTest;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.toolchain.test.http.SimpleHttpResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HttpManyWaysToAsyncCommitTest
extends AbstractHttpTest {
    private final String CONTEXT_ATTRIBUTE = this.getClass().getName() + ".asyncContext";
    private boolean dispatch;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{HttpVersion.HTTP_1_0.asString(), true}, {HttpVersion.HTTP_1_1.asString(), true}, {HttpVersion.HTTP_1_0.asString(), false}, {HttpVersion.HTTP_1_1.asString(), false}};
        return Arrays.asList(data);
    }

    public HttpManyWaysToAsyncCommitTest(String httpVersion, boolean dispatch) {
        super(httpVersion);
        this.httpVersion = httpVersion;
        this.dispatch = dispatch;
    }

    @Test
    public void testHandlerDoesNotSetHandled() throws Exception {
        DoesNotSetHandledHandler handler = new DoesNotSetHandledHandler(false);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 404", (Object)response.getCode(), (Matcher)Matchers.is((Object)"404"));
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testHandlerDoesNotSetHandledAndThrow() throws Exception {
        DoesNotSetHandledHandler handler = new DoesNotSetHandledHandler(true);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 500", (Object)response.getCode(), (Matcher)Matchers.is((Object)"500"));
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testHandlerSetsHandledTrueOnly() throws Exception {
        OnlySetHandledHandler handler = new OnlySetHandledHandler(false);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        this.assertHeader(response, "content-length", "0");
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testHandlerSetsHandledTrueOnlyAndThrow() throws Exception {
        OnlySetHandledHandler handler = new OnlySetHandledHandler(true);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 500", (Object)response.getCode(), (Matcher)Matchers.is((Object)"500"));
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testHandlerSetsHandledAndWritesSomeContent() throws Exception {
        SetHandledWriteSomeDataHandler handler = new SetHandledWriteSomeDataHandler(false);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        this.assertHeader(response, "content-length", "6");
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testHandlerSetsHandledAndWritesSomeContentAndThrow() throws Exception {
        SetHandledWriteSomeDataHandler handler = new SetHandledWriteSomeDataHandler(true);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 500", (Object)response.getCode(), (Matcher)Matchers.is((Object)"500"));
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testHandlerExplicitFlush() throws Exception {
        ExplicitFlushHandler handler = new ExplicitFlushHandler(false);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
    }

    @Test
    public void testHandlerExplicitFlushAndThrow() throws Exception {
        ExplicitFlushHandler handler = new ExplicitFlushHandler(true);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
    }

    @Test
    public void testHandledAndFlushWithoutContent() throws Exception {
        SetHandledAndFlushWithoutContentHandler handler = new SetHandledAndFlushWithoutContentHandler(false);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
    }

    @Test
    public void testHandledAndFlushWithoutContentAndThrow() throws Exception {
        SetHandledAndFlushWithoutContentHandler handler = new SetHandledAndFlushWithoutContentHandler(true);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
    }

    @Test
    public void testWriteFlushWriteMore() throws Exception {
        WriteFlushWriteMoreHandler handler = new WriteFlushWriteMoreHandler(false);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
    }

    @Test
    public void testWriteFlushWriteMoreAndThrow() throws Exception {
        WriteFlushWriteMoreHandler handler = new WriteFlushWriteMoreHandler(true);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
    }

    @Test
    public void testBufferOverflow() throws Exception {
        OverflowHandler handler = new OverflowHandler(false);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        this.assertResponseBody(response, "foobar");
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testBufferOverflowAndThrow() throws Exception {
        OverflowHandler handler = new OverflowHandler(true);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        this.assertResponseBody(response, "foobar");
        if (!"HTTP/1.0".equals(this.httpVersion)) {
            this.assertHeader(response, "transfer-encoding", "chunked");
        }
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testSetContentLengthAndWriteExactlyThatAmountOfBytes() throws Exception {
        SetContentLengthAndWriteThatAmountOfBytesHandler handler = new SetContentLengthAndWriteThatAmountOfBytesHandler(false);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"response body is foo", (Object)response.getBody(), (Matcher)Matchers.is((Object)"foo"));
        this.assertHeader(response, "content-length", "3");
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testSetContentLengthAndWriteExactlyThatAmountOfBytesAndThrow() throws Exception {
        SetContentLengthAndWriteThatAmountOfBytesHandler handler = new SetContentLengthAndWriteThatAmountOfBytesHandler(true);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"response body is foo", (Object)response.getBody(), (Matcher)Matchers.is((Object)"foo"));
        this.assertHeader(response, "content-length", "3");
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testSetContentLengthAndWriteMoreBytes() throws Exception {
        SetContentLengthAndWriteMoreBytesHandler handler = new SetContentLengthAndWriteMoreBytesHandler(false);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"response body is foo", (Object)response.getBody(), (Matcher)Matchers.is((Object)"foo"));
        this.assertHeader(response, "content-length", "3");
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testSetContentLengthAndWriteMoreAndThrow() throws Exception {
        SetContentLengthAndWriteMoreBytesHandler handler = new SetContentLengthAndWriteMoreBytesHandler(true);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"response body is foo", (Object)response.getBody(), (Matcher)Matchers.is((Object)"foo"));
        this.assertHeader(response, "content-length", "3");
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testWriteAndSetContentLength() throws Exception {
        WriteAndSetContentLengthHandler handler = new WriteAndSetContentLengthHandler(false);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testWriteAndSetContentLengthAndThrow() throws Exception {
        WriteAndSetContentLengthHandler handler = new WriteAndSetContentLengthHandler(true);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)"200"));
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testWriteAndSetContentLengthTooSmall() throws Exception {
        WriteAndSetContentLengthTooSmallHandler handler = new WriteAndSetContentLengthTooSmallHandler(false);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 500", (Object)response.getCode(), (Matcher)Matchers.is((Object)"500"));
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testWriteAndSetContentLengthTooSmallAndThrow() throws Exception {
        WriteAndSetContentLengthTooSmallHandler handler = new WriteAndSetContentLengthTooSmallHandler(true);
        server.setHandler((Handler)handler);
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)"500"));
        Assert.assertThat((String)"no exceptions", (Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    private class WriteAndSetContentLengthTooSmallHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private WriteAndSetContentLengthTooSmallHandler(boolean throwException) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE) == null) {
                final AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE, (Object)asyncContext);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ServletResponse asyncContextResponse = asyncContext.getResponse();
                            asyncContextResponse.getWriter().write("foobar");
                            asyncContextResponse.setContentLength(3);
                            if (HttpManyWaysToAsyncCommitTest.this.dispatch) {
                                asyncContext.dispatch();
                            } else {
                                asyncContext.complete();
                            }
                        }
                        catch (IOException e) {
                            WriteAndSetContentLengthTooSmallHandler.this.markFailed(e);
                        }
                    }
                }).run();
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class WriteAndSetContentLengthHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private WriteAndSetContentLengthHandler(boolean throwException) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE) == null) {
                final AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE, (Object)asyncContext);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ServletResponse asyncContextResponse = asyncContext.getResponse();
                            asyncContextResponse.getWriter().write("foo");
                            asyncContextResponse.setContentLength(3);
                            if (HttpManyWaysToAsyncCommitTest.this.dispatch) {
                                asyncContext.dispatch();
                            } else {
                                asyncContext.complete();
                            }
                        }
                        catch (IOException e) {
                            WriteAndSetContentLengthHandler.this.markFailed(e);
                        }
                    }
                }).run();
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class SetContentLengthAndWriteMoreBytesHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private SetContentLengthAndWriteMoreBytesHandler(boolean throwException) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE) == null) {
                final AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE, (Object)asyncContext);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ServletResponse asyncContextResponse = asyncContext.getResponse();
                            asyncContextResponse.setContentLength(3);
                            asyncContextResponse.getWriter().write("foobar");
                            if (HttpManyWaysToAsyncCommitTest.this.dispatch) {
                                asyncContext.dispatch();
                            } else {
                                asyncContext.complete();
                            }
                        }
                        catch (IOException e) {
                            SetContentLengthAndWriteMoreBytesHandler.this.markFailed(e);
                        }
                    }
                }).run();
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class SetContentLengthAndWriteThatAmountOfBytesHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private SetContentLengthAndWriteThatAmountOfBytesHandler(boolean throwException) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE) == null) {
                final AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE, (Object)asyncContext);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ServletResponse asyncContextResponse = asyncContext.getResponse();
                            asyncContextResponse.setContentLength(3);
                            asyncContextResponse.getWriter().write("foo");
                            if (HttpManyWaysToAsyncCommitTest.this.dispatch) {
                                asyncContext.dispatch();
                            } else {
                                asyncContext.complete();
                            }
                        }
                        catch (IOException e) {
                            SetContentLengthAndWriteThatAmountOfBytesHandler.this.markFailed(e);
                        }
                    }
                }).run();
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class OverflowHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private OverflowHandler(boolean throwException) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE) == null) {
                final AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE, (Object)asyncContext);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ServletResponse asyncContextResponse = asyncContext.getResponse();
                            asyncContextResponse.setBufferSize(3);
                            asyncContextResponse.getWriter().write("foobar");
                            if (HttpManyWaysToAsyncCommitTest.this.dispatch) {
                                asyncContext.dispatch();
                            } else {
                                asyncContext.complete();
                            }
                        }
                        catch (IOException e) {
                            OverflowHandler.this.markFailed(e);
                        }
                    }
                }).run();
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class WriteFlushWriteMoreHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private WriteFlushWriteMoreHandler(boolean throwException) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE) == null) {
                final AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE, (Object)asyncContext);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ServletResponse asyncContextResponse = asyncContext.getResponse();
                            asyncContextResponse.getWriter().write("foo");
                            asyncContextResponse.flushBuffer();
                            asyncContextResponse.getWriter().write("bar");
                            if (HttpManyWaysToAsyncCommitTest.this.dispatch) {
                                asyncContext.dispatch();
                            } else {
                                asyncContext.complete();
                            }
                        }
                        catch (IOException e) {
                            WriteFlushWriteMoreHandler.this.markFailed(e);
                        }
                    }
                }).run();
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class SetHandledAndFlushWithoutContentHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private SetHandledAndFlushWithoutContentHandler(boolean throwException) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE) == null) {
                final AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE, (Object)asyncContext);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            asyncContext.getResponse().flushBuffer();
                            if (HttpManyWaysToAsyncCommitTest.this.dispatch) {
                                asyncContext.dispatch();
                            } else {
                                asyncContext.complete();
                            }
                        }
                        catch (IOException e) {
                            SetHandledAndFlushWithoutContentHandler.this.markFailed(e);
                        }
                    }
                }).run();
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class ExplicitFlushHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private ExplicitFlushHandler(boolean throwException) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE) == null) {
                final AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE, (Object)asyncContext);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ServletResponse asyncContextResponse = asyncContext.getResponse();
                            asyncContextResponse.getWriter().write("foobar");
                            asyncContextResponse.flushBuffer();
                            if (HttpManyWaysToAsyncCommitTest.this.dispatch) {
                                asyncContext.dispatch();
                            } else {
                                asyncContext.complete();
                            }
                        }
                        catch (IOException e) {
                            ExplicitFlushHandler.this.markFailed(e);
                        }
                    }
                }).run();
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class SetHandledWriteSomeDataHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private SetHandledWriteSomeDataHandler(boolean throwException) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE) == null) {
                final AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE, (Object)asyncContext);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            asyncContext.getResponse().getWriter().write("foobar");
                            if (HttpManyWaysToAsyncCommitTest.this.dispatch) {
                                asyncContext.dispatch();
                            } else {
                                asyncContext.complete();
                            }
                        }
                        catch (IOException e) {
                            SetHandledWriteSomeDataHandler.this.markFailed(e);
                        }
                    }
                }).run();
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class OnlySetHandledHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private OnlySetHandledHandler(boolean throwException) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE) == null) {
                final AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE, (Object)asyncContext);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (HttpManyWaysToAsyncCommitTest.this.dispatch) {
                            asyncContext.dispatch();
                        } else {
                            asyncContext.complete();
                        }
                    }
                }).run();
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class DoesNotSetHandledHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private DoesNotSetHandledHandler(boolean throwException) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE) == null) {
                final AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.CONTEXT_ATTRIBUTE, (Object)asyncContext);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (HttpManyWaysToAsyncCommitTest.this.dispatch) {
                            asyncContext.dispatch();
                        } else {
                            asyncContext.complete();
                        }
                    }
                }).run();
            }
            super.handle(target, baseRequest, request, response);
        }
    }
}

