/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HostHeaderCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.toolchain.test.TestTracker;
import org.eclipse.jetty.toolchain.test.http.SimpleHttpParser;
import org.eclipse.jetty.toolchain.test.http.SimpleHttpResponse;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class HostHeaderCustomizerTest {
    @Rule
    public TestTracker tracker = new TestTracker();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHostHeaderCustomizer() throws Exception {
        Server server = new Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        String serverName = "test_server_name";
        int serverPort = 13;
        String redirectPath = "/redirect";
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new HostHeaderCustomizer("test_server_name", 13));
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        server.addConnector((Connector)connector);
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                Assert.assertEquals((Object)"test_server_name", (Object)request.getServerName());
                Assert.assertEquals((long)13L, (long)request.getServerPort());
                response.sendRedirect("/redirect");
            }
        });
        server.start();
        try (Socket socket = new Socket("localhost", connector.getLocalPort());){
            OutputStream output = socket.getOutputStream();
            String request = "GET / HTTP/1.0\r\n\r\n";
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
            SimpleHttpParser parser = new SimpleHttpParser();
            SimpleHttpResponse response = parser.readResponse(input);
            String location = (String)response.getHeaders().get("location");
            Assert.assertNotNull((Object)location);
            String schemePrefix = "http://";
            Assert.assertTrue((boolean)location.startsWith(schemePrefix));
            Assert.assertTrue((boolean)location.endsWith("/redirect"));
            String hostPort = location.substring(schemePrefix.length(), location.length() - "/redirect".length());
            Assert.assertEquals((Object)"test_server_name:13", (Object)hostPort);
        }
        finally {
            server.stop();
        }
    }
}

