/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.junit.Assert;
import org.junit.Test;

public class CheckReverseProxyHeadersTest {
    @Test
    public void testCheckReverseProxyHeaders() throws Exception {
        this.testRequest("Host: localhost:8080\nX-Forwarded-For: 10.20.30.40\nX-Forwarded-Host: example.com", new RequestValidator(){

            @Override
            public void validate(HttpServletRequest request) {
                Assert.assertEquals((Object)"example.com", (Object)request.getServerName());
                Assert.assertEquals((long)80L, (long)request.getServerPort());
                Assert.assertEquals((Object)"10.20.30.40", (Object)request.getRemoteAddr());
                Assert.assertEquals((Object)"10.20.30.40", (Object)request.getRemoteHost());
                Assert.assertEquals((Object)"example.com", (Object)request.getHeader("Host"));
                Assert.assertEquals((Object)"http", (Object)request.getScheme());
                Assert.assertFalse((boolean)request.isSecure());
            }
        });
        this.testRequest("Host: localhost:8080\nX-Forwarded-For: 10.20.30.40\nX-Forwarded-Host: [::1]", new RequestValidator(){

            @Override
            public void validate(HttpServletRequest request) {
                Assert.assertEquals((Object)"[::1]", (Object)request.getServerName());
                Assert.assertEquals((long)80L, (long)request.getServerPort());
                Assert.assertEquals((Object)"10.20.30.40", (Object)request.getRemoteAddr());
                Assert.assertEquals((Object)"10.20.30.40", (Object)request.getRemoteHost());
                Assert.assertEquals((Object)"[::1]", (Object)request.getHeader("Host"));
                Assert.assertEquals((Object)"http", (Object)request.getScheme());
                Assert.assertFalse((boolean)request.isSecure());
            }
        });
        this.testRequest("Host: localhost:8080\nX-Forwarded-For: 10.20.30.40\nX-Forwarded-Host: [::1]:8888", new RequestValidator(){

            @Override
            public void validate(HttpServletRequest request) {
                Assert.assertEquals((Object)"[::1]", (Object)request.getServerName());
                Assert.assertEquals((long)8888L, (long)request.getServerPort());
                Assert.assertEquals((Object)"10.20.30.40", (Object)request.getRemoteAddr());
                Assert.assertEquals((Object)"10.20.30.40", (Object)request.getRemoteHost());
                Assert.assertEquals((Object)"[::1]:8888", (Object)request.getHeader("Host"));
                Assert.assertEquals((Object)"http", (Object)request.getScheme());
                Assert.assertFalse((boolean)request.isSecure());
            }
        });
        this.testRequest("Host: localhost:8080\nX-Forwarded-For: 10.20.30.40\nX-Forwarded-Host: example.com:81\nX-Forwarded-Server: example.com\nX-Forwarded-Proto: https", new RequestValidator(){

            @Override
            public void validate(HttpServletRequest request) {
                Assert.assertEquals((Object)"example.com", (Object)request.getServerName());
                Assert.assertEquals((long)81L, (long)request.getServerPort());
                Assert.assertEquals((Object)"10.20.30.40", (Object)request.getRemoteAddr());
                Assert.assertEquals((Object)"10.20.30.40", (Object)request.getRemoteHost());
                Assert.assertEquals((Object)"example.com:81", (Object)request.getHeader("Host"));
                Assert.assertEquals((Object)"https", (Object)request.getScheme());
                Assert.assertTrue((boolean)request.isSecure());
            }
        });
        this.testRequest("Host: localhost:8080\nX-Forwarded-For: 10.20.30.40, 10.0.0.1\nX-Forwarded-Host: example.com, rp.example.com:82\nX-Forwarded-Server: example.com, rp.example.com\nX-Forwarded-Proto: https, http", new RequestValidator(){

            @Override
            public void validate(HttpServletRequest request) {
                Assert.assertEquals((Object)"example.com", (Object)request.getServerName());
                Assert.assertEquals((long)443L, (long)request.getServerPort());
                Assert.assertEquals((Object)"10.20.30.40", (Object)request.getRemoteAddr());
                Assert.assertEquals((Object)"10.20.30.40", (Object)request.getRemoteHost());
                Assert.assertEquals((Object)"example.com", (Object)request.getHeader("Host"));
                Assert.assertEquals((Object)"https", (Object)request.getScheme());
                Assert.assertTrue((boolean)request.isSecure());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRequest(String headers, RequestValidator requestValidator) throws Exception {
        Server server = new Server();
        HttpConnectionFactory http = new HttpConnectionFactory();
        http.getHttpConfiguration().addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        LocalConnector connector = new LocalConnector(server, (ConnectionFactory)http);
        server.setConnectors(new Connector[]{connector});
        ValidationHandler validationHandler = new ValidationHandler(requestValidator);
        server.setHandler((Handler)validationHandler);
        try {
            server.start();
            connector.getResponses("GET / HTTP/1.1\r\nConnection: close\r\n" + headers + "\r\n\r\n", 1000L, TimeUnit.SECONDS);
            Error error = validationHandler.getError();
            if (error != null) {
                throw error;
            }
        }
        finally {
            server.stop();
        }
    }

    private static class ValidationHandler
    extends AbstractHandler {
        private final RequestValidator _requestValidator;
        private Error _error;

        private ValidationHandler(RequestValidator requestValidator) {
            this._requestValidator = requestValidator;
        }

        public Error getError() {
            return this._error;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            try {
                this._requestValidator.validate(request);
            }
            catch (Error e) {
                this._error = e;
            }
            catch (Throwable e) {
                this._error = new Error(e);
            }
        }
    }

    private static interface RequestValidator {
        public void validate(HttpServletRequest var1);
    }
}

