/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.server.Deployable;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Environment;
import org.eclipse.jetty.util.resource.PathCollators;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreContextHandler
extends ContextHandler
implements Deployable {
    private static final Logger LOG = LoggerFactory.getLogger(CoreContextHandler.class);
    private static final String ORIGINAL_BASE_RESOURCE = "org.eclipse.jetty.webapp.originalBaseResource";
    private boolean _initialized = false;
    private List<Resource> _extraClasspath;
    private boolean _builtClassLoader = false;

    public CoreContextHandler() {
        this("/");
    }

    public CoreContextHandler(String contextPath) {
        this.setContextPath(contextPath);
    }

    @ManagedAttribute(value="extra classpath for context classloader", readonly=true)
    public List<Resource> getExtraClasspath() {
        return this._extraClasspath == null ? Collections.emptyList() : this._extraClasspath;
    }

    @Override
    public void initializeDefaults(Attributes attributes) {
        try {
            for (String keyName : attributes.getAttributeNameSet()) {
                Object value = attributes.getAttribute(keyName);
                switch (keyName) {
                    case "jetty.deploy.contextPath": 
                    case "jetty.deploy.defaultContextPath": {
                        this.setContextPath((String)value);
                        break;
                    }
                    case "jetty.deploy.paths.other": {
                        Collection deployablePaths = (Collection)value;
                        Optional<Path> optionalDir = deployablePaths.stream().sorted(PathCollators.byName((boolean)true)).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> FileID.isExtension((String)p.getFileName().toString(), (String[])new String[]{"d"})).findFirst();
                        if (!optionalDir.isPresent()) break;
                        ResourceFactory resourceFactory = ResourceFactory.of((Container)this);
                        Resource resourceDir = resourceFactory.newResource(optionalDir.get());
                        this.setBaseResource(resourceDir);
                    }
                }
            }
            this.initWebApp();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Unable to init " + this.getClass().getSimpleName(), (Throwable)e);
        }
    }

    public void setExtraClasspath(String extraClasspath) {
        this.setExtraClasspath(this.getResourceFactory().split(extraClasspath));
    }

    public void setExtraClasspath(List<Resource> extraClasspath) {
        this._extraClasspath = extraClasspath;
    }

    public ResourceFactory getResourceFactory() {
        return ResourceFactory.of((Container)this);
    }

    protected Resource unpack(Resource dir) throws IOException {
        Path tempDir = this.getTempDirectory().toPath();
        dir.copyTo(tempDir);
        return ResourceFactory.of((Container)this).newResource(tempDir);
    }

    protected ClassLoader newClassLoader(Resource base) throws IOException {
        List<Resource> extraEntries;
        ArrayList<URL> urls = new ArrayList<URL>();
        if (Resources.isDirectory((Resource)base)) {
            Resource classesDir;
            Resource libDir = base.resolve("lib");
            if (Resources.isDirectory((Resource)libDir)) {
                for (Resource entry : libDir.list()) {
                    URI uri = entry.getURI();
                    if (!FileID.isJavaArchive((URI)uri)) continue;
                    urls.add(uri.toURL());
                }
            }
            if (Resources.isDirectory((Resource)(classesDir = base.resolve("classes")))) {
                urls.add(classesDir.getURI().toURL());
            }
        }
        if ((extraEntries = this.getExtraClasspath()) != null && !extraEntries.isEmpty()) {
            for (Resource entry : extraEntries) {
                urls.add(entry.getURI().toURL());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Core classloader for {}", urls);
        }
        if (urls.isEmpty()) {
            return Environment.CORE.getClassLoader();
        }
        return new URLClassLoader((URL[])urls.toArray(URL[]::new), Environment.CORE.getClassLoader());
    }

    protected void initWebApp() throws IOException {
        if (this._initialized) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Already initialized, not initializing again");
            }
            return;
        }
        if (this.getBaseResource() == null) {
            return;
        }
        Resource base = this.getBaseResource();
        if (!Resources.isDirectory((Resource)base)) {
            if (FileID.isExtension((URI)base.getURI(), (String[])new String[]{"zip", "jar", "war"})) {
                this.setAttribute(ORIGINAL_BASE_RESOURCE, base.getURI());
                try (ResourceFactory.Closeable resourceFactory = ResourceFactory.closeable();){
                    URI archiveURI = URIUtil.toJarFileUri((URI)base.getURI());
                    Resource mountedArchive = resourceFactory.newResource(archiveURI);
                    base = this.unpack(mountedArchive);
                    this.setBaseResource(base);
                }
            } else {
                throw new IllegalArgumentException("Unrecognized non-directory base resource type: " + String.valueOf(base));
            }
        }
        this._initialized = true;
        Resource staticDir = base.resolve("static");
        if (Resources.isDirectory((Resource)staticDir) && !this.isResourceHandlerAlreadyPresent(staticDir)) {
            ResourceHandler resourceHandler = new ResourceHandler();
            resourceHandler.setBaseResource(staticDir);
            this.setHandler(resourceHandler);
        }
        if (this.getClassLoader() == null) {
            this._builtClassLoader = true;
            this.setClassLoader(this.newClassLoader(this.getBaseResource()));
        }
    }

    private boolean isResourceHandlerAlreadyPresent(Resource staticDir) {
        boolean alreadyExists = false;
        for (Handler handler : this.getHandlers()) {
            URI baseResourceURI;
            ResourceHandler resourceHandler;
            Resource baseResource;
            if (!(handler instanceof ResourceHandler) || (baseResource = (resourceHandler = (ResourceHandler)handler).getBaseResource()) == null || !(baseResourceURI = baseResource.getURI()).equals(staticDir.getURI())) continue;
            alreadyExists = true;
        }
        return alreadyExists;
    }

    @Override
    protected void doStart() throws Exception {
        this.initWebApp();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (this._builtClassLoader) {
            this.setClassLoader(null);
            this._builtClassLoader = false;
        }
        this._initialized = false;
        super.doStop();
    }
}

