/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Condition;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.ThreadPool;

public class ReservedThreadExecutor
extends AbstractLifeCycle
implements Executor {
    private static final Logger LOG = Log.getLogger(ReservedThreadExecutor.class);
    private final Executor _executor;
    private final Locker _locker = new Locker();
    private final ReservedThread[] _queue;
    private int _head;
    private int _size;
    private int _pending;

    public ReservedThreadExecutor(Executor executor) {
        this(executor, 1);
    }

    public ReservedThreadExecutor(Executor executor, int capacity) {
        this._executor = executor;
        if (capacity < 0) {
            if (executor instanceof ThreadPool) {
                int threads = ((ThreadPool)executor).getThreads();
                int cpus = Runtime.getRuntime().availableProcessors();
                capacity = Math.max(1, Math.min(cpus, threads / 8));
            } else {
                capacity = Runtime.getRuntime().availableProcessors();
            }
        }
        this._queue = new ReservedThread[capacity];
    }

    public Executor getExecutor() {
        return this._executor;
    }

    public int getCapacity() {
        return this._queue.length;
    }

    public int getPreallocated() {
        try (Locker.Lock lock = this._locker.lock();){
            int n = this._size;
            return n;
        }
    }

    @Override
    public void doStart() throws Exception {
        try (Locker.Lock lock = this._locker.lock();){
            this._pending = 0;
            this._size = 0;
            this._head = 0;
            while (this._pending < this._queue.length) {
                this._executor.execute(new ReservedThread());
                ++this._pending;
            }
        }
    }

    @Override
    public void doStop() throws Exception {
        try (Locker.Lock lock = this._locker.lock();){
            while (this._size > 0) {
                ReservedThread thread = this._queue[this._head];
                this._queue[this._head] = null;
                this._head = (this._head + 1) % this._queue.length;
                --this._size;
                thread._wakeup.signal();
            }
        }
    }

    @Override
    public void execute(Runnable task) throws RejectedExecutionException {
        if (!this.tryExecute(task)) {
            throw new RejectedExecutionException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryExecute(Runnable task) {
        if (task == null) {
            return false;
        }
        try (Locker.Lock lock = this._locker.lock();){
            if (this._size == 0) {
                if (this._pending < this._queue.length) {
                    this._executor.execute(new ReservedThread());
                    ++this._pending;
                }
                boolean bl2 = false;
                return bl2;
            }
            ReservedThread thread = this._queue[this._head];
            this._queue[this._head] = null;
            this._head = (this._head + 1) % this._queue.length;
            --this._size;
            if (this._size == 0 && this._pending < this._queue.length) {
                this._executor.execute(new ReservedThread());
                ++this._pending;
            }
            thread._task = task;
            thread._wakeup.signal();
            boolean bl = true;
            return bl;
        }
        catch (RejectedExecutionException e) {
            LOG.ignore(e);
            return false;
        }
    }

    public String toString() {
        try (Locker.Lock lock = this._locker.lock();){
            String string = String.format("%s{s=%d,p=%d}", super.toString(), this._size, this._pending);
            return string;
        }
    }

    private class ReservedThread
    implements Runnable {
        private Condition _wakeup = null;
        private Runnable _task = null;

        private ReservedThread() {
        }

        private void reservedWait() throws InterruptedException {
            this._wakeup.await();
        }

        @Override
        public void run() {
            while (true) {
                Runnable task = null;
                try (Locker.Lock lock = ReservedThreadExecutor.this._locker.lock();){
                    if (this._wakeup == null) {
                        ReservedThreadExecutor.this._pending--;
                        this._wakeup = ReservedThreadExecutor.this._locker.newCondition();
                    }
                    if (!ReservedThreadExecutor.this.isRunning() || ReservedThreadExecutor.this._size >= ReservedThreadExecutor.this._queue.length) break;
                    ((ReservedThreadExecutor)ReservedThreadExecutor.this)._queue[(((ReservedThreadExecutor)ReservedThreadExecutor.this)._head + ((ReservedThreadExecutor)ReservedThreadExecutor.this)._size++) % ((ReservedThreadExecutor)ReservedThreadExecutor.this)._queue.length] = this;
                    do {
                        try {
                            this.reservedWait();
                            task = this._task;
                            this._task = null;
                        }
                        catch (InterruptedException e) {
                            LOG.ignore(e);
                        }
                    } while (ReservedThreadExecutor.this.isRunning() && task == null);
                }
                if (task == null) continue;
                try {
                    task.run();
                }
                catch (Exception e) {
                    LOG.warn(e);
                    break;
                }
            }
        }
    }
}

