/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class Javadoc
extends ASTNode {
    public JavadocSingleNameReference[] paramReferences;
    public JavadocSingleTypeReference[] paramTypeParameters;
    public TypeReference[] exceptionReferences;
    public JavadocReturnStatement returnStatement;
    public Expression[] seeReferences;
    public long[] inheritedPositions = null;
    public JavadocSingleNameReference[] invalidParameters;
    public long valuePositions = -1L;

    public Javadoc(int sourceStart, int sourceEnd) {
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        this.bits |= 0x10000;
    }

    boolean canBeSeen(int visibility, int modifiers) {
        if (modifiers < 0) {
            return true;
        }
        switch (modifiers & 7) {
            case 1: {
                return true;
            }
            case 4: {
                return visibility != 1;
            }
            case 0: {
                return visibility == 0 || visibility == 2;
            }
            case 2: {
                return visibility == 2;
            }
        }
        return true;
    }

    public ASTNode getNodeStartingAt(int start) {
        Expression param;
        int i2;
        int length = 0;
        if (this.paramReferences != null) {
            length = this.paramReferences.length;
            i2 = 0;
            while (i2 < length) {
                param = this.paramReferences[i2];
                if (param.sourceStart == start) {
                    return param;
                }
                ++i2;
            }
        }
        if (this.invalidParameters != null) {
            length = this.invalidParameters.length;
            i2 = 0;
            while (i2 < length) {
                param = this.invalidParameters[i2];
                if (param.sourceStart == start) {
                    return param;
                }
                ++i2;
            }
        }
        if (this.paramTypeParameters != null) {
            length = this.paramTypeParameters.length;
            i2 = 0;
            while (i2 < length) {
                param = this.paramTypeParameters[i2];
                if (((JavadocSingleTypeReference)param).sourceStart == start) {
                    return param;
                }
                ++i2;
            }
        }
        if (this.exceptionReferences != null) {
            length = this.exceptionReferences.length;
            i2 = 0;
            while (i2 < length) {
                TypeReference typeRef = this.exceptionReferences[i2];
                if (typeRef.sourceStart == start) {
                    return typeRef;
                }
                ++i2;
            }
        }
        if (this.seeReferences != null) {
            length = this.seeReferences.length;
            i2 = 0;
            while (i2 < length) {
                int l;
                int j;
                Expression expression = this.seeReferences[i2];
                if (expression.sourceStart == start) {
                    return expression;
                }
                if (expression instanceof JavadocAllocationExpression) {
                    JavadocAllocationExpression allocationExpr = (JavadocAllocationExpression)this.seeReferences[i2];
                    if (allocationExpr.binding != null && allocationExpr.binding.isValidBinding() && allocationExpr.arguments != null) {
                        j = 0;
                        l = allocationExpr.arguments.length;
                        while (j < l) {
                            if (allocationExpr.arguments[j].sourceStart == start) {
                                return allocationExpr.arguments[j];
                            }
                            ++j;
                        }
                    }
                } else if (expression instanceof JavadocMessageSend) {
                    JavadocMessageSend messageSend = (JavadocMessageSend)this.seeReferences[i2];
                    if (messageSend.binding != null && messageSend.binding.isValidBinding() && messageSend.arguments != null) {
                        j = 0;
                        l = messageSend.arguments.length;
                        while (j < l) {
                            if (messageSend.arguments[j].sourceStart == start) {
                                return messageSend.arguments[j];
                            }
                            ++j;
                        }
                    }
                }
                ++i2;
            }
        }
        return null;
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        int length;
        int i2;
        Javadoc.printIndent(indent, output).append("/**\n");
        if (this.paramReferences != null) {
            i2 = 0;
            length = this.paramReferences.length;
            while (i2 < length) {
                Javadoc.printIndent(indent + 1, output).append(" * @param ");
                this.paramReferences[i2].print(indent, output).append('\n');
                ++i2;
            }
        }
        if (this.paramTypeParameters != null) {
            i2 = 0;
            length = this.paramTypeParameters.length;
            while (i2 < length) {
                Javadoc.printIndent(indent + 1, output).append(" * @param <");
                this.paramTypeParameters[i2].print(indent, output).append(">\n");
                ++i2;
            }
        }
        if (this.returnStatement != null) {
            Javadoc.printIndent(indent + 1, output).append(" * @");
            this.returnStatement.print(indent, output).append('\n');
        }
        if (this.exceptionReferences != null) {
            i2 = 0;
            length = this.exceptionReferences.length;
            while (i2 < length) {
                Javadoc.printIndent(indent + 1, output).append(" * @throws ");
                this.exceptionReferences[i2].print(indent, output).append('\n');
                ++i2;
            }
        }
        if (this.seeReferences != null) {
            i2 = 0;
            length = this.seeReferences.length;
            while (i2 < length) {
                Javadoc.printIndent(indent + 1, output).append(" * @see ");
                this.seeReferences[i2].print(indent, output).append('\n');
                ++i2;
            }
        }
        Javadoc.printIndent(indent, output).append(" */\n");
        return output;
    }

    public void resolve(ClassScope scope) {
        boolean source15;
        int i2;
        if ((this.bits & 0x10000) == 0) {
            return;
        }
        this.bits &= 0xFFFEFFFF;
        if (this.inheritedPositions != null) {
            int length = this.inheritedPositions.length;
            i2 = 0;
            while (i2 < length) {
                int start = (int)(this.inheritedPositions[i2] >>> 32);
                int end = (int)this.inheritedPositions[i2];
                scope.problemReporter().javadocUnexpectedTag(start, end);
                ++i2;
            }
        }
        int paramTagsSize = this.paramReferences == null ? 0 : this.paramReferences.length;
        i2 = 0;
        while (i2 < paramTagsSize) {
            JavadocSingleNameReference param = this.paramReferences[i2];
            scope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
            ++i2;
        }
        this.resolveTypeParameterTags(scope, true);
        if (this.returnStatement != null) {
            scope.problemReporter().javadocUnexpectedTag(this.returnStatement.sourceStart, this.returnStatement.sourceEnd);
        }
        int throwsTagsLength = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
        int i3 = 0;
        while (i3 < throwsTagsLength) {
            int end;
            int start;
            TypeReference typeRef = this.exceptionReferences[i3];
            if (typeRef instanceof JavadocSingleTypeReference) {
                JavadocSingleTypeReference singleRef = (JavadocSingleTypeReference)typeRef;
                start = singleRef.tagSourceStart;
                end = singleRef.tagSourceEnd;
            } else if (typeRef instanceof JavadocQualifiedTypeReference) {
                JavadocQualifiedTypeReference qualifiedRef = (JavadocQualifiedTypeReference)typeRef;
                start = qualifiedRef.tagSourceStart;
                end = qualifiedRef.tagSourceEnd;
            } else {
                start = typeRef.sourceStart;
                end = typeRef.sourceEnd;
            }
            scope.problemReporter().javadocUnexpectedTag(start, end);
            ++i3;
        }
        int seeTagsLength = this.seeReferences == null ? 0 : this.seeReferences.length;
        int i4 = 0;
        while (i4 < seeTagsLength) {
            this.resolveReference(this.seeReferences[i4], scope);
            ++i4;
        }
        boolean bl = source15 = scope.compilerOptions().sourceLevel >= 0x310000L;
        if (!source15 && this.valuePositions != -1L) {
            scope.problemReporter().javadocUnexpectedTag((int)(this.valuePositions >>> 32), (int)this.valuePositions);
        }
    }

    public void resolve(CompilationUnitScope unitScope) {
        if ((this.bits & 0x10000) == 0) {
            return;
        }
    }

    public void resolve(MethodScope methScope) {
        boolean source15;
        boolean reportMissing;
        if ((this.bits & 0x10000) == 0) {
            return;
        }
        this.bits &= 0xFFFEFFFF;
        AbstractMethodDeclaration methDecl = methScope.referenceMethod();
        boolean overriding = methDecl == null || methDecl.binding == null ? false : !methDecl.binding.isStatic() && (methDecl.binding.modifiers & 0x30000000) != 0;
        int seeTagsLength = this.seeReferences == null ? 0 : this.seeReferences.length;
        boolean superRef = false;
        int i2 = 0;
        while (i2 < seeTagsLength) {
            this.resolveReference(this.seeReferences[i2], methScope);
            if (methDecl != null && !superRef) {
                TypeBinding superType;
                if (!methDecl.isConstructor()) {
                    if (overriding && this.seeReferences[i2] instanceof JavadocMessageSend) {
                        ReferenceBinding methodReceiverType;
                        JavadocMessageSend messageSend = (JavadocMessageSend)this.seeReferences[i2];
                        if (messageSend.binding != null && messageSend.binding.isValidBinding() && messageSend.actualReceiverType instanceof ReferenceBinding && (superType = methDecl.binding.declaringClass.findSuperTypeOriginatingFrom(methodReceiverType = (ReferenceBinding)messageSend.actualReceiverType)) != null && TypeBinding.notEquals(superType.original(), methDecl.binding.declaringClass) && CharOperation.equals(messageSend.selector, methDecl.selector) && methScope.environment().methodVerifier().doesMethodOverride(methDecl.binding, messageSend.binding.original())) {
                            superRef = true;
                        }
                    }
                } else if (this.seeReferences[i2] instanceof JavadocAllocationExpression) {
                    MethodBinding superConstructor;
                    ReferenceBinding allocType;
                    JavadocAllocationExpression allocationExpr = (JavadocAllocationExpression)this.seeReferences[i2];
                    if (allocationExpr.binding != null && allocationExpr.binding.isValidBinding() && (superType = (ReferenceBinding)methDecl.binding.declaringClass.findSuperTypeOriginatingFrom(allocType = (ReferenceBinding)allocationExpr.resolvedType.original())) != null && TypeBinding.notEquals(superType.original(), methDecl.binding.declaringClass) && (superConstructor = methScope.getConstructor((ReferenceBinding)superType, methDecl.binding.parameters, allocationExpr)).isValidBinding() && superConstructor.original() == allocationExpr.binding.original()) {
                        MethodBinding current = methDecl.binding;
                        if (methScope.compilerOptions().sourceLevel >= 0x340000L && current.typeVariables != Binding.NO_TYPE_VARIABLES) {
                            current = current.asRawMethod(methScope.environment());
                        }
                        if (superConstructor.areParametersEqual(current)) {
                            superRef = true;
                        }
                    }
                }
            }
            ++i2;
        }
        if (!superRef && methDecl != null && methDecl.annotations != null) {
            int length = methDecl.annotations.length;
            int i3 = 0;
            while (i3 < length && !superRef) {
                superRef = (methDecl.binding.tagBits & 0x2000000000000L) != 0L;
                ++i3;
            }
        }
        boolean bl = reportMissing = methDecl == null || (!overriding || this.inheritedPositions == null) && !superRef && (methDecl.binding.declaringClass == null || !methDecl.binding.declaringClass.isLocalType());
        if (!overriding && this.inheritedPositions != null) {
            int length = this.inheritedPositions.length;
            int i4 = 0;
            while (i4 < length) {
                int start = (int)(this.inheritedPositions[i4] >>> 32);
                int end = (int)this.inheritedPositions[i4];
                methScope.problemReporter().javadocUnexpectedTag(start, end);
                ++i4;
            }
        }
        CompilerOptions compilerOptions = methScope.compilerOptions();
        this.resolveParamTags(methScope, reportMissing, compilerOptions.reportUnusedParameterIncludeDocCommentReference);
        this.resolveTypeParameterTags(methScope, reportMissing && compilerOptions.reportMissingJavadocTagsMethodTypeParameters);
        if (this.returnStatement == null) {
            if (reportMissing && methDecl != null && methDecl.isMethod()) {
                MethodDeclaration meth = (MethodDeclaration)methDecl;
                if (meth.binding.returnType != TypeBinding.VOID) {
                    methScope.problemReporter().javadocMissingReturnTag(meth.returnType.sourceStart, meth.returnType.sourceEnd, methDecl.binding.modifiers);
                }
            }
        } else {
            this.returnStatement.resolve(methScope);
        }
        this.resolveThrowsTags(methScope, reportMissing);
        boolean bl2 = source15 = compilerOptions.sourceLevel >= 0x310000L;
        if (!source15 && methDecl != null && this.valuePositions != -1L) {
            methScope.problemReporter().javadocUnexpectedTag((int)(this.valuePositions >>> 32), (int)this.valuePositions);
        }
        int length = this.invalidParameters == null ? 0 : this.invalidParameters.length;
        int i5 = 0;
        while (i5 < length) {
            this.invalidParameters[i5].resolve(methScope, false, false);
            ++i5;
        }
    }

    private void resolveReference(Expression reference, Scope scope) {
        int problemCount = scope.referenceContext().compilationResult().problemCount;
        switch (scope.kind) {
            case 2: {
                reference.resolveType((MethodScope)scope);
                break;
            }
            case 3: {
                reference.resolveType((ClassScope)scope);
            }
        }
        boolean hasProblems = scope.referenceContext().compilationResult().problemCount > problemCount;
        boolean source15 = scope.compilerOptions().sourceLevel >= 0x310000L;
        int scopeModifiers = -1;
        if (reference instanceof JavadocFieldReference) {
            ReferenceBinding resolvedType;
            JavadocFieldReference fieldRef = (JavadocFieldReference)reference;
            if (fieldRef.methodBinding != null) {
                if (fieldRef.tagValue == 10) {
                    if (scopeModifiers == -1) {
                        scopeModifiers = scope.getDeclarationModifiers();
                    }
                    scope.problemReporter().javadocInvalidValueReference(fieldRef.sourceStart, fieldRef.sourceEnd, scopeModifiers);
                } else if (fieldRef.actualReceiverType != null) {
                    if (scope.enclosingSourceType().isCompatibleWith(fieldRef.actualReceiverType)) {
                        fieldRef.bits |= 0x4000;
                    }
                    fieldRef.methodBinding = CharOperation.equals((resolvedType = (ReferenceBinding)fieldRef.actualReceiverType).sourceName(), fieldRef.token) ? scope.getConstructor(resolvedType, Binding.NO_TYPES, fieldRef) : scope.findMethod(resolvedType, fieldRef.token, Binding.NO_TYPES, fieldRef, false);
                }
            } else if (source15 && fieldRef.binding != null && fieldRef.binding.isValidBinding() && fieldRef.tagValue == 10 && !fieldRef.binding.isStatic()) {
                if (scopeModifiers == -1) {
                    scopeModifiers = scope.getDeclarationModifiers();
                }
                scope.problemReporter().javadocInvalidValueReference(fieldRef.sourceStart, fieldRef.sourceEnd, scopeModifiers);
            }
            if (!hasProblems && fieldRef.binding != null && fieldRef.binding.isValidBinding() && fieldRef.actualReceiverType instanceof ReferenceBinding) {
                resolvedType = (ReferenceBinding)fieldRef.actualReceiverType;
                this.verifyTypeReference(fieldRef, fieldRef.receiver, scope, source15, resolvedType, fieldRef.binding.modifiers);
            }
            return;
        }
        if (!hasProblems && (reference instanceof JavadocSingleTypeReference || reference instanceof JavadocQualifiedTypeReference) && reference.resolvedType instanceof ReferenceBinding) {
            ReferenceBinding resolvedType = (ReferenceBinding)reference.resolvedType;
            this.verifyTypeReference(reference, reference, scope, source15, resolvedType, resolvedType.modifiers);
        }
        if (reference instanceof JavadocMessageSend) {
            JavadocMessageSend msgSend = (JavadocMessageSend)reference;
            if (source15 && msgSend.tagValue == 10) {
                if (scopeModifiers == -1) {
                    scopeModifiers = scope.getDeclarationModifiers();
                }
                scope.problemReporter().javadocInvalidValueReference(msgSend.sourceStart, msgSend.sourceEnd, scopeModifiers);
            }
            if (!hasProblems && msgSend.binding != null && msgSend.binding.isValidBinding() && msgSend.actualReceiverType instanceof ReferenceBinding) {
                ReferenceBinding resolvedType = (ReferenceBinding)msgSend.actualReceiverType;
                this.verifyTypeReference(msgSend, msgSend.receiver, scope, source15, resolvedType, msgSend.binding.modifiers);
            }
        } else if (reference instanceof JavadocAllocationExpression) {
            JavadocAllocationExpression alloc = (JavadocAllocationExpression)reference;
            if (source15 && alloc.tagValue == 10) {
                if (scopeModifiers == -1) {
                    scopeModifiers = scope.getDeclarationModifiers();
                }
                scope.problemReporter().javadocInvalidValueReference(alloc.sourceStart, alloc.sourceEnd, scopeModifiers);
            }
            if (!hasProblems && alloc.binding != null && alloc.binding.isValidBinding() && alloc.resolvedType instanceof ReferenceBinding) {
                ReferenceBinding resolvedType = (ReferenceBinding)alloc.resolvedType;
                this.verifyTypeReference(alloc, alloc.type, scope, source15, resolvedType, alloc.binding.modifiers);
            }
        } else if (reference instanceof JavadocSingleTypeReference && reference.resolvedType != null && reference.resolvedType.isTypeVariable()) {
            scope.problemReporter().javadocInvalidReference(reference.sourceStart, reference.sourceEnd);
        }
    }

    private void resolveParamTags(MethodScope scope, boolean reportMissing, boolean considerParamRefAsUsage) {
        block14: {
            int j;
            boolean found;
            int argumentsSize;
            int paramTagsSize;
            AbstractMethodDeclaration methodDecl;
            block13: {
                methodDecl = scope.referenceMethod();
                int n = paramTagsSize = this.paramReferences == null ? 0 : this.paramReferences.length;
                if (methodDecl == null) {
                    int i2 = 0;
                    while (i2 < paramTagsSize) {
                        JavadocSingleNameReference param = this.paramReferences[i2];
                        scope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
                        ++i2;
                    }
                    return;
                }
                int n2 = argumentsSize = methodDecl.arguments == null ? 0 : methodDecl.arguments.length;
                if (paramTagsSize != 0) break block13;
                if (!reportMissing) break block14;
                int i3 = 0;
                while (i3 < argumentsSize) {
                    Argument arg = methodDecl.arguments[i3];
                    scope.problemReporter().javadocMissingParamTag(arg.name, arg.sourceStart, arg.sourceEnd, methodDecl.binding.modifiers);
                    ++i3;
                }
                break block14;
            }
            LocalVariableBinding[] bindings = new LocalVariableBinding[paramTagsSize];
            int maxBindings = 0;
            int i4 = 0;
            while (i4 < paramTagsSize) {
                JavadocSingleNameReference param = this.paramReferences[i4];
                param.resolve(scope, true, considerParamRefAsUsage);
                if (param.binding != null && param.binding.isValidBinding()) {
                    found = false;
                    j = 0;
                    while (j < maxBindings && !found) {
                        if (bindings[j] == param.binding) {
                            scope.problemReporter().javadocDuplicatedParamTag(param.token, param.sourceStart, param.sourceEnd, methodDecl.binding.modifiers);
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        bindings[maxBindings++] = (LocalVariableBinding)param.binding;
                    }
                }
                ++i4;
            }
            if (reportMissing) {
                i4 = 0;
                while (i4 < argumentsSize) {
                    Argument arg = methodDecl.arguments[i4];
                    found = false;
                    j = 0;
                    while (j < maxBindings && !found) {
                        LocalVariableBinding binding = bindings[j];
                        if (arg.binding == binding) {
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        scope.problemReporter().javadocMissingParamTag(arg.name, arg.sourceStart, arg.sourceEnd, methodDecl.binding.modifiers);
                    }
                    ++i4;
                }
            }
        }
    }

    private void resolveTypeParameterTags(Scope scope, boolean reportMissing) {
        block24: {
            int typeParametersLength;
            int modifiers;
            TypeVariableBinding[] typeVariables;
            TypeParameter[] parameters;
            int paramTypeParamLength;
            block25: {
                paramTypeParamLength = this.paramTypeParameters == null ? 0 : this.paramTypeParameters.length;
                parameters = null;
                typeVariables = null;
                modifiers = -1;
                switch (scope.kind) {
                    case 2: {
                        AbstractMethodDeclaration methodDeclaration = ((MethodScope)scope).referenceMethod();
                        if (methodDeclaration == null) {
                            int i2 = 0;
                            while (i2 < paramTypeParamLength) {
                                JavadocSingleTypeReference param = this.paramTypeParameters[i2];
                                scope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
                                ++i2;
                            }
                            return;
                        }
                        parameters = methodDeclaration.typeParameters();
                        typeVariables = methodDeclaration.binding.typeVariables;
                        modifiers = methodDeclaration.binding.modifiers;
                        break;
                    }
                    case 3: {
                        TypeDeclaration typeDeclaration = ((ClassScope)scope).referenceContext;
                        parameters = typeDeclaration.typeParameters;
                        typeVariables = typeDeclaration.binding.typeVariables;
                        modifiers = typeDeclaration.binding.modifiers;
                    }
                }
                if (typeVariables == null || typeVariables.length == 0) {
                    int i3 = 0;
                    while (i3 < paramTypeParamLength) {
                        JavadocSingleTypeReference param = this.paramTypeParameters[i3];
                        scope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
                        ++i3;
                    }
                    return;
                }
                if (parameters == null) break block24;
                reportMissing = reportMissing && scope.compilerOptions().sourceLevel >= 0x310000L;
                typeParametersLength = parameters.length;
                if (paramTypeParamLength != 0) break block25;
                if (!reportMissing) break block24;
                int i4 = 0;
                int l = typeParametersLength;
                while (i4 < l) {
                    scope.problemReporter().javadocMissingParamTag(parameters[i4].name, parameters[i4].sourceStart, parameters[i4].sourceEnd, modifiers);
                    ++i4;
                }
                break block24;
            }
            if (typeVariables.length == typeParametersLength) {
                JavadocSingleTypeReference param;
                TypeVariableBinding[] bindings = new TypeVariableBinding[paramTypeParamLength];
                int i5 = 0;
                while (i5 < paramTypeParamLength) {
                    param = this.paramTypeParameters[i5];
                    TypeBinding paramBindind = param.internalResolveType(scope, 0);
                    if (paramBindind != null && paramBindind.isValidBinding()) {
                        if (paramBindind.isTypeVariable()) {
                            if (scope.compilerOptions().reportUnusedParameterIncludeDocCommentReference) {
                                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)paramBindind;
                                typeVariableBinding.modifiers |= 0x8000000;
                            }
                            boolean duplicate = false;
                            int j = 0;
                            while (j < i5 && !duplicate) {
                                if (TypeBinding.equalsEquals(bindings[j], param.resolvedType)) {
                                    scope.problemReporter().javadocDuplicatedParamTag(param.token, param.sourceStart, param.sourceEnd, modifiers);
                                    duplicate = true;
                                }
                                ++j;
                            }
                            if (!duplicate) {
                                bindings[i5] = (TypeVariableBinding)param.resolvedType;
                            }
                        } else {
                            scope.problemReporter().javadocUndeclaredParamTagName(param.token, param.sourceStart, param.sourceEnd, modifiers);
                        }
                    }
                    ++i5;
                }
                i5 = 0;
                while (i5 < typeParametersLength) {
                    TypeParameter parameter = parameters[i5];
                    boolean found = false;
                    int j = 0;
                    while (j < paramTypeParamLength && !found) {
                        if (TypeBinding.equalsEquals(parameter.binding, bindings[j])) {
                            found = true;
                            bindings[j] = null;
                        }
                        ++j;
                    }
                    if (!found && reportMissing) {
                        scope.problemReporter().javadocMissingParamTag(parameter.name, parameter.sourceStart, parameter.sourceEnd, modifiers);
                    }
                    ++i5;
                }
                i5 = 0;
                while (i5 < paramTypeParamLength) {
                    if (bindings[i5] != null) {
                        param = this.paramTypeParameters[i5];
                        scope.problemReporter().javadocUndeclaredParamTagName(param.token, param.sourceStart, param.sourceEnd, modifiers);
                    }
                    ++i5;
                }
            }
        }
    }

    private void resolveThrowsTags(MethodScope methScope, boolean reportMissing) {
        block24: {
            int j;
            TypeReference typeRef;
            int thrownExceptionLength;
            int boundExceptionLength;
            int throwsTagsLength;
            AbstractMethodDeclaration md;
            block23: {
                md = methScope.referenceMethod();
                int n = throwsTagsLength = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
                if (md == null) {
                    int i2 = 0;
                    while (i2 < throwsTagsLength) {
                        TypeReference typeRef2 = this.exceptionReferences[i2];
                        int start = typeRef2.sourceStart;
                        int end = typeRef2.sourceEnd;
                        if (typeRef2 instanceof JavadocQualifiedTypeReference) {
                            start = ((JavadocQualifiedTypeReference)typeRef2).tagSourceStart;
                            end = ((JavadocQualifiedTypeReference)typeRef2).tagSourceEnd;
                        } else if (typeRef2 instanceof JavadocSingleTypeReference) {
                            start = ((JavadocSingleTypeReference)typeRef2).tagSourceStart;
                            end = ((JavadocSingleTypeReference)typeRef2).tagSourceEnd;
                        }
                        methScope.problemReporter().javadocUnexpectedTag(start, end);
                        ++i2;
                    }
                    return;
                }
                boundExceptionLength = md.binding == null ? 0 : md.binding.thrownExceptions.length;
                int n2 = thrownExceptionLength = md.thrownExceptions == null ? 0 : md.thrownExceptions.length;
                if (throwsTagsLength != 0) break block23;
                if (!reportMissing) break block24;
                int i3 = 0;
                while (i3 < boundExceptionLength) {
                    ReferenceBinding exceptionBinding = md.binding.thrownExceptions[i3];
                    if (exceptionBinding != null && exceptionBinding.isValidBinding()) {
                        int j2 = i3;
                        while (j2 < thrownExceptionLength && TypeBinding.notEquals(exceptionBinding, md.thrownExceptions[j2].resolvedType)) {
                            ++j2;
                        }
                        if (j2 < thrownExceptionLength) {
                            methScope.problemReporter().javadocMissingThrowsTag(md.thrownExceptions[j2], md.binding.modifiers);
                        }
                    }
                    ++i3;
                }
                break block24;
            }
            int maxRef = 0;
            TypeReference[] typeReferences = new TypeReference[throwsTagsLength];
            int i4 = 0;
            while (i4 < throwsTagsLength) {
                typeRef = this.exceptionReferences[i4];
                typeRef.resolve(methScope);
                TypeBinding typeBinding = typeRef.resolvedType;
                if (typeBinding != null && typeBinding.isValidBinding() && typeBinding.isClass()) {
                    typeReferences[maxRef++] = typeRef;
                }
                ++i4;
            }
            i4 = 0;
            while (i4 < boundExceptionLength) {
                ReferenceBinding exceptionBinding = md.binding.thrownExceptions[i4];
                if (exceptionBinding != null) {
                    exceptionBinding = (ReferenceBinding)exceptionBinding.erasure();
                }
                boolean found = false;
                j = 0;
                while (j < maxRef && !found) {
                    TypeBinding typeBinding;
                    if (typeReferences[j] != null && TypeBinding.equalsEquals(exceptionBinding, typeBinding = typeReferences[j].resolvedType)) {
                        found = true;
                        typeReferences[j] = null;
                    }
                    ++j;
                }
                if (!found && reportMissing && exceptionBinding != null && exceptionBinding.isValidBinding()) {
                    int k = i4;
                    while (k < thrownExceptionLength && TypeBinding.notEquals(exceptionBinding, md.thrownExceptions[k].resolvedType)) {
                        ++k;
                    }
                    if (k < thrownExceptionLength) {
                        methScope.problemReporter().javadocMissingThrowsTag(md.thrownExceptions[k], md.binding.modifiers);
                    }
                }
                ++i4;
            }
            i4 = 0;
            while (i4 < maxRef) {
                typeRef = typeReferences[i4];
                if (typeRef != null) {
                    boolean compatible = false;
                    j = 0;
                    while (j < thrownExceptionLength && !compatible) {
                        TypeBinding exceptionBinding = md.thrownExceptions[j].resolvedType;
                        if (exceptionBinding != null) {
                            compatible = typeRef.resolvedType.isCompatibleWith(exceptionBinding);
                        }
                        ++j;
                    }
                    if (!compatible && !typeRef.resolvedType.isUncheckedException(false)) {
                        methScope.problemReporter().javadocInvalidThrowsClassName(typeRef, md.binding.modifiers);
                    }
                }
                ++i4;
            }
        }
    }

    private void verifyTypeReference(Expression reference, Expression typeReference, Scope scope, boolean source15, ReferenceBinding resolvedType, int modifiers) {
        if (resolvedType.isValidBinding()) {
            int scopeModifiers = -1;
            if (!this.canBeSeen(scope.problemReporter().options.reportInvalidJavadocTagsVisibility, modifiers)) {
                scope.problemReporter().javadocHiddenReference(typeReference.sourceStart, reference.sourceEnd, scope, modifiers);
                return;
            }
            if (reference != typeReference && !this.canBeSeen(scope.problemReporter().options.reportInvalidJavadocTagsVisibility, resolvedType.modifiers)) {
                scope.problemReporter().javadocHiddenReference(typeReference.sourceStart, typeReference.sourceEnd, scope, resolvedType.modifiers);
                return;
            }
            if (resolvedType.isMemberType()) {
                ReferenceBinding topLevelType = resolvedType;
                int packageLength = topLevelType.fPackage.compoundName.length;
                int depth = resolvedType.depth();
                int idx = depth + packageLength;
                char[][] computedCompoundName = new char[idx + 1][];
                computedCompoundName[idx] = topLevelType.sourceName;
                while (topLevelType.enclosingType() != null) {
                    topLevelType = topLevelType.enclosingType();
                    computedCompoundName[--idx] = topLevelType.sourceName;
                }
                int i2 = packageLength;
                while (--i2 >= 0) {
                    computedCompoundName[--idx] = topLevelType.fPackage.compoundName[i2];
                }
                ClassScope topLevelScope = scope.classScope();
                if (topLevelScope.parent.kind != 4 || !CharOperation.equals(topLevelType.sourceName, topLevelScope.referenceContext.name)) {
                    topLevelScope = topLevelScope.outerMostClassScope();
                    if (typeReference instanceof JavadocSingleTypeReference && (!source15 && depth == 1 || TypeBinding.notEquals(topLevelType, topLevelScope.referenceContext.binding))) {
                        boolean hasValidImport = false;
                        if (source15) {
                            CompilationUnitScope unitScope = topLevelScope.compilationUnitScope();
                            ImportBinding[] imports = unitScope.imports;
                            int length = imports == null ? 0 : imports.length;
                            int i3 = 0;
                            block2: while (i3 < length) {
                                char[][] compoundName = imports[i3].compoundName;
                                int compoundNameLength = compoundName.length;
                                if (imports[i3].onDemand && compoundNameLength == computedCompoundName.length - 1 || compoundNameLength == computedCompoundName.length) {
                                    int j = compoundNameLength;
                                    while (--j >= 0) {
                                        if (!CharOperation.equals(imports[i3].compoundName[j], computedCompoundName[j])) break;
                                        if (j != 0) continue;
                                        hasValidImport = true;
                                        ImportReference importReference = imports[i3].reference;
                                        if (importReference == null) break block2;
                                        importReference.bits |= 2;
                                        break block2;
                                    }
                                }
                                ++i3;
                            }
                            if (!hasValidImport) {
                                if (scopeModifiers == -1) {
                                    scopeModifiers = scope.getDeclarationModifiers();
                                }
                                scope.problemReporter().javadocInvalidMemberTypeQualification(typeReference.sourceStart, typeReference.sourceEnd, scopeModifiers);
                            }
                        } else {
                            if (scopeModifiers == -1) {
                                scopeModifiers = scope.getDeclarationModifiers();
                            }
                            scope.problemReporter().javadocInvalidMemberTypeQualification(typeReference.sourceStart, typeReference.sourceEnd, scopeModifiers);
                            return;
                        }
                    }
                }
                if (typeReference instanceof JavadocQualifiedTypeReference && !scope.isDefinedInSameUnit(resolvedType)) {
                    char[][] typeRefName = ((JavadocQualifiedTypeReference)typeReference).getTypeName();
                    int skipLength = 0;
                    if (topLevelScope.getCurrentPackage() == resolvedType.getPackage() && typeRefName.length < computedCompoundName.length) {
                        skipLength = resolvedType.fPackage.compoundName.length;
                    }
                    boolean valid = true;
                    if (typeRefName.length == computedCompoundName.length - skipLength) {
                        int i4 = 0;
                        while (i4 < typeRefName.length) {
                            if (!CharOperation.equals(typeRefName[i4], computedCompoundName[i4 + skipLength])) {
                                valid = false;
                                break;
                            }
                            ++i4;
                        }
                    } else {
                        valid = false;
                    }
                    if (!valid) {
                        if (scopeModifiers == -1) {
                            scopeModifiers = scope.getDeclarationModifiers();
                        }
                        scope.problemReporter().javadocInvalidMemberTypeQualification(typeReference.sourceStart, typeReference.sourceEnd, scopeModifiers);
                        return;
                    }
                }
            }
            if (scope.referenceCompilationUnit().isPackageInfo() && typeReference instanceof JavadocSingleTypeReference && resolvedType.fPackage.compoundName.length > 0) {
                scope.problemReporter().javadocInvalidReference(typeReference.sourceStart, typeReference.sourceEnd);
                return;
            }
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int length;
            int i2;
            if (this.paramReferences != null) {
                i2 = 0;
                length = this.paramReferences.length;
                while (i2 < length) {
                    this.paramReferences[i2].traverse(visitor, scope);
                    ++i2;
                }
            }
            if (this.paramTypeParameters != null) {
                i2 = 0;
                length = this.paramTypeParameters.length;
                while (i2 < length) {
                    this.paramTypeParameters[i2].traverse(visitor, scope);
                    ++i2;
                }
            }
            if (this.returnStatement != null) {
                this.returnStatement.traverse(visitor, scope);
            }
            if (this.exceptionReferences != null) {
                i2 = 0;
                length = this.exceptionReferences.length;
                while (i2 < length) {
                    this.exceptionReferences[i2].traverse(visitor, scope);
                    ++i2;
                }
            }
            if (this.seeReferences != null) {
                i2 = 0;
                length = this.seeReferences.length;
                while (i2 < length) {
                    this.seeReferences[i2].traverse(visitor, scope);
                    ++i2;
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
        if (visitor.visit(this, scope)) {
            int length;
            int i2;
            if (this.paramReferences != null) {
                i2 = 0;
                length = this.paramReferences.length;
                while (i2 < length) {
                    this.paramReferences[i2].traverse(visitor, scope);
                    ++i2;
                }
            }
            if (this.paramTypeParameters != null) {
                i2 = 0;
                length = this.paramTypeParameters.length;
                while (i2 < length) {
                    this.paramTypeParameters[i2].traverse(visitor, scope);
                    ++i2;
                }
            }
            if (this.returnStatement != null) {
                this.returnStatement.traverse(visitor, scope);
            }
            if (this.exceptionReferences != null) {
                i2 = 0;
                length = this.exceptionReferences.length;
                while (i2 < length) {
                    this.exceptionReferences[i2].traverse(visitor, scope);
                    ++i2;
                }
            }
            if (this.seeReferences != null) {
                i2 = 0;
                length = this.seeReferences.length;
                while (i2 < length) {
                    this.seeReferences[i2].traverse(visitor, scope);
                    ++i2;
                }
            }
        }
        visitor.endVisit(this, scope);
    }
}

