/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoverySelector;

class NestedMethodSelector
implements DiscoverySelector {
    private final List<Class<?>> enclosingClasses;
    private final Class<?> nestedClass;
    private final Method method;

    NestedMethodSelector(List<Class<?>> enclosingClasses, Class<?> nestedClass, Method method) {
        this.enclosingClasses = Preconditions.notEmpty(enclosingClasses, "enclosingClasses must not be null or empty");
        this.nestedClass = Preconditions.notNull(nestedClass, "nestedClass must not be null");
        this.method = Preconditions.notNull(method, "method must not be null");
    }

    List<Class<?>> getEnclosingClasses() {
        return this.enclosingClasses;
    }

    Class<?> getNestedClass() {
        return this.nestedClass;
    }

    Method getMethod() {
        return this.method;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedMethodSelector that = (NestedMethodSelector)o;
        return this.enclosingClasses.equals(that.enclosingClasses) && this.nestedClass.equals(that.nestedClass) && this.method.equals(that.method);
    }

    public int hashCode() {
        return Objects.hash(this.enclosingClasses, this.nestedClass, this.method);
    }
}

