/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.EnabledOnOsCondition;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;

class DisabledOnOsCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled("@DisabledOnOs is not present");

    DisabledOnOsCondition() {
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional<DisabledOnOs> optional = AnnotationUtils.findAnnotation(context.getElement(), DisabledOnOs.class);
        if (optional.isPresent()) {
            OS[] operatingSystems = optional.get().value();
            Preconditions.condition(operatingSystems.length > 0, "You must declare at least one OS in @DisabledOnOs");
            return Arrays.stream(operatingSystems).anyMatch(OS::isCurrentOs) ? EnabledOnOsCondition.DISABLED_ON_CURRENT_OS : EnabledOnOsCondition.ENABLED_ON_CURRENT_OS;
        }
        return ENABLED_BY_DEFAULT;
    }
}

