/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.lang.reflect.Constructor;
import java.util.concurrent.Executor;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.strategy.ExecuteProduceConsume;

public interface ExecutionStrategy {
    public void dispatch();

    public void produce();

    public static class DefaultExecutionStrategyFactory
    implements Factory {
        private static final Logger LOG = Log.getLogger(Factory.class);
        private static final Factory INSTANCE = new DefaultExecutionStrategyFactory();

        @Override
        public ExecutionStrategy newExecutionStrategy(Producer producer, Executor executor) {
            String strategy = System.getProperty(producer.getClass().getName() + ".ExecutionStrategy");
            if (strategy != null) {
                try {
                    Class c = Loader.loadClass(strategy);
                    Constructor m = c.getConstructor(Producer.class, Executor.class);
                    LOG.info("Use {} for {}", c.getSimpleName(), producer.getClass().getName());
                    return (ExecutionStrategy)m.newInstance(producer, executor);
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
            return new ExecuteProduceConsume(producer, executor);
        }
    }

    public static interface Factory {
        public ExecutionStrategy newExecutionStrategy(Producer var1, Executor var2);

        public static Factory getDefault() {
            return DefaultExecutionStrategyFactory.INSTANCE;
        }
    }

    public static interface Producer {
        public Runnable produce();
    }
}

