/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler.gzip;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.annotation.Name;

public class GzipRequestCustomizer
implements HttpConfiguration.Customizer {
    public static final String GZIP = "gzip";
    private static final HttpField X_CE_GZIP = new HttpField("X-Content-Encoding", "gzip");
    private static final Pattern COMMA_GZIP = Pattern.compile(".*, *gzip");
    private final int _compressedBufferSize;
    private final int _inflatedBufferSize;

    public GzipRequestCustomizer() {
        this(-1, -1);
    }

    public GzipRequestCustomizer(@Name(value="compressedBufferSize") int compressedBufferSize, @Name(value="inflatedBufferSize") int inflatedBufferSize) {
        this._compressedBufferSize = compressedBufferSize <= 0 ? 4096 : compressedBufferSize;
        this._inflatedBufferSize = inflatedBufferSize <= 0 ? 16384 : inflatedBufferSize;
    }

    @Override
    public void customize(Connector connector, HttpConfiguration channelConfig, Request request) {
        ByteBufferPool bufferPool = request.getHttpChannel().getByteBufferPool();
        try {
            HttpFields fields = request.getHttpFields();
            String content_encoding = fields.get(HttpHeader.CONTENT_ENCODING);
            if (content_encoding == null) {
                return;
            }
            if (content_encoding.equalsIgnoreCase(GZIP)) {
                fields.remove(HttpHeader.CONTENT_ENCODING);
            } else if (COMMA_GZIP.matcher(content_encoding).matches()) {
                fields.remove(HttpHeader.CONTENT_ENCODING);
                fields.add(HttpHeader.CONTENT_ENCODING, content_encoding.substring(0, content_encoding.lastIndexOf(44)));
            } else {
                return;
            }
            fields.add(X_CE_GZIP);
            HttpInput input = request.getHttpInput();
            ArrayQueue<ByteBuffer> compressed = new ArrayQueue<ByteBuffer>();
            ByteBuffer buffer = null;
            while (true) {
                int l;
                if (buffer == null || BufferUtil.isFull(buffer)) {
                    buffer = bufferPool.acquire(this._compressedBufferSize, false);
                    compressed.add(buffer);
                }
                if ((l = input.read(buffer.array(), buffer.arrayOffset() + buffer.limit(), BufferUtil.space(buffer))) < 0) break;
                buffer.limit(buffer.limit() + l);
            }
            input.recycle();
            if (compressed.size() == 1 && BufferUtil.isEmpty(buffer)) {
                input.eof();
                return;
            }
            input.addContent(new InflatingContent(bufferPool, input, compressed));
        }
        catch (Throwable t) {
            throw new BadMessageException(400, "Bad compressed request", t);
        }
    }

    private class InflatingContent
    extends HttpInput.Content {
        final ByteBufferPool _bufferPool;
        final HttpInput _input;
        final Queue<ByteBuffer> _compressed;
        private final Inflater _inflater;
        private State _state;
        private int _size;
        private int _value;
        private byte _flags;

        public InflatingContent(ByteBufferPool bufferPool, HttpInput input, Queue<ByteBuffer> compressed) {
            super(bufferPool.acquire(GzipRequestCustomizer.this._inflatedBufferSize, false));
            this._inflater = new Inflater(true);
            this._state = State.INITIAL;
            this._bufferPool = bufferPool;
            this._input = input;
            this._compressed = compressed;
            this.inflate();
        }

        @Override
        public void succeeded() {
            BufferUtil.clear(this.getContent());
            this.inflate();
            if (BufferUtil.isEmpty(this.getContent()) && this._state == State.END) {
                this._bufferPool.release(this.getContent());
                this._input.eof();
            } else {
                this._input.addContent(this);
            }
        }

        @Override
        public void failed(Throwable x) {
            this._input.failed(x);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void inflate() {
            try {
                block24: while (true) {
                    block38: {
                        switch (this._state) {
                            case INITIAL: {
                                this._state = State.ID;
                                break;
                            }
                            case FLAGS: {
                                if ((this._flags & 4) == 4) {
                                    this._state = State.EXTRA_LENGTH;
                                    this._size = 0;
                                    this._value = 0;
                                    break;
                                }
                                if ((this._flags & 8) == 8) {
                                    this._state = State.NAME;
                                    break;
                                }
                                if ((this._flags & 0x10) == 16) {
                                    this._state = State.COMMENT;
                                    break;
                                }
                                if ((this._flags & 2) == 2) {
                                    this._state = State.HCRC;
                                    this._size = 0;
                                    this._value = 0;
                                    break;
                                }
                                this._state = State.DATA;
                                continue block24;
                            }
                            case DATA: {
                                break block38;
                            }
                        }
                        ByteBuffer data = this._compressed.peek();
                        if (BufferUtil.isEmpty(data)) {
                            return;
                        }
                        byte currByte = data.get();
                        switch (this._state) {
                            case ID: {
                                this._value += (currByte & 0xFF) << 8 * this._size;
                                ++this._size;
                                if (this._size != 2) continue block24;
                                if (this._value != 35615) {
                                    throw new ZipException("Invalid gzip bytes");
                                }
                                this._state = State.CM;
                                continue block24;
                            }
                            case CM: {
                                if ((currByte & 0xFF) != 8) {
                                    throw new ZipException("Invalid gzip compression method");
                                }
                                this._state = State.FLG;
                                continue block24;
                            }
                            case FLG: {
                                this._flags = currByte;
                                this._state = State.MTIME;
                                this._size = 0;
                                this._value = 0;
                                continue block24;
                            }
                            case MTIME: {
                                ++this._size;
                                if (this._size != 4) continue block24;
                                this._state = State.XFL;
                                continue block24;
                            }
                            case XFL: {
                                this._state = State.OS;
                                continue block24;
                            }
                            case OS: {
                                this._state = State.FLAGS;
                                continue block24;
                            }
                            case EXTRA_LENGTH: {
                                this._value += (currByte & 0xFF) << 8 * this._size;
                                ++this._size;
                                if (this._size != 2) continue block24;
                                this._state = State.EXTRA;
                                continue block24;
                            }
                            case EXTRA: {
                                --this._value;
                                if (this._value != 0) continue block24;
                                this._flags = (byte)(this._flags & 0xFFFFFFFB);
                                this._state = State.FLAGS;
                                continue block24;
                            }
                            case NAME: {
                                if (currByte != 0) continue block24;
                                this._flags = (byte)(this._flags & 0xFFFFFFF7);
                                this._state = State.FLAGS;
                                continue block24;
                            }
                            case COMMENT: {
                                if (currByte != 0) continue block24;
                                this._flags = (byte)(this._flags & 0xFFFFFFEF);
                                this._state = State.FLAGS;
                                continue block24;
                            }
                            case HCRC: {
                                ++this._size;
                                if (this._size != 2) continue block24;
                                this._flags = (byte)(this._flags & 0xFFFFFFFD);
                                this._state = State.FLAGS;
                                continue block24;
                            }
                            case CRC: {
                                this._value += (currByte & 0xFF) << 8 * this._size;
                                ++this._size;
                                if (this._size != 4) continue block24;
                                this._state = State.ISIZE;
                                this._size = 0;
                                this._value = 0;
                                continue block24;
                            }
                            case ISIZE: {
                                this._value += (currByte & 0xFF) << 8 * this._size;
                                ++this._size;
                                if (this._size != 4) continue block24;
                                if ((long)this._value != this._inflater.getBytesWritten()) {
                                    throw new ZipException("Invalid input size");
                                }
                                this._inflater.reset();
                                this._state = State.END;
                                return;
                            }
                        }
                        throw new ZipException();
                    }
                    while (true) {
                        ByteBuffer buffer;
                        if (BufferUtil.isFull(buffer = this.getContent())) {
                            return;
                        }
                        try {
                            int length = this._inflater.inflate(buffer.array(), buffer.arrayOffset() + buffer.position(), BufferUtil.space(buffer));
                            buffer.limit(buffer.limit() + length);
                        }
                        catch (DataFormatException x) {
                            throw new ZipException(x.getMessage());
                        }
                        if (this._inflater.needsInput()) {
                            ByteBuffer data = this._compressed.peek();
                            while (data != null && BufferUtil.isEmpty(data)) {
                                this._bufferPool.release(this._compressed.poll());
                                data = this._compressed.peek();
                            }
                            if (data == null) {
                                return;
                            }
                            this._inflater.setInput(data.array(), data.arrayOffset() + data.position(), data.remaining());
                            data.position(data.limit());
                            continue;
                        }
                        if (this._inflater.finished()) break;
                    }
                    ByteBuffer data = this._compressed.peek();
                    int remaining = this._inflater.getRemaining();
                    data.position(data.limit() - remaining);
                    this._state = State.CRC;
                    this._size = 0;
                    this._value = 0;
                }
            }
            catch (ZipException x) {
                throw new RuntimeException(x);
            }
        }
    }

    private static enum State {
        INITIAL,
        ID,
        CM,
        FLG,
        MTIME,
        XFL,
        OS,
        FLAGS,
        EXTRA_LENGTH,
        EXTRA,
        NAME,
        COMMENT,
        HCRC,
        DATA,
        CRC,
        ISIZE,
        END;

    }
}

