/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.ArrayList;
import java.util.List;

public class AnnotationIntrospector {
    protected List<IntrospectableAnnotationHandler> _handlers = new ArrayList<IntrospectableAnnotationHandler>();

    public void registerHandler(IntrospectableAnnotationHandler handler) {
        this._handlers.add(handler);
    }

    public void introspect(Class<?> clazz) {
        if (this._handlers == null) {
            return;
        }
        if (clazz == null) {
            return;
        }
        for (IntrospectableAnnotationHandler handler : this._handlers) {
            try {
                handler.handle(clazz);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static abstract class AbstractIntrospectableAnnotationHandler
    implements IntrospectableAnnotationHandler {
        private boolean _introspectAncestors;

        public abstract void doHandle(Class<?> var1);

        public AbstractIntrospectableAnnotationHandler(boolean introspectAncestors) {
            this._introspectAncestors = introspectAncestors;
        }

        @Override
        public void handle(Class<?> clazz) {
            for (Class<?> c = clazz; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
                this.doHandle(c);
                if (!this._introspectAncestors) break;
            }
        }
    }

    public static interface IntrospectableAnnotationHandler {
        public void handle(Class<?> var1);
    }
}

