/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import org.eclipse.jetty.annotations.AbstractDiscoverableAnnotationHandler;
import org.eclipse.jetty.annotations.AnnotationDecorator;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassInheritanceHandler;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.annotations.ContainerInitializerAnnotationHandler;
import org.eclipse.jetty.annotations.ServletContainerInitializersStarter;
import org.eclipse.jetty.annotations.WebFilterAnnotationHandler;
import org.eclipse.jetty.annotations.WebListenerAnnotationHandler;
import org.eclipse.jetty.annotations.WebServletAnnotationHandler;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.FragmentDescriptor;
import org.eclipse.jetty.webapp.MetaDataComplete;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebDescriptor;

public class AnnotationConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(AnnotationConfiguration.class);
    public static final String SERVLET_CONTAINER_INITIALIZER_EXCLUSION_PATTERN = "org.eclipse.jetty.containerInitializerExclusionPattern";
    public static final String SERVLET_CONTAINER_INITIALIZER_ORDER = "org.eclipse.jetty.containerInitializerOrder";
    public static final String CLASS_INHERITANCE_MAP = "org.eclipse.jetty.classInheritanceMap";
    public static final String CONTAINER_INITIALIZERS = "org.eclipse.jetty.containerInitializers";
    public static final String CONTAINER_INITIALIZER_STARTER = "org.eclipse.jetty.containerInitializerStarter";
    public static final String MULTI_THREADED = "org.eclipse.jetty.annotations.multiThreaded";
    public static final String MAX_SCAN_WAIT = "org.eclipse.jetty.annotations.maxWait";
    public static final int DEFAULT_MAX_SCAN_WAIT = 60;
    public static final boolean DEFAULT_MULTI_THREADED = true;
    protected List<AbstractDiscoverableAnnotationHandler> _discoverableAnnotationHandlers = new ArrayList<AbstractDiscoverableAnnotationHandler>();
    protected ClassInheritanceHandler _classInheritanceHandler;
    protected List<ContainerInitializerAnnotationHandler> _containerInitializerAnnotationHandlers = new ArrayList<ContainerInitializerAnnotationHandler>();
    protected List<ParserTask> _parserTasks;
    protected WebAppClassNameResolver _webAppClassNameResolver;
    protected ContainerClassNameResolver _containerClassNameResolver;
    protected CounterStatistic _containerPathStats;
    protected CounterStatistic _webInfLibStats;
    protected CounterStatistic _webInfClassesStats;
    protected Pattern _sciExcludePattern;

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        this._webAppClassNameResolver = new WebAppClassNameResolver(context);
        this._containerClassNameResolver = new ContainerClassNameResolver(context);
        String tmp = (String)context.getAttribute(SERVLET_CONTAINER_INITIALIZER_EXCLUSION_PATTERN);
        this._sciExcludePattern = tmp == null ? null : Pattern.compile(tmp);
    }

    public void addDiscoverableAnnotationHandler(AbstractDiscoverableAnnotationHandler handler) {
        this._discoverableAnnotationHandlers.add(handler);
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        context.removeAttribute(CLASS_INHERITANCE_MAP);
        context.removeAttribute(CONTAINER_INITIALIZERS);
        ServletContainerInitializersStarter starter = (ServletContainerInitializersStarter)context.getAttribute(CONTAINER_INITIALIZER_STARTER);
        if (starter != null) {
            context.removeBean(starter);
            context.removeAttribute(CONTAINER_INITIALIZER_STARTER);
        }
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        List initializers;
        context.getObjectFactory().addDecorator(new AnnotationDecorator(context));
        if (!context.getMetaData().isMetaDataComplete() && (context.getServletContext().getEffectiveMajorVersion() >= 3 || context.isConfigurationDiscovered())) {
            this._discoverableAnnotationHandlers.add(new WebServletAnnotationHandler(context));
            this._discoverableAnnotationHandlers.add(new WebFilterAnnotationHandler(context));
            this._discoverableAnnotationHandlers.add(new WebListenerAnnotationHandler(context));
        }
        this.createServletContainerInitializerAnnotationHandlers(context, this.getNonExcludedInitializers(context));
        if (!this._discoverableAnnotationHandlers.isEmpty() || this._classInheritanceHandler != null || !this._containerInitializerAnnotationHandlers.isEmpty()) {
            this.scanForAnnotations(context);
        }
        if ((initializers = (List)context.getAttribute(CONTAINER_INITIALIZERS)) != null && initializers.size() > 0) {
            Map map = (Map)context.getAttribute(CLASS_INHERITANCE_MAP);
            if (map == null) {
                LOG.warn("ServletContainerInitializers: detected. Class hierarchy: empty", new Object[0]);
            }
            for (ContainerInitializer i : initializers) {
                i.resolveClasses(context, map);
            }
        }
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        ClassInheritanceMap classMap = (ClassInheritanceMap)context.getAttribute(CLASS_INHERITANCE_MAP);
        List initializers = (List)context.getAttribute(CONTAINER_INITIALIZERS);
        context.removeAttribute(CLASS_INHERITANCE_MAP);
        if (classMap != null) {
            classMap.clear();
        }
        context.removeAttribute(CONTAINER_INITIALIZERS);
        if (initializers != null) {
            initializers.clear();
        }
        if (this._discoverableAnnotationHandlers != null) {
            this._discoverableAnnotationHandlers.clear();
        }
        this._classInheritanceHandler = null;
        if (this._containerInitializerAnnotationHandlers != null) {
            this._containerInitializerAnnotationHandlers.clear();
        }
        if (this._parserTasks != null) {
            this._parserTasks.clear();
            this._parserTasks = null;
        }
        super.postConfigure(context);
    }

    protected void scanForAnnotations(WebAppContext context) throws Exception {
        boolean timeout;
        AnnotationParser parser = this.createAnnotationParser();
        this._parserTasks = new ArrayList<ParserTask>();
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Annotation scanning commencing: webxml={}, metadatacomplete={}, configurationDiscovered={}, multiThreaded={}, maxScanWait={}", context.getServletContext().getEffectiveMajorVersion(), context.getMetaData().isMetaDataComplete(), context.isConfigurationDiscovered(), this.isUseMultiThreading(context), this.getMaxScanWait(context));
        }
        this.parseContainerPath(context, parser);
        this.parseWebInfClasses(context, parser);
        this.parseWebInfLib(context, parser);
        start = System.nanoTime();
        final Semaphore task_limit = this.isUseMultiThreading(context) ? new Semaphore(Runtime.getRuntime().availableProcessors()) : new Semaphore(1);
        final CountDownLatch latch = new CountDownLatch(this._parserTasks.size());
        final MultiException me = new MultiException();
        for (final ParserTask p : this._parserTasks) {
            task_limit.acquire();
            context.getServer().getThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        p.call();
                    }
                    catch (Exception e) {
                        me.add(e);
                    }
                    finally {
                        task_limit.release();
                        latch.countDown();
                    }
                }
            });
        }
        boolean bl = timeout = !latch.await(this.getMaxScanWait(context), TimeUnit.SECONDS);
        if (LOG.isDebugEnabled()) {
            for (ParserTask p : this._parserTasks) {
                LOG.debug("Scanned {} in {}ms", p.getResource(), TimeUnit.MILLISECONDS.convert(p.getStatistic().getElapsed(), TimeUnit.NANOSECONDS));
            }
            LOG.debug("Scanned {} container path jars, {} WEB-INF/lib jars, {} WEB-INF/classes dirs in {}ms for context {}", this._containerPathStats.getTotal(), this._webInfLibStats.getTotal(), this._webInfClassesStats.getTotal(), TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS), context);
        }
        if (timeout) {
            me.add(new Exception("Timeout scanning annotations"));
        }
        me.ifExceptionThrow();
    }

    protected AnnotationParser createAnnotationParser() {
        return new AnnotationParser();
    }

    protected boolean isUseMultiThreading(WebAppContext context) {
        Object o = context.getAttribute(MULTI_THREADED);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        o = context.getServer().getAttribute(MULTI_THREADED);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.valueOf(System.getProperty(MULTI_THREADED, Boolean.toString(true)));
    }

    protected int getMaxScanWait(WebAppContext context) {
        Object o = context.getAttribute(MAX_SCAN_WAIT);
        if (o != null && o instanceof Number) {
            return ((Number)o).intValue();
        }
        o = context.getServer().getAttribute(MAX_SCAN_WAIT);
        if (o != null && o instanceof Number) {
            return ((Number)o).intValue();
        }
        return Integer.getInteger(MAX_SCAN_WAIT, 60);
    }

    @Override
    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        context.getObjectFactory().addDecorator(new AnnotationDecorator(context));
    }

    public void createServletContainerInitializerAnnotationHandlers(WebAppContext context, List<ServletContainerInitializer> scis) throws Exception {
        if (scis == null || scis.isEmpty()) {
            return;
        }
        ArrayList<ContainerInitializer> initializers = new ArrayList<ContainerInitializer>();
        context.setAttribute(CONTAINER_INITIALIZERS, initializers);
        for (ServletContainerInitializer service : scis) {
            HandlesTypes annotation = service.getClass().getAnnotation(HandlesTypes.class);
            ContainerInitializer initializer = null;
            if (annotation != null) {
                Class<?>[] classes = annotation.value();
                if (classes != null) {
                    initializer = new ContainerInitializer(service, classes);
                    if (context.getAttribute(CLASS_INHERITANCE_MAP) == null) {
                        ClassInheritanceMap map = new ClassInheritanceMap();
                        context.setAttribute(CLASS_INHERITANCE_MAP, map);
                        this._classInheritanceHandler = new ClassInheritanceHandler(map);
                    }
                    for (Class<?> c : classes) {
                        if (!c.isAnnotation()) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Registering annotation handler for " + c.getName(), new Object[0]);
                        }
                        this._containerInitializerAnnotationHandlers.add(new ContainerInitializerAnnotationHandler(initializer, c));
                    }
                } else {
                    initializer = new ContainerInitializer(service, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No classes in HandlesTypes on initializer " + service.getClass(), new Object[0]);
                    }
                }
            } else {
                initializer = new ContainerInitializer(service, null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No annotation on initializer " + service.getClass(), new Object[0]);
                }
            }
            initializers.add(initializer);
        }
        ServletContainerInitializersStarter starter = (ServletContainerInitializersStarter)context.getAttribute(CONTAINER_INITIALIZER_STARTER);
        if (starter != null) {
            throw new IllegalStateException("ServletContainerInitializersStarter already exists");
        }
        starter = new ServletContainerInitializersStarter(context);
        context.setAttribute(CONTAINER_INITIALIZER_STARTER, starter);
        context.addBean((Object)starter, true);
    }

    public Resource getJarFor(ServletContainerInitializer service) throws MalformedURLException, IOException {
        String loadingJarName;
        int i;
        URL jarURL = Thread.currentThread().getContextClassLoader().getResource(service.getClass().getName().replace('.', '/') + ".class");
        if (jarURL == null) {
            jarURL = service.getClass().getClassLoader().getResource(service.getClass().getName().replace('.', '/') + ".class");
        }
        if ((i = (loadingJarName = jarURL.toString()).indexOf(".jar")) < 0) {
            return null;
        }
        loadingJarName = (loadingJarName = loadingJarName.substring(0, i + 4)).startsWith("jar:") ? loadingJarName.substring(4) : loadingJarName;
        return Resource.newResource(loadingJarName);
    }

    public boolean isFromExcludedJar(WebAppContext context, ServletContainerInitializer sci, Resource sciResource) throws Exception {
        if (sci == null) {
            throw new IllegalArgumentException("ServletContainerInitializer null");
        }
        if (context == null) {
            throw new IllegalArgumentException("WebAppContext null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking {} for jar exclusion", sci);
        }
        if (this.isFromContainerClassPath(context, sci)) {
            return false;
        }
        if (context.getMetaData().getOrdering() == null) {
            return false;
        }
        List<Resource> orderedJars = context.getMetaData().getOrderedWebInfJars();
        if (orderedJars.isEmpty()) {
            return true;
        }
        if (sciResource == null) {
            return false;
        }
        URI loadingJarURI = sciResource.getURI();
        boolean found = false;
        Iterator<Resource> itor = orderedJars.iterator();
        while (!found && itor.hasNext()) {
            Resource r = itor.next();
            found = r.getURI().equals(loadingJarURI);
        }
        return !found;
    }

    public boolean matchesExclusionPattern(ServletContainerInitializer sci) {
        if (this._sciExcludePattern == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking {} against containerInitializerExclusionPattern", sci.getClass().getName());
        }
        return this._sciExcludePattern.matcher(sci.getClass().getName()).matches();
    }

    public boolean isFromContainerClassPath(WebAppContext context, ServletContainerInitializer sci) {
        if (sci == null) {
            return false;
        }
        return sci.getClass().getClassLoader() == context.getClassLoader().getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServletContainerInitializer> getNonExcludedInitializers(WebAppContext context) throws Exception {
        ArrayList<ServletContainerInitializer> nonExcludedInitializers = new ArrayList<ServletContainerInitializer>();
        long start = 0L;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        ServiceLoader<ServletContainerInitializer> loadedInitializers = null;
        try {
            if (LOG.isDebugEnabled()) {
                start = System.nanoTime();
            }
            Thread.currentThread().setContextClassLoader(context.getClassLoader());
            loadedInitializers = ServiceLoader.load(ServletContainerInitializer.class);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Service loaders found in {}ms", TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        }
        HashMap<ServletContainerInitializer, Resource> sciResourceMap = new HashMap<ServletContainerInitializer, Resource>();
        ServletContainerInitializerOrdering initializerOrdering = this.getInitializerOrdering(context);
        for (ServletContainerInitializer servletContainerInitializer : loadedInitializers) {
            if (this.matchesExclusionPattern(servletContainerInitializer)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} excluded by pattern", servletContainerInitializer);
                continue;
            }
            Resource sciResource = this.getJarFor(servletContainerInitializer);
            if (this.isFromExcludedJar(context, servletContainerInitializer, sciResource)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} is from excluded jar", servletContainerInitializer);
                continue;
            }
            String string = servletContainerInitializer.getClass().getName();
            if (initializerOrdering != null && !initializerOrdering.hasWildcard() && initializerOrdering.getIndexOf(string) < 0) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} is excluded by ordering", servletContainerInitializer);
                continue;
            }
            sciResourceMap.put(servletContainerInitializer, sciResource);
        }
        if (initializerOrdering != null && !initializerOrdering.isDefaultOrder()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ordering ServletContainerInitializers with " + initializerOrdering, new Object[0]);
            }
            nonExcludedInitializers.addAll(sciResourceMap.keySet());
            Collections.sort(nonExcludedInitializers, new ServletContainerInitializerComparator(initializerOrdering));
        } else if (context.getMetaData().getOrdering() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No web.xml ordering, ServletContainerInitializers in random order", new Object[0]);
            }
            nonExcludedInitializers.addAll(sciResourceMap.keySet());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ordering ServletContainerInitializers with ordering {}", context.getMetaData().getOrdering());
            }
            for (Map.Entry entry : sciResourceMap.entrySet()) {
                if (((ServletContainerInitializer)entry.getKey()).getClass().getClassLoader() == context.getClassLoader().getParent()) {
                    nonExcludedInitializers.add((ServletContainerInitializer)entry.getKey());
                    continue;
                }
                if (entry.getValue() != null) continue;
                nonExcludedInitializers.add((ServletContainerInitializer)entry.getKey());
            }
            for (Resource resource : context.getMetaData().getOrderedWebInfJars()) {
                for (Map.Entry entry : sciResourceMap.entrySet()) {
                    if (!resource.equals(entry.getValue())) continue;
                    nonExcludedInitializers.add((ServletContainerInitializer)entry.getKey());
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            int i = 0;
            for (ServletContainerInitializer sci : nonExcludedInitializers) {
                LOG.debug("ServletContainerInitializer: {} {}", ++i, sci.getClass().getName());
            }
        }
        return nonExcludedInitializers;
    }

    public ServletContainerInitializerOrdering getInitializerOrdering(WebAppContext context) {
        if (context == null) {
            return null;
        }
        String tmp = (String)context.getAttribute(SERVLET_CONTAINER_INITIALIZER_ORDER);
        if (tmp == null || "".equals(tmp.trim())) {
            return null;
        }
        return new ServletContainerInitializerOrdering(tmp);
    }

    public void parseContainerPath(WebAppContext context, AnnotationParser parser) throws Exception {
        HashSet<AnnotationParser.AbstractHandler> handlers = new HashSet<AnnotationParser.AbstractHandler>();
        handlers.addAll(this._discoverableAnnotationHandlers);
        handlers.addAll(this._containerInitializerAnnotationHandlers);
        if (this._classInheritanceHandler != null) {
            handlers.add(this._classInheritanceHandler);
        }
        this._containerPathStats = new CounterStatistic();
        for (Resource r : context.getMetaData().getContainerResources()) {
            if (this._parserTasks == null) continue;
            ParserTask task = new ParserTask(parser, handlers, r, this._containerClassNameResolver);
            this._parserTasks.add(task);
            this._containerPathStats.increment();
            if (!LOG.isDebugEnabled()) continue;
            task.setStatistic(new TimeStatistic());
        }
    }

    public void parseWebInfLib(WebAppContext context, AnnotationParser parser) throws Exception {
        List<FragmentDescriptor> frags = context.getMetaData().getFragments();
        ArrayList webInfUris = new ArrayList();
        List<Resource> jars = null;
        jars = context.getMetaData().getOrdering() != null ? context.getMetaData().getOrderedWebInfJars() : context.getMetaData().getWebInfJars();
        this._webInfLibStats = new CounterStatistic();
        for (Resource r : jars) {
            HashSet<AnnotationParser.AbstractHandler> handlers = new HashSet<AnnotationParser.AbstractHandler>();
            FragmentDescriptor f = this.getFragmentFromJar(r, frags);
            if (f != null && this.isMetaDataComplete(f) && this._classInheritanceHandler == null && this._containerInitializerAnnotationHandlers.isEmpty()) continue;
            if (this._classInheritanceHandler != null) {
                handlers.add(this._classInheritanceHandler);
            }
            handlers.addAll(this._containerInitializerAnnotationHandlers);
            if (f == null || !this.isMetaDataComplete(f)) {
                handlers.addAll(this._discoverableAnnotationHandlers);
            }
            if (this._parserTasks == null) continue;
            ParserTask task = new ParserTask(parser, handlers, r, this._webAppClassNameResolver);
            this._parserTasks.add(task);
            this._webInfLibStats.increment();
            if (!LOG.isDebugEnabled()) continue;
            task.setStatistic(new TimeStatistic());
        }
    }

    public void parseWebInfClasses(WebAppContext context, AnnotationParser parser) throws Exception {
        HashSet<AnnotationParser.AbstractHandler> handlers = new HashSet<AnnotationParser.AbstractHandler>();
        handlers.addAll(this._discoverableAnnotationHandlers);
        if (this._classInheritanceHandler != null) {
            handlers.add(this._classInheritanceHandler);
        }
        handlers.addAll(this._containerInitializerAnnotationHandlers);
        this._webInfClassesStats = new CounterStatistic();
        for (Resource dir : context.getMetaData().getWebInfClassesDirs()) {
            if (this._parserTasks == null) continue;
            ParserTask task = new ParserTask(parser, handlers, dir, this._webAppClassNameResolver);
            this._parserTasks.add(task);
            this._webInfClassesStats.increment();
            if (!LOG.isDebugEnabled()) continue;
            task.setStatistic(new TimeStatistic());
        }
    }

    public FragmentDescriptor getFragmentFromJar(Resource jar, List<FragmentDescriptor> frags) throws Exception {
        FragmentDescriptor d = null;
        for (FragmentDescriptor frag : frags) {
            Resource fragResource = frag.getResource();
            if (!Resource.isContainedIn(fragResource, jar)) continue;
            d = frag;
            break;
        }
        return d;
    }

    public boolean isMetaDataComplete(WebDescriptor d) {
        return d != null && d.getMetaDataComplete() == MetaDataComplete.True;
    }

    public static class ClassInheritanceMap
    extends ConcurrentHashMap<String, ConcurrentHashSet<String>> {
        @Override
        public String toString() {
            return String.format("ClassInheritanceMap@%x{size=%d}", this.hashCode(), this.size());
        }
    }

    public class ServletContainerInitializerComparator
    implements Comparator<ServletContainerInitializer> {
        private ServletContainerInitializerOrdering _ordering;

        public ServletContainerInitializerComparator(ServletContainerInitializerOrdering ordering) {
            this._ordering = ordering;
        }

        @Override
        public int compare(ServletContainerInitializer sci1, ServletContainerInitializer sci2) {
            int i2;
            String c2;
            String c1 = sci1 != null ? sci1.getClass().getName() : null;
            String string = c2 = sci2 != null ? sci2.getClass().getName() : null;
            if (c1 == null && c2 == null) {
                return 0;
            }
            int i1 = this._ordering.getIndexOf(c1);
            if (i1 < 0 && this._ordering.hasWildcard()) {
                i1 = this._ordering.getWildcardIndex();
            }
            if ((i2 = this._ordering.getIndexOf(c2)) < 0 && this._ordering.hasWildcard()) {
                i2 = this._ordering.getWildcardIndex();
            }
            return Integer.compare(i1, i2);
        }
    }

    public class ServletContainerInitializerOrdering {
        private Map<String, Integer> _indexMap = new HashMap<String, Integer>();
        private Integer _star = null;
        private String _ordering = null;

        public ServletContainerInitializerOrdering(String ordering) {
            if (ordering != null) {
                this._ordering = ordering;
                String[] tmp = ordering.split(",");
                for (int i = 0; i < tmp.length; ++i) {
                    String s = tmp[i].trim();
                    this._indexMap.put(s, i);
                    if (!"*".equals(s)) continue;
                    if (this._star != null) {
                        throw new IllegalArgumentException("Duplicate wildcards in ServletContainerInitializer ordering " + ordering);
                    }
                    this._star = i;
                }
            }
        }

        public boolean hasWildcard() {
            return this._star != null;
        }

        public int getWildcardIndex() {
            if (!this.hasWildcard()) {
                return -1;
            }
            return this._star;
        }

        public boolean isDefaultOrder() {
            return this.getSize() == 1 && this.hasWildcard();
        }

        public int getIndexOf(String name) {
            Integer i = this._indexMap.get(name);
            if (i == null) {
                return -1;
            }
            return i;
        }

        public int getSize() {
            return this._indexMap.size();
        }

        public String toString() {
            if (this._ordering == null) {
                return "";
            }
            return this._ordering;
        }
    }

    public class ContainerClassNameResolver
    implements ClassNameResolver {
        private WebAppContext _context;

        public ContainerClassNameResolver(WebAppContext context) {
            this._context = context;
        }

        @Override
        public boolean isExcluded(String name) {
            if (this._context.isSystemClass(name)) {
                return false;
            }
            return this._context.isServerClass(name);
        }

        @Override
        public boolean shouldOverride(String name) {
            return this._context.isParentLoaderPriority();
        }
    }

    public class WebAppClassNameResolver
    implements ClassNameResolver {
        private WebAppContext _context;

        public WebAppClassNameResolver(WebAppContext context) {
            this._context = context;
        }

        @Override
        public boolean isExcluded(String name) {
            if (this._context.isSystemClass(name)) {
                return true;
            }
            if (this._context.isServerClass(name)) {
                return false;
            }
            return false;
        }

        @Override
        public boolean shouldOverride(String name) {
            return !this._context.isParentLoaderPriority();
        }
    }

    public class ParserTask
    implements Callable<Void> {
        protected Exception _exception;
        protected final AnnotationParser _parser;
        protected final Set<? extends AnnotationParser.Handler> _handlers;
        protected final ClassNameResolver _resolver;
        protected final Resource _resource;
        protected TimeStatistic _stat;

        public ParserTask(AnnotationParser parser, Set<? extends AnnotationParser.Handler> handlers, Resource resource, ClassNameResolver resolver) {
            this._parser = parser;
            this._handlers = handlers;
            this._resolver = resolver;
            this._resource = resource;
        }

        public void setStatistic(TimeStatistic stat) {
            this._stat = stat;
        }

        @Override
        public Void call() throws Exception {
            if (this._stat != null) {
                this._stat.start();
            }
            if (this._parser != null) {
                this._parser.parse(this._handlers, this._resource, this._resolver);
            }
            if (this._stat != null) {
                this._stat.end();
            }
            return null;
        }

        public TimeStatistic getStatistic() {
            return this._stat;
        }

        public Resource getResource() {
            return this._resource;
        }
    }

    public class TimeStatistic {
        public long _start = 0L;
        public long _end = 0L;

        public void start() {
            this._start = System.nanoTime();
        }

        public void end() {
            this._end = System.nanoTime();
        }

        public long getStart() {
            return this._start;
        }

        public long getEnd() {
            return this._end;
        }

        public long getElapsed() {
            return this._end > this._start ? this._end - this._start : 0L;
        }
    }
}

