/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;

public abstract class NegotiatingServerConnectionFactory
extends AbstractConnectionFactory {
    private final List<String> protocols = new ArrayList<String>();
    private String defaultProtocol;

    public static void checkProtocolNegotiationAvailable() {
        if (!NegotiatingServerConnectionFactory.isAvailableInBootClassPath("org.eclipse.jetty.alpn.ALPN") && !NegotiatingServerConnectionFactory.isAvailableInBootClassPath("org.eclipse.jetty.npn.NextProtoNego")) {
            throw new IllegalStateException("No ALPN nor NPN classes available");
        }
    }

    private static boolean isAvailableInBootClassPath(String className) {
        try {
            Class<?> klass = ClassLoader.getSystemClassLoader().loadClass(className);
            if (klass.getClassLoader() != null) {
                throw new IllegalStateException(className + " must be on JVM boot classpath");
            }
            return true;
        }
        catch (ClassNotFoundException x) {
            return false;
        }
    }

    public NegotiatingServerConnectionFactory(String protocol, String ... protocols) {
        super(protocol);
        if (protocols != null) {
            for (String p : protocols) {
                if ((p = p.trim()).isEmpty()) continue;
                this.protocols.add(p.trim());
            }
        }
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public void setDefaultProtocol(String defaultProtocol) {
        String dft = defaultProtocol == null ? "" : defaultProtocol.trim();
        this.defaultProtocol = dft.isEmpty() ? null : dft;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        String dft;
        List<String> protocols = this.protocols;
        if (protocols.isEmpty()) {
            protocols = connector.getProtocols();
            Iterator<String> i = protocols.iterator();
            while (i.hasNext()) {
                String protocol = i.next();
                if (!"ssl".equalsIgnoreCase(protocol) && !"alpn".equalsIgnoreCase(protocol) && !"npn".equalsIgnoreCase(protocol)) continue;
                i.remove();
            }
        }
        if ((dft = this.defaultProtocol) == null && !protocols.isEmpty()) {
            dft = protocols.get(0);
        }
        SSLEngine engine = null;
        EndPoint ep = endPoint;
        while (engine == null && ep != null) {
            if (ep instanceof SslConnection.DecryptedEndPoint) {
                engine = ((SslConnection.DecryptedEndPoint)ep).getSslConnection().getSSLEngine();
                continue;
            }
            ep = null;
        }
        return this.configure(this.newServerConnection(connector, endPoint, engine, protocols, dft), connector, endPoint);
    }

    protected abstract AbstractConnection newServerConnection(Connector var1, EndPoint var2, SSLEngine var3, List<String> var4, String var5);

    @Override
    public String toString() {
        return String.format("%s@%x{%s,%s,%s}", this.getClass().getSimpleName(), this.hashCode(), this.getProtocol(), this.getDefaultProtocol(), this.getProtocols());
    }
}

