/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class SelectChannelEndPoint
extends ChannelEndPoint
implements SelectorManager.SelectableEndPoint {
    public static final Logger LOG = Log.getLogger(SelectChannelEndPoint.class);
    private final Runnable _updateTask = new Runnable(){

        @Override
        public void run() {
            try {
                SelectChannelEndPoint.this.setKeyInterests();
            }
            catch (CancelledKeyException x) {
                LOG.debug("Ignoring key update for concurrently closed channel {}", this);
                SelectChannelEndPoint.this.close();
            }
            catch (Throwable x) {
                LOG.warn("Ignoring key update for " + this, x);
                SelectChannelEndPoint.this.close();
            }
        }
    };
    private final AtomicReference<State> _interestState = new AtomicReference<State>(State.SELECTING);
    private final AtomicBoolean _open = new AtomicBoolean();
    private final SelectorManager.ManagedSelector _selector;
    private final SelectionKey _key;
    private int _interestOps;

    public SelectChannelEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selector, SelectionKey key, Scheduler scheduler, long idleTimeout) {
        super(scheduler, channel);
        this._selector = selector;
        this._key = key;
        this.setIdleTimeout(idleTimeout);
    }

    @Override
    protected boolean needsFill() {
        this.changeInterests(1, true);
        return false;
    }

    @Override
    protected void onIncompleteFlush() {
        this.changeInterests(4, true);
    }

    @Override
    public void onSelected() {
        int newInterestOps;
        assert (this._selector.isSelectorThread());
        int readyOps = this._key.readyOps();
        int oldInterestOps = this._interestOps;
        this._interestOps = newInterestOps = oldInterestOps & ~readyOps;
        if (!this._interestState.compareAndSet(State.SELECTING, State.PENDING)) {
            throw new IllegalStateException("Invalid state: " + this._interestState);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("onSelected {}->{} for {}", oldInterestOps, newInterestOps, this);
        }
        if ((readyOps & 1) != 0) {
            this.getFillInterest().fillable();
        }
        if ((readyOps & 4) != 0) {
            this.getWriteFlusher().completeWrite();
        }
    }

    @Override
    public void updateKey() {
        assert (this._selector.isSelectorThread());
        block6: while (true) {
            State current = this._interestState.get();
            switch (current) {
                case SELECTING: {
                    this.setKeyInterests();
                    return;
                }
                case PENDING: {
                    if (this._interestState.compareAndSet(current, State.UPDATING)) continue block6;
                    continue block6;
                }
                case UPDATING: {
                    this.setKeyInterests();
                    if (!this._interestState.compareAndSet(current, State.SELECTING)) {
                        throw new IllegalStateException();
                    }
                    return;
                }
                case CHANGING: {
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    private void changeInterests(int operation, boolean add) {
        boolean pending = false;
        block5: while (true) {
            State current = this._interestState.get();
            switch (current) {
                case SELECTING: 
                case PENDING: {
                    if (!this._interestState.compareAndSet(current, State.CHANGING)) continue block5;
                    pending = current == State.PENDING;
                    continue block5;
                }
                case UPDATING: {
                    Thread.yield();
                    continue block5;
                }
                case CHANGING: {
                    int oldInterestOps = this._interestOps;
                    int newInterestOps = add ? oldInterestOps | operation : oldInterestOps & ~operation;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("changeInterests pending={} {}->{} for {}", pending, oldInterestOps, newInterestOps, this);
                    }
                    if (newInterestOps != oldInterestOps) {
                        this._interestOps = newInterestOps;
                    }
                    if (!this._interestState.compareAndSet(current, State.SELECTING)) {
                        throw new IllegalStateException("Invalid state: " + (Object)((Object)current));
                    }
                    this.submitKeyUpdate(!pending);
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    protected void submitKeyUpdate(boolean submit) {
        if (submit) {
            this._selector.updateKey(this._updateTask);
        }
    }

    private void setKeyInterests() {
        int oldInterestOps = this._key.interestOps();
        int newInterestOps = this._interestOps;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Key interests update {} -> {}", oldInterestOps, newInterestOps);
        }
        if (oldInterestOps != newInterestOps) {
            this._key.interestOps(newInterestOps);
        }
    }

    @Override
    public void close() {
        if (this._open.compareAndSet(true, false)) {
            super.close();
            this._selector.destroyEndPoint(this);
        }
    }

    @Override
    public boolean isOpen() {
        return this._open.get();
    }

    @Override
    public void onOpen() {
        if (this._open.compareAndSet(false, true)) {
            super.onOpen();
        }
    }

    @Override
    public String toString() {
        try {
            boolean valid = this._key != null && this._key.isValid();
            int keyInterests = valid ? this._key.interestOps() : -1;
            int keyReadiness = valid ? this._key.readyOps() : -1;
            return String.format("%s{io=%d,kio=%d,kro=%d}", super.toString(), this._interestOps, keyInterests, keyReadiness);
        }
        catch (CancelledKeyException x) {
            return String.format("%s{io=%s,kio=-2,kro=-2}", super.toString(), this._interestOps);
        }
    }

    private static enum State {
        SELECTING,
        PENDING,
        UPDATING,
        CHANGING;

    }
}

