/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.frames.DataFrame;

public class FrameFlusher {
    private static final int MAX_GATHER = Integer.getInteger("org.eclipse.jetty.websocket.common.io.FrameFlusher.MAX_GATHER", 8);
    private static final Logger LOG = Log.getLogger(FrameFlusher.class);
    private final EndPoint endpoint;
    private final Generator generator;
    private final Object lock = new Object();
    private final ArrayQueue<FrameEntry> queue = new ArrayQueue(16, 16, this.lock);
    private final FlusherCB flusherCB = new FlusherCB();
    private int bufferSize = 2048;
    private Throwable failure;
    private boolean closed;

    public FrameFlusher(Generator generator, EndPoint endpoint) {
        this.endpoint = endpoint;
        this.generator = Objects.requireNonNull(generator);
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                EOFException eof = new EOFException("Connection has been disconnected");
                this.flusherCB.failed(eof);
                for (FrameEntry frame : this.queue) {
                    frame.notifyFailed(eof);
                }
                this.queue.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Frame frame, WriteCallback callback) {
        Objects.requireNonNull(frame);
        FrameEntry entry = new FrameEntry(frame, callback);
        LOG.debug("enqueue({})", entry);
        Throwable failure = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                LOG.debug("Write is closed: {} {}", frame, callback);
                failure = new IOException("Write is closed");
            } else if (this.failure != null) {
                failure = this.failure;
            }
            switch (frame.getOpCode()) {
                case 9: {
                    this.queue.add(0, entry);
                    break;
                }
                case 8: {
                    this.closed = true;
                    this.queue.add(entry);
                    break;
                }
                default: {
                    this.queue.add(entry);
                }
            }
        }
        if (failure != null) {
            LOG.debug("Write is in failure: {} {}", frame, callback);
            entry.notifyFailed(failure);
            return;
        }
        this.flush();
    }

    void flush() {
        this.flusherCB.iterate();
    }

    protected void onFailure(Throwable x) {
        LOG.warn(x);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WriteBytesProvider[");
        if (this.failure != null) {
            b.append("failure=").append(this.failure.getClass().getName());
            b.append(":").append(this.failure.getMessage()).append(',');
        } else {
            b.append("queue.size=").append(this.queue.size());
        }
        b.append(']');
        return b.toString();
    }

    private class FrameEntry {
        protected final AtomicBoolean failed = new AtomicBoolean(false);
        protected final Frame frame;
        protected final WriteCallback callback;
        private ByteBuffer headerBuffer;

        public FrameEntry(Frame frame, WriteCallback callback) {
            this.frame = frame;
            this.callback = callback;
        }

        public ByteBuffer getHeaderBytes() {
            ByteBuffer buf;
            this.headerBuffer = buf = FrameFlusher.this.generator.generateHeaderBytes(this.frame);
            return buf;
        }

        public ByteBuffer getPayload() {
            return this.frame.getPayload();
        }

        public void notifyFailed(Throwable t) {
            this.freeBuffers();
            if (!this.failed.getAndSet(true)) {
                try {
                    if (this.callback != null) {
                        this.callback.writeFailed(t);
                    }
                }
                catch (Throwable e) {
                    LOG.warn("Uncaught exception", e);
                }
            }
        }

        public void notifySucceeded() {
            this.freeBuffers();
            if (this.callback == null) {
                return;
            }
            try {
                this.callback.writeSuccess();
            }
            catch (Throwable t) {
                LOG.debug(t);
            }
        }

        public void freeBuffers() {
            if (this.headerBuffer != null) {
                FrameFlusher.this.generator.getBufferPool().release(this.headerBuffer);
                this.headerBuffer = null;
            }
            if (this.frame instanceof DataFrame) {
                ((DataFrame)this.frame).reset();
            }
        }

        public String toString() {
            return "[" + this.callback + "," + this.frame + "," + FrameFlusher.this.failure + "]";
        }
    }

    private class FlusherCB
    extends IteratingCallback {
        private final ArrayQueue<FrameEntry> active;
        private final List<ByteBuffer> buffers;
        private final List<FrameEntry> succeeded;

        private FlusherCB() {
            this.active = new ArrayQueue(FrameFlusher.this.lock);
            this.buffers = new ArrayList<ByteBuffer>(MAX_GATHER * 2);
            this.succeeded = new ArrayList<FrameEntry>(MAX_GATHER + 1);
        }

        @Override
        protected void completed() {
            throw new IllegalStateException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected IteratingCallback.Action process() throws Exception {
            Object object = FrameFlusher.this.lock;
            synchronized (object) {
                this.succeeded.clear();
                while (this.buffers.size() < MAX_GATHER && !FrameFlusher.this.queue.isEmpty()) {
                    FrameEntry frame = (FrameEntry)FrameFlusher.this.queue.remove(0);
                    this.active.add(frame);
                    this.buffers.add(frame.getHeaderBytes());
                    ByteBuffer payload = frame.getPayload();
                    if (payload == null) continue;
                    this.buffers.add(payload);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("process {} active={} buffers={}", FrameFlusher.this, this.active, this.buffers);
                }
            }
            if (this.buffers.size() == 0) {
                return IteratingCallback.Action.IDLE;
            }
            FrameFlusher.this.endpoint.write(this, this.buffers.toArray(new ByteBuffer[this.buffers.size()]));
            this.buffers.clear();
            return IteratingCallback.Action.SCHEDULED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void succeeded() {
            Object object = FrameFlusher.this.lock;
            synchronized (object) {
                this.succeeded.addAll(this.active);
                this.active.clear();
            }
            for (FrameEntry frame : this.succeeded) {
                frame.notifySucceeded();
                frame.freeBuffers();
            }
            super.succeeded();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable x) {
            Object object = FrameFlusher.this.lock;
            synchronized (object) {
                this.succeeded.addAll(this.active);
                this.active.clear();
            }
            for (FrameEntry frame : this.succeeded) {
                frame.notifyFailed(x);
                frame.freeBuffers();
            }
            this.succeeded.clear();
            super.failed(x);
            FrameFlusher.this.onFailure(x);
        }
    }
}

