/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContainerInitializer;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;

public class ContainerInitializer {
    private static final Logger LOG = Log.getLogger(ContainerInitializer.class);
    protected final ServletContainerInitializer _target;
    protected final Class[] _interestedTypes;
    protected Set<String> _applicableTypeNames = new ConcurrentHashSet<String>();
    protected Set<String> _annotatedTypeNames = new ConcurrentHashSet<String>();

    public ContainerInitializer(ServletContainerInitializer target, Class[] classes) {
        this._target = target;
        this._interestedTypes = classes;
    }

    public ServletContainerInitializer getTarget() {
        return this._target;
    }

    public Class[] getInterestedTypes() {
        return this._interestedTypes;
    }

    public void addAnnotatedTypeName(String className) {
        this._annotatedTypeNames.add(className);
    }

    public Set<String> getAnnotatedTypeNames() {
        return Collections.unmodifiableSet(this._annotatedTypeNames);
    }

    public void addApplicableTypeName(String className) {
        this._applicableTypeNames.add(className);
    }

    public Set<String> getApplicableTypeNames() {
        return Collections.unmodifiableSet(this._applicableTypeNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callStartup(WebAppContext context) throws Exception {
        if (this._target != null) {
            HashSet classes = new HashSet();
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(context.getClassLoader());
            try {
                for (String s : this._applicableTypeNames) {
                    classes.add(Loader.loadClass(context.getClass(), s));
                }
                context.getServletContext().setExtendedListenerTypes(true);
                if (LOG.isDebugEnabled()) {
                    long start = System.nanoTime();
                    this._target.onStartup(classes, context.getServletContext());
                    LOG.debug("ContainerInitializer {} called in {}ms", this._target.getClass().getName(), TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
                } else {
                    this._target.onStartup(classes, context.getServletContext());
                }
            }
            finally {
                context.getServletContext().setExtendedListenerTypes(false);
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
    }
}

