/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.io;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.ClientUpgradeResponse;
import org.eclipse.jetty.websocket.client.io.ConnectPromise;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.eclipse.jetty.websocket.client.io.WebSocketClientConnection;
import org.eclipse.jetty.websocket.common.AcceptHash;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.extensions.ExtensionStack;
import org.eclipse.jetty.websocket.common.io.http.HttpResponseHeaderParser;

public class UpgradeConnection
extends AbstractConnection {
    private static final int SWITCHING_PROTOCOLS = 101;
    private static final Logger LOG = Log.getLogger(UpgradeConnection.class);
    private final ByteBufferPool bufferPool;
    private final ConnectPromise connectPromise;
    private final HttpResponseHeaderParser parser;
    private ClientUpgradeRequest request;

    public UpgradeConnection(EndPoint endp, Executor executor, ConnectPromise connectPromise) {
        super(endp, executor);
        this.connectPromise = connectPromise;
        this.bufferPool = connectPromise.getClient().getBufferPool();
        this.request = connectPromise.getRequest();
        this.parser = new HttpResponseHeaderParser(new ClientUpgradeResponse());
    }

    public void disconnect(boolean onlyOutput) {
        EndPoint endPoint = this.getEndPoint();
        LOG.debug("Shutting down output {}", endPoint);
        endPoint.shutdownOutput();
        if (!onlyOutput) {
            LOG.debug("Closing {}", endPoint);
            endPoint.close();
        }
    }

    private void notifyConnect(ClientUpgradeResponse response) {
        this.connectPromise.setResponse(response);
        UpgradeListener handshakeListener = this.connectPromise.getUpgradeListener();
        if (handshakeListener != null) {
            handshakeListener.onHandshakeResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFillable() {
        ByteBuffer buffer = this.bufferPool.acquire(this.getInputBufferSize(), false);
        BufferUtil.clear(buffer);
        boolean readMore = false;
        try {
            readMore = this.read(buffer);
        }
        finally {
            this.bufferPool.release(buffer);
        }
        if (readMore) {
            this.fillInterested();
        }
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.getExecutor().execute(new SendUpgradeRequest());
    }

    private boolean read(ByteBuffer buffer) {
        EndPoint endPoint = this.getEndPoint();
        try {
            ClientUpgradeResponse resp;
            do {
                int filled;
                if ((filled = endPoint.fill(buffer)) == 0) {
                    return true;
                }
                if (filled < 0) {
                    LOG.debug("read - EOF Reached", new Object[0]);
                    return false;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Filled {} bytes - {}", filled, BufferUtil.toDetailString(buffer));
            } while ((resp = (ClientUpgradeResponse)this.parser.parse(buffer)) == null);
            this.validateResponse(resp);
            this.notifyConnect(resp);
            this.upgradeConnection(resp);
            if (buffer.hasRemaining()) {
                LOG.debug("Has remaining client bytebuffer of {}", buffer.remaining());
            }
            return false;
        }
        catch (IOException | HttpResponseHeaderParser.ParseException e) {
            UpgradeException ue = new UpgradeException(this.request.getRequestURI(), (Throwable)e);
            this.connectPromise.failed(ue);
            this.disconnect(false);
            return false;
        }
        catch (UpgradeException e) {
            this.connectPromise.failed(e);
            this.disconnect(false);
            return false;
        }
    }

    private void upgradeConnection(ClientUpgradeResponse response) {
        EndPoint endp = this.getEndPoint();
        Executor executor = this.getExecutor();
        WebSocketClientConnection connection = new WebSocketClientConnection(endp, executor, this.connectPromise);
        EventDriver websocket = this.connectPromise.getDriver();
        WebSocketPolicy policy = websocket.getPolicy();
        SessionFactory sessionFactory = this.connectPromise.getClient().getSessionFactory();
        WebSocketSession session = sessionFactory.createSession(this.request.getRequestURI(), websocket, connection);
        session.setPolicy(policy);
        session.setUpgradeResponse(response);
        connection.setSession(session);
        ExtensionStack extensionStack = new ExtensionStack(this.connectPromise.getClient().getExtensionFactory());
        extensionStack.negotiate(response.getExtensions());
        extensionStack.configure(connection.getParser());
        extensionStack.configure(connection.getGenerator());
        connection.setNextIncomingFrames(extensionStack);
        extensionStack.setNextIncoming(session);
        session.setOutgoingHandler(extensionStack);
        extensionStack.setNextOutgoing(connection);
        endp.setConnection(connection);
        connection.onOpen();
    }

    private void validateResponse(ClientUpgradeResponse response) {
        if (response.getStatusCode() != 101) {
            throw new UpgradeException(this.request.getRequestURI(), response.getStatusCode(), "Didn't switch protocols");
        }
        String connection = response.getHeader("Connection");
        if (!"upgrade".equalsIgnoreCase(connection)) {
            throw new UpgradeException(this.request.getRequestURI(), response.getStatusCode(), "Connection is " + connection + " (expected upgrade)");
        }
        String reqKey = this.request.getKey();
        String expectedHash = AcceptHash.hashKey(reqKey);
        String respHash = response.getHeader("Sec-WebSocket-Accept");
        response.setSuccess(true);
        if (!expectedHash.equalsIgnoreCase(respHash)) {
            response.setSuccess(false);
            throw new UpgradeException(this.request.getRequestURI(), response.getStatusCode(), "Invalid Sec-WebSocket-Accept hash");
        }
        ArrayList<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
        List<String> extValues = response.getHeaders("Sec-WebSocket-Extensions");
        if (extValues != null) {
            for (String extVal : extValues) {
                QuotedStringTokenizer tok = new QuotedStringTokenizer(extVal, ",");
                while (tok.hasMoreTokens()) {
                    extensions.add(ExtensionConfig.parse(tok.nextToken()));
                }
            }
        }
        response.setExtensions(extensions);
    }

    public class SendUpgradeRequest
    extends FutureCallback
    implements Runnable {
        @Override
        public void run() {
            URI uri = UpgradeConnection.this.connectPromise.getRequest().getRequestURI();
            UpgradeConnection.this.request.setRequestURI(uri);
            UpgradeListener handshakeListener = UpgradeConnection.this.connectPromise.getUpgradeListener();
            if (handshakeListener != null) {
                handshakeListener.onHandshakeRequest(UpgradeConnection.this.request);
            }
            String rawRequest = UpgradeConnection.this.request.generate();
            ByteBuffer buf = BufferUtil.toBuffer(rawRequest, StringUtil.__UTF8_CHARSET);
            UpgradeConnection.this.getEndPoint().write(this, buf);
        }

        @Override
        public void succeeded() {
            super.succeeded();
            UpgradeConnection.this.fillInterested();
        }

        @Override
        public void failed(Throwable cause) {
            super.failed(cause);
            UpgradeConnection.this.connectPromise.failed(cause);
        }
    }
}

