/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class HttpChannel<T>
implements HttpParser.RequestHandler<T>,
Runnable {
    private static final Logger LOG = Log.getLogger(HttpChannel.class);
    private static final ThreadLocal<HttpChannel<?>> __currentChannel = new ThreadLocal();
    private final AtomicBoolean _committed = new AtomicBoolean();
    private final AtomicInteger _requests = new AtomicInteger();
    private final Connector _connector;
    private final HttpConfiguration _configuration;
    private final EndPoint _endPoint;
    private final HttpTransport _transport;
    private final HttpURI _uri;
    private final HttpChannelState _state;
    private final Request _request;
    private final Response _response;
    private HttpVersion _version = HttpVersion.HTTP_1_1;
    private boolean _expect = false;
    private boolean _expect100Continue = false;
    private boolean _expect102Processing = false;

    public static HttpChannel<?> getCurrentHttpChannel() {
        return __currentChannel.get();
    }

    protected static void setCurrentHttpChannel(HttpChannel<?> channel) {
        __currentChannel.set(channel);
    }

    public HttpChannel(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransport transport, HttpInput<T> input) {
        this._connector = connector;
        this._configuration = configuration;
        this._endPoint = endPoint;
        this._transport = transport;
        this._uri = new HttpURI(URIUtil.__CHARSET);
        this._state = new HttpChannelState(this);
        this._request = new Request(this, input);
        this._response = new Response(this, new HttpOutput(this));
    }

    public HttpChannelState getState() {
        return this._state;
    }

    public HttpVersion getHttpVersion() {
        return this._version;
    }

    public int getRequests() {
        return this._requests.get();
    }

    public Connector getConnector() {
        return this._connector;
    }

    public ByteBufferPool getByteBufferPool() {
        return this._connector.getByteBufferPool();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._configuration;
    }

    public Server getServer() {
        return this._connector.getServer();
    }

    public Request getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._response;
    }

    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    public InetSocketAddress getLocalAddress() {
        return this._endPoint.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this._endPoint.getRemoteAddress();
    }

    public void continue100(int available) throws IOException {
        if (this.isExpecting100Continue()) {
            this._expect100Continue = false;
            if (available == 0) {
                if (this._response.isCommitted()) {
                    throw new IOException("Committed before 100 Continues");
                }
                boolean committed = this.commitResponse(HttpGenerator.CONTINUE_100_INFO, null, false);
                if (!committed) {
                    throw new IOException("Concurrent commit while trying to send 100-Continue");
                }
            }
        }
    }

    public void reset() {
        this._committed.set(false);
        this._expect = false;
        this._expect100Continue = false;
        this._expect102Processing = false;
        this._request.recycle();
        this._response.recycle();
        this._uri.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block35: {
            LOG.debug("{} handle enter", this);
            HttpChannel.setCurrentHttpChannel(this);
            String threadName = null;
            if (LOG.isDebugEnabled()) {
                threadName = Thread.currentThread().getName();
                Thread.currentThread().setName(threadName + " - " + this._uri);
            }
            try {
                boolean handling = this._state.handling();
                while (handling && this.getServer().isRunning()) {
                    try {
                        this._request.setHandled(false);
                        this._response.getHttpOutput().reopen();
                        if (this._state.isInitial()) {
                            this._request.setTimeStamp(System.currentTimeMillis());
                            this._request.setDispatcherType(DispatcherType.REQUEST);
                            for (HttpConfiguration.Customizer customizer : this._configuration.getCustomizers()) {
                                customizer.customize(this.getConnector(), this._configuration, this._request);
                            }
                            this.getServer().handle(this);
                        } else {
                            this._request.setDispatcherType(DispatcherType.ASYNC);
                            this.getServer().handleAsync(this);
                        }
                        handling = !this._state.unhandle();
                    }
                    catch (Error e) {
                        if (!"ContinuationThrowable".equals(e.getClass().getSimpleName())) {
                            throw e;
                        }
                        LOG.ignore(e);
                        handling = !this._state.unhandle();
                    }
                    catch (Exception e2) {
                        if (e2 instanceof EofException) {
                            LOG.debug(e2);
                        } else {
                            LOG.warn(String.valueOf(this._uri), e2);
                        }
                        this._state.error(e2);
                        this._request.setHandled(true);
                        this.handleException(e2);
                        handling = !this._state.unhandle();
                        {
                            catch (Throwable throwable) {
                                handling = !this._state.unhandle();
                                throw throwable;
                            }
                        }
                    }
                }
                if (threadName == null || !LOG.isDebugEnabled()) break block35;
                Thread.currentThread().setName(threadName);
            }
            catch (Throwable throwable) {
                if (threadName != null && LOG.isDebugEnabled()) {
                    Thread.currentThread().setName(threadName);
                }
                HttpChannel.setCurrentHttpChannel(null);
                if (this._state.isCompleting()) {
                    try {
                        this._state.completed();
                        if (!this._response.isCommitted() && !this._request.isHandled()) {
                            this._response.sendError(404);
                        }
                        this._response.complete();
                    }
                    catch (EofException e) {
                        LOG.debug(e);
                    }
                    catch (Exception e) {
                        LOG.warn(e);
                    }
                    finally {
                        this._request.setHandled(true);
                        this._transport.completed();
                    }
                }
                LOG.debug("{} handle exit", this);
                throw throwable;
            }
        }
        HttpChannel.setCurrentHttpChannel(null);
        if (this._state.isCompleting()) {
            try {
                this._state.completed();
                if (!this._response.isCommitted() && !this._request.isHandled()) {
                    this._response.sendError(404);
                }
                this._response.complete();
            }
            catch (EofException e) {
                LOG.debug(e);
            }
            catch (Exception e) {
                LOG.warn(e);
            }
            finally {
                this._request.setHandled(true);
                this._transport.completed();
            }
        }
        LOG.debug("{} handle exit", this);
    }

    protected void handleException(Throwable x) {
        try {
            if (this._state.isSuspended()) {
                HttpFields fields = new HttpFields();
                HttpGenerator.ResponseInfo info = new HttpGenerator.ResponseInfo(this._request.getHttpVersion(), fields, 0L, 500, null, this._request.isHead());
                boolean committed = this.commitResponse(info, null, true);
                if (!committed) {
                    LOG.warn("Could not send response error 500: " + x, new Object[0]);
                }
            } else if (this.isCommitted()) {
                if (!(x instanceof EofException)) {
                    LOG.warn("Could not send response error 500: " + x, new Object[0]);
                }
            } else {
                this._request.setAttribute("javax.servlet.error.exception", x);
                this._request.setAttribute("javax.servlet.error.exception_type", x.getClass());
                this._response.sendError(500, x.getMessage());
            }
        }
        catch (IOException e) {
            LOG.debug("Could not commit response error 500", e);
        }
    }

    public boolean isExpecting100Continue() {
        return this._expect100Continue;
    }

    public boolean isExpecting102Processing() {
        return this._expect102Processing;
    }

    public String toString() {
        return String.format("%s@%x{r=%s,a=%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._requests, this._state.getState()});
    }

    @Override
    public boolean startRequest(HttpMethod httpMethod, String method, ByteBuffer uri, HttpVersion version) {
        String path;
        this._expect = false;
        this._expect100Continue = false;
        this._expect102Processing = false;
        if (this._request.getTimeStamp() == 0L) {
            this._request.setTimeStamp(System.currentTimeMillis());
        }
        this._request.setMethod(httpMethod, method);
        if (httpMethod == HttpMethod.CONNECT) {
            this._uri.parseConnect(uri.array(), uri.arrayOffset() + uri.position(), uri.remaining());
        } else {
            this._uri.parse(uri.array(), uri.arrayOffset() + uri.position(), uri.remaining());
        }
        this._request.setUri(this._uri);
        try {
            path = this._uri.getDecodedPath();
        }
        catch (Exception e) {
            LOG.warn("Failed UTF-8 decode for request path, trying ISO-8859-1", new Object[0]);
            LOG.ignore(e);
            path = this._uri.getDecodedPath("ISO-8859-1");
        }
        String info = URIUtil.canonicalPath(path);
        if (info == null) {
            info = "/";
            this._request.setRequestURI("");
        }
        this._request.setPathInfo(info);
        this._version = version == null ? HttpVersion.HTTP_0_9 : version;
        this._request.setHttpVersion(this._version);
        return false;
    }

    @Override
    public boolean parsedHeader(HttpField field) {
        HttpHeader header = field.getHeader();
        String value = field.getValue();
        if (value == null) {
            value = "";
        }
        if (header != null) {
            block0 : switch (header) {
                case EXPECT: {
                    if (this._version.getVersion() < HttpVersion.HTTP_1_1.getVersion()) break;
                    HttpHeaderValue expect = HttpHeaderValue.CACHE.get(value);
                    switch (expect == null ? HttpHeaderValue.UNKNOWN : expect) {
                        case CONTINUE: {
                            this._expect100Continue = true;
                            break block0;
                        }
                        case PROCESSING: {
                            this._expect102Processing = true;
                            break block0;
                        }
                    }
                    String[] values = value.split(",");
                    block12: for (int i = 0; values != null && i < values.length; ++i) {
                        expect = HttpHeaderValue.CACHE.get(values[i].trim());
                        if (expect == null) {
                            this._expect = true;
                            continue;
                        }
                        switch (expect) {
                            case CONTINUE: {
                                this._expect100Continue = true;
                                continue block12;
                            }
                            case PROCESSING: {
                                this._expect102Processing = true;
                                continue block12;
                            }
                            default: {
                                this._expect = true;
                            }
                        }
                    }
                    break;
                }
                case CONTENT_TYPE: {
                    String charset;
                    MimeTypes.Type mime = MimeTypes.CACHE.get(value);
                    String string = charset = mime == null || mime.getCharset() == null ? MimeTypes.getCharsetFromContentType(value) : mime.getCharset().toString();
                    if (charset == null) break;
                    this._request.setCharacterEncodingUnchecked(charset);
                }
            }
        }
        if (field.getName() != null) {
            this._request.getHttpFields().add(field);
        }
        return false;
    }

    @Override
    public boolean parsedHostHeader(String host, int port) {
        this._request.setServerName(host);
        this._request.setServerPort(port);
        return false;
    }

    @Override
    public boolean headerComplete() {
        this._requests.incrementAndGet();
        switch (this._version) {
            case HTTP_0_9: {
                break;
            }
            case HTTP_1_0: {
                if (!this._configuration.getSendDateHeader()) break;
                this._response.getHttpFields().put(this._connector.getServer().getDateField());
                break;
            }
            case HTTP_1_1: {
                if (this._configuration.getSendDateHeader()) {
                    this._response.getHttpFields().put(this._connector.getServer().getDateField());
                }
                if (!this._expect) break;
                this.badMessage(417, null);
                return true;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._expect100Continue;
    }

    @Override
    public boolean content(T item) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} content {}", this, item);
        }
        HttpInput<?> input = this._request.getHttpInput();
        input.content(item);
        return true;
    }

    @Override
    public boolean messageComplete() {
        this._request.getHttpInput().shutdown();
        return true;
    }

    @Override
    public boolean earlyEOF() {
        this._request.getHttpInput().earlyEOF();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void badMessage(int status, String reason) {
        if (status < 400 || status > 599) {
            status = 400;
        }
        try {
            if (this._state.handling()) {
                this.commitResponse(new HttpGenerator.ResponseInfo(HttpVersion.HTTP_1_1, new HttpFields(), 0L, status, reason, false), null, true);
                this._state.unhandle();
            }
        }
        catch (IOException e) {
            LOG.warn(e);
        }
        finally {
            this._state.completed();
        }
    }

    protected boolean commitResponse(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean complete) throws IOException {
        boolean committed = this._committed.compareAndSet(false, true);
        if (committed) {
            try {
                this._transport.send(info, content, complete);
                if (info.getStatus() < 200) {
                    this._committed.set(false);
                }
            }
            catch (EofException e) {
                LOG.debug(e);
                this._transport.send(HttpGenerator.RESPONSE_500_INFO, null, true);
                complete = true;
                throw e;
            }
            catch (Exception e) {
                LOG.warn(e);
                this._transport.send(HttpGenerator.RESPONSE_500_INFO, null, true);
                complete = true;
                throw e;
            }
            finally {
                if (complete) {
                    this._response.getHttpOutput().closed();
                }
            }
        }
        return committed;
    }

    protected boolean isCommitted() {
        return this._committed.get();
    }

    protected void write(ByteBuffer content, boolean complete) throws IOException {
        if (this.isCommitted()) {
            this._transport.send(null, content, complete);
        } else {
            HttpGenerator.ResponseInfo info = this._response.newResponseInfo();
            boolean committed = this.commitResponse(info, content, complete);
            if (!committed) {
                throw new IOException("Concurrent commit");
            }
        }
    }

    protected void execute(Runnable task) {
        this._connector.getExecutor().execute(task);
    }

    public Scheduler getScheduler() {
        return this._connector.getScheduler();
    }
}

