/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.logging;

import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.eclipse.jetty.logging.JettyAppender;
import org.eclipse.jetty.logging.JettyLevel;
import org.eclipse.jetty.logging.JettyLogger;
import org.eclipse.jetty.logging.JettyLoggerConfiguration;
import org.eclipse.jetty.logging.StdErrAppender;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class JettyLoggerFactory
implements ILoggerFactory,
DynamicMBean {
    private final JettyLoggerConfiguration configuration;
    private final JettyLogger rootLogger;
    private final ConcurrentMap<String, JettyLogger> loggerMap;
    private MBeanInfo mBeanInfo;

    public JettyLoggerFactory(JettyLoggerConfiguration config) {
        this.configuration = Objects.requireNonNull(config, "JettyLoggerConfiguration");
        this.loggerMap = new ConcurrentHashMap<String, JettyLogger>();
        StdErrAppender appender = new StdErrAppender(this.configuration);
        this.rootLogger = new JettyLogger(this, "ROOT", appender);
        this.loggerMap.put("ROOT", this.rootLogger);
        this.rootLogger.setLevel(this.configuration.getLevel("ROOT"));
    }

    public String jmxContext() {
        return this.configuration.getString("org.eclipse.jetty.logging.jmx.context", null);
    }

    public JettyLogger getJettyLogger(String name) {
        if (name.equals("ROOT")) {
            return this.getRootLogger();
        }
        return this.loggerMap.computeIfAbsent(name, this::createLogger);
    }

    @Override
    public Logger getLogger(String name) {
        return this.getJettyLogger(name);
    }

    void walkChildrenLoggers(String parentName, Consumer<JettyLogger> childConsumer) {
        Object prefix = parentName;
        if (parentName.length() > 0 && !((String)prefix).endsWith(".")) {
            prefix = (String)prefix + ".";
        }
        for (JettyLogger logger : this.loggerMap.values()) {
            if (logger.getName().equals(parentName) || !logger.getName().startsWith((String)prefix)) continue;
            childConsumer.accept(logger);
        }
    }

    JettyLogger getRootLogger() {
        return this.rootLogger;
    }

    private JettyLogger createLogger(String name) {
        JettyAppender appender = this.rootLogger.getAppender();
        JettyLevel level = this.configuration.getLevel(name);
        boolean hideStacks = this.configuration.getHideStacks(name);
        return new JettyLogger(this, name, appender, level, hideStacks);
    }

    static <T> T walkParentLoggerNames(String startName, Function<String, T> nameFunction) {
        if (startName == null) {
            return null;
        }
        String nameSegment = startName;
        while (nameSegment.length() > 0) {
            T ret = nameFunction.apply(nameSegment);
            if (ret != null) {
                return ret;
            }
            int idx = nameSegment.lastIndexOf(46);
            if (idx < 0) break;
            nameSegment = nameSegment.substring(0, idx);
        }
        return nameFunction.apply("ROOT");
    }

    public String[] getLoggerNames() {
        TreeSet names = new TreeSet(this.loggerMap.keySet());
        return names.toArray(new String[0]);
    }

    public int getLoggerCount() {
        return this.loggerMap.size();
    }

    public String getLoggerLevel(String loggerName) {
        return JettyLoggerFactory.walkParentLoggerNames(loggerName, key -> {
            JettyLogger logger = (JettyLogger)this.loggerMap.get(key);
            if (logger != null) {
                return logger.getLevel().name();
            }
            return null;
        });
    }

    public boolean setLoggerLevel(String loggerName, String levelName) {
        JettyLevel level = JettyLoggerConfiguration.toJettyLevel(loggerName, levelName);
        if (level == null) {
            return false;
        }
        JettyLogger jettyLogger = this.getJettyLogger(loggerName);
        jettyLogger.setLevel(level);
        return true;
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException {
        Objects.requireNonNull(name, "Attribute Name");
        switch (name) {
            case "LoggerNames": {
                return this.getLoggerNames();
            }
            case "LoggerCount": {
                return this.getLoggerCount();
            }
        }
        throw new AttributeNotFoundException("Cannot find " + name + " attribute in " + this.getClass().getName());
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException {
        Objects.requireNonNull(attribute, "attribute");
        String name = attribute.getName();
        throw new AttributeNotFoundException("Cannot set attribute " + name + " because it is read-only");
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        Objects.requireNonNull(attributeNames, "attributeNames[]");
        AttributeList ret = new AttributeList();
        if (attributeNames.length == 0) {
            return ret;
        }
        for (String name : attributeNames) {
            try {
                Object value = this.getAttribute(name);
                ret.add(new Attribute(name, value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        Objects.requireNonNull(attributes, "attributes");
        AttributeList ret = new AttributeList();
        if (attributes.isEmpty()) {
            return ret;
        }
        for (Attribute attr : attributes.asList()) {
            try {
                this.setAttribute(attr);
                String name = attr.getName();
                Object value = this.getAttribute(name);
                ret.add(new Attribute(name, value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Objects.requireNonNull(actionName, "Action Name");
        switch (actionName) {
            case "setLoggerLevel": {
                String loggerName = (String)params[0];
                String level = (String)params[1];
                return this.setLoggerLevel(loggerName, level);
            }
            case "getLoggerLevel": {
                String loggerName = (String)params[0];
                return this.getLoggerLevel(loggerName);
            }
        }
        throw new ReflectionException(new NoSuchMethodException(actionName), "Cannot find the operation " + actionName + " in " + this.getClass().getName());
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.mBeanInfo == null) {
            MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[]{new MBeanAttributeInfo("LoggerCount", "java.lang.Integer", "Count of Registered Loggers by Name.", true, false, false), new MBeanAttributeInfo("LoggerNames", "java.lang.String[]", "List of Registered Loggers by Name.", true, false, false)};
            MBeanOperationInfo[] operations = new MBeanOperationInfo[]{new MBeanOperationInfo("setLoggerLevel", "Set the logging level at the named logger", new MBeanParameterInfo[]{new MBeanParameterInfo("loggerName", "java.lang.String", "The name of the logger"), new MBeanParameterInfo("level", "java.lang.String", "The name of the level [DEBUG, INFO, WARN, ERROR]")}, "boolean", 1), new MBeanOperationInfo("getLoggerLevel", "Get the logging level at the named logger", new MBeanParameterInfo[]{new MBeanParameterInfo("loggerName", "java.lang.String", "The name of the logger")}, "java.lang.String", 0)};
            this.mBeanInfo = new MBeanInfo(this.getClass().getName(), "Jetty Slf4J Logger Factory", attrs, new MBeanConstructorInfo[0], operations, new MBeanNotificationInfo[0]);
        }
        return this.mBeanInfo;
    }
}

