/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jetty.servlet.BaseHolder;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationIntrospector {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationIntrospector.class);
    private final AutoLock _lock = new AutoLock();
    private final Set<Class<?>> _introspectedClasses = new HashSet();
    private final List<IntrospectableAnnotationHandler> _handlers = new ArrayList<IntrospectableAnnotationHandler>();
    private final WebAppContext _context;

    public AnnotationIntrospector(WebAppContext context) {
        this._context = Objects.requireNonNull(context);
    }

    public void registerHandler(IntrospectableAnnotationHandler handler) {
        this._handlers.add(handler);
    }

    public boolean isIntrospectable(Object o, Object metaInfo) {
        Source.Origin origin;
        if (o == null) {
            return false;
        }
        if (metaInfo == null) {
            return true;
        }
        BaseHolder holder = null;
        try {
            holder = (BaseHolder)metaInfo;
        }
        catch (ClassCastException e) {
            LOG.warn("Not introspectable {}", (Object)metaInfo.getClass().getName(), (Object)e);
            return true;
        }
        Source.Origin origin2 = origin = holder.getSource() == null ? null : holder.getSource().getOrigin();
        if (origin == null) {
            return true;
        }
        switch (origin) {
            case EMBEDDED: 
            case JAKARTA_API: {
                return true;
            }
            case ANNOTATION: {
                return true;
            }
        }
        if (this._context.getMetaData().isMetaDataComplete()) {
            return false;
        }
        String descriptorLocation = holder.getSource().getResource();
        if (descriptorLocation == null) {
            return true;
        }
        try {
            return !WebDescriptor.isMetaDataComplete(this._context.getMetaData().getFragmentDescriptor(Resource.newResource(descriptorLocation)));
        }
        catch (IOException e) {
            LOG.warn("Unable to get Resource for descriptor {}", (Object)descriptorLocation, (Object)e);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void introspect(Object o, Object metaInfo) {
        if (!this.isIntrospectable(o, metaInfo)) {
            return;
        }
        Class<?> clazz = o.getClass();
        try (AutoLock l = this._lock.lock();){
            if (!this._introspectedClasses.add(clazz)) return;
            for (IntrospectableAnnotationHandler handler : this._handlers) {
                try {
                    handler.handle(clazz);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
    }

    public static abstract class AbstractIntrospectableAnnotationHandler
    implements IntrospectableAnnotationHandler {
        protected boolean _introspectAncestors;
        protected WebAppContext _context;

        public abstract void doHandle(Class<?> var1);

        public AbstractIntrospectableAnnotationHandler(boolean introspectAncestors, WebAppContext context) {
            this._context = Objects.requireNonNull(context);
            this._introspectAncestors = introspectAncestors;
        }

        @Override
        public void handle(Class<?> clazz) {
            for (Class<?> c = clazz; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
                this.doHandle(c);
                if (!this._introspectAncestors) break;
            }
        }

        public WebAppContext getContext() {
            return this._context;
        }
    }

    public static interface IntrospectableAnnotationHandler {
        public void handle(Class<?> var1);
    }
}

