/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.ssl;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRejectedException;
import org.apache.mina.core.write.WriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SslHandler {
    protected static final int MIN_ENCODER_BUFFER_PACKETS = 2;
    protected static final int MAX_ENCODER_BUFFER_PACKETS = 8;
    protected static final IoBuffer ZERO = IoBuffer.allocate(0, true);
    protected static final Logger LOGGER = LoggerFactory.getLogger(SslHandler.class);
    protected final Deque<WriteRequest> mEncodeQueue = new ConcurrentLinkedDeque<WriteRequest>();
    protected final Deque<WriteRequest> mAckQueue = new ConcurrentLinkedDeque<WriteRequest>();
    protected final SSLEngine mEngine;
    protected final Executor mExecutor;
    protected final IoSession mSession;
    protected IoBuffer mDecodeBuffer;

    public SslHandler(SSLEngine p, Executor e, IoSession s) {
        this.mEngine = p;
        this.mExecutor = e;
        this.mSession = s;
    }

    public abstract boolean isOpen();

    public abstract boolean isConnected();

    public abstract void open(IoFilter.NextFilter var1) throws SSLException;

    public abstract void receive(IoFilter.NextFilter var1, IoBuffer var2) throws SSLException;

    public abstract void ack(IoFilter.NextFilter var1, WriteRequest var2) throws SSLException;

    public abstract void write(IoFilter.NextFilter var1, WriteRequest var2) throws SSLException, WriteRejectedException;

    public abstract void close(IoFilter.NextFilter var1, boolean var2) throws SSLException;

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append("@");
        b.append(Integer.toHexString(this.hashCode()));
        b.append("[mode=");
        if (this.mEngine.getUseClientMode()) {
            b.append("client");
        } else {
            b.append("server");
        }
        b.append(", connected=");
        b.append(this.isConnected());
        b.append("]");
        return b.toString();
    }

    protected IoBuffer resume_decode_buffer(IoBuffer source) {
        if (this.mDecodeBuffer == null) {
            if (source == null) {
                return ZERO;
            }
            this.mDecodeBuffer = source;
            return source;
        }
        if (source != null && source != ZERO) {
            this.mDecodeBuffer.expand(source.remaining());
            this.mDecodeBuffer.put(source);
            source.free();
        }
        this.mDecodeBuffer.flip();
        return this.mDecodeBuffer;
    }

    protected void suspend_decode_buffer(IoBuffer source) {
        if (source.hasRemaining()) {
            if (source.isDerived()) {
                this.mDecodeBuffer = IoBuffer.allocate(source.remaining());
                this.mDecodeBuffer.put(source);
            } else {
                source.compact();
                this.mDecodeBuffer = source;
            }
        } else {
            if (source != ZERO) {
                source.free();
            }
            this.mDecodeBuffer = null;
        }
    }

    protected IoBuffer allocate_encode_buffer(int estimate) {
        SSLSession session = this.mEngine.getHandshakeSession();
        if (session == null) {
            session = this.mEngine.getSession();
        }
        int packets = Math.max(2, Math.min(8, 1 + estimate / session.getApplicationBufferSize()));
        return IoBuffer.allocate(packets * session.getPacketBufferSize());
    }

    protected IoBuffer allocate_app_buffer(int estimate) {
        SSLSession session = this.mEngine.getHandshakeSession();
        if (session == null) {
            session = this.mEngine.getSession();
        }
        int packets = 1 + estimate / session.getPacketBufferSize();
        return IoBuffer.allocate(packets * session.getApplicationBufferSize());
    }
}

