/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.annotation.Annotation;
import org.junit.jupiter.params.provider.CsvFileSource;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvFormat;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvParser;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvParserSettings;
import org.junit.platform.commons.util.Preconditions;

class CsvParserFactory {
    private static final String DEFAULT_DELIMITER = ",";
    private static final String LINE_SEPARATOR = "\n";
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char EMPTY_CHAR = '\u0000';

    CsvParserFactory() {
    }

    static CsvParser createParserFor(CsvSource annotation) {
        String delimiter = CsvParserFactory.selectDelimiter(annotation, annotation.delimiter(), annotation.delimiterString());
        return CsvParserFactory.createParser(delimiter, LINE_SEPARATOR, '\'', annotation.emptyValue(), annotation.maxCharsPerColumn());
    }

    static CsvParser createParserFor(CsvFileSource annotation) {
        String delimiter = CsvParserFactory.selectDelimiter(annotation, annotation.delimiter(), annotation.delimiterString());
        return CsvParserFactory.createParser(delimiter, annotation.lineSeparator(), '\"', annotation.emptyValue(), annotation.maxCharsPerColumn());
    }

    private static String selectDelimiter(Annotation annotation, char delimiter, String delimiterString) {
        Preconditions.condition(delimiter == '\u0000' || delimiterString.isEmpty(), () -> "The delimiter and delimiterString attributes cannot be set simultaneously in " + annotation);
        if (delimiter != '\u0000') {
            return String.valueOf(delimiter);
        }
        if (!delimiterString.isEmpty()) {
            return delimiterString;
        }
        return DEFAULT_DELIMITER;
    }

    private static CsvParser createParser(String delimiter, String lineSeparator, char quote, String emptyValue, int maxCharsPerColumn) {
        return new CsvParser(CsvParserFactory.createParserSettings(delimiter, lineSeparator, quote, emptyValue, maxCharsPerColumn));
    }

    private static CsvParserSettings createParserSettings(String delimiter, String lineSeparator, char quote, String emptyValue, int maxCharsPerColumn) {
        CsvParserSettings settings = new CsvParserSettings();
        ((CsvFormat)settings.getFormat()).setDelimiter(delimiter);
        ((CsvFormat)settings.getFormat()).setLineSeparator(lineSeparator);
        ((CsvFormat)settings.getFormat()).setQuote(quote);
        ((CsvFormat)settings.getFormat()).setQuoteEscape(quote);
        settings.setEmptyValue(emptyValue);
        settings.setAutoConfigurationEnabled(false);
        Preconditions.condition(maxCharsPerColumn > 0, () -> "maxCharsPerColumn must be a positive number: " + maxCharsPerColumn);
        settings.setMaxCharsPerColumn(maxCharsPerColumn);
        return settings;
    }
}

