/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public final class Net {
    public static boolean isInterfaceAvailableFor(Class<? extends InetAddress> addrClass) {
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> addrs = iface.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!addrClass.isAssignableFrom(addr.getClass())) continue;
                    return true;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isIpv6InterfaceAvailable() {
        return Net.isInterfaceAvailableFor(Inet6Address.class);
    }

    public static boolean isIpv4InterfaceAvailable() {
        return Net.isInterfaceAvailableFor(Inet4Address.class);
    }
}

