/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jaas.spi;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.jetty.jaas.spi.AbstractLoginModule;
import org.eclipse.jetty.jaas.spi.UserInfo;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.security.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileLoginModule
extends AbstractLoginModule {
    public static final String DEFAULT_FILENAME = "realm.properties";
    private static final Logger LOG = LoggerFactory.getLogger(PropertyFileLoginModule.class);
    private static ConcurrentHashMap<String, PropertyUserStore> _propertyUserStores = new ConcurrentHashMap();
    private int _refreshInterval = 0;
    private String _filename = "realm.properties";

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.setupPropertyUserStore(options);
    }

    private void setupPropertyUserStore(Map<String, ?> options) {
        this.parseConfig(options);
        if (_propertyUserStores.get(this._filename) == null) {
            PropertyUserStore propertyUserStore = new PropertyUserStore();
            propertyUserStore.setConfig(this._filename);
            PropertyUserStore prev = _propertyUserStores.putIfAbsent(this._filename, propertyUserStore);
            if (prev == null) {
                LOG.debug("setupPropertyUserStore: Starting new PropertyUserStore. PropertiesFile: {} refreshInterval: {}", (Object)this._filename, (Object)this._refreshInterval);
                try {
                    propertyUserStore.start();
                }
                catch (Exception e) {
                    LOG.warn("Exception while starting propertyUserStore: ", e);
                }
            }
        }
    }

    private void parseConfig(Map<String, ?> options) {
        String tmp = (String)options.get("file");
        this._filename = tmp == null ? DEFAULT_FILENAME : tmp;
        tmp = (String)options.get("refreshInterval");
        this._refreshInterval = tmp == null ? this._refreshInterval : Integer.parseInt(tmp);
    }

    @Override
    public UserInfo getUserInfo(String userName) throws Exception {
        UserIdentity userIdentity;
        PropertyUserStore propertyUserStore = _propertyUserStores.get(this._filename);
        if (propertyUserStore == null) {
            throw new IllegalStateException("PropertyUserStore should never be null here!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking PropertyUserStore {} for {}", (Object)this._filename, (Object)userName);
        }
        if ((userIdentity = propertyUserStore.getUserIdentity(userName)) == null) {
            return null;
        }
        Set<AbstractLoginService.RolePrincipal> principals = userIdentity.getSubject().getPrincipals(AbstractLoginService.RolePrincipal.class);
        List<String> roles = principals.stream().map(AbstractLoginService.RolePrincipal::getName).collect(Collectors.toList());
        Credential credential = (Credential)userIdentity.getSubject().getPrivateCredentials().iterator().next();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found: {} in PropertyUserStore {}", (Object)userName, (Object)this._filename);
        }
        return new UserInfo(userName, credential, roles);
    }
}

