/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.annotation.HandlesTypes;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.annotations.AbstractDiscoverableAnnotationHandler;
import org.eclipse.jetty.annotations.AnnotationDecorator;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassInheritanceHandler;
import org.eclipse.jetty.annotations.ContainerInitializerAnnotationHandler;
import org.eclipse.jetty.annotations.ServletContainerInitializersStarter;
import org.eclipse.jetty.annotations.WebFilterAnnotationHandler;
import org.eclipse.jetty.annotations.WebListenerAnnotationHandler;
import org.eclipse.jetty.annotations.WebServletAnnotationHandler;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.FragmentDescriptor;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebDescriptor;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationConfiguration.class);
    public static final String SERVLET_CONTAINER_INITIALIZER_EXCLUSION_PATTERN = "org.eclipse.jetty.containerInitializerExclusionPattern";
    public static final String SERVLET_CONTAINER_INITIALIZER_ORDER = "org.eclipse.jetty.containerInitializerOrder";
    public static final String CLASS_INHERITANCE_MAP = "org.eclipse.jetty.classInheritanceMap";
    public static final String CONTAINER_INITIALIZERS = "org.eclipse.jetty.containerInitializers";
    public static final String CONTAINER_INITIALIZER_STARTER = "org.eclipse.jetty.containerInitializerStarter";
    public static final String MULTI_THREADED = "org.eclipse.jetty.annotations.multiThreaded";
    public static final String MAX_SCAN_WAIT = "org.eclipse.jetty.annotations.maxWait";
    public static final int DEFAULT_MAX_SCAN_WAIT = 60;
    public static final boolean DEFAULT_MULTI_THREADED = true;
    protected final List<AbstractDiscoverableAnnotationHandler> _discoverableAnnotationHandlers = new ArrayList<AbstractDiscoverableAnnotationHandler>();
    protected ClassInheritanceHandler _classInheritanceHandler;
    protected final List<ContainerInitializerAnnotationHandler> _containerInitializerAnnotationHandlers = new ArrayList<ContainerInitializerAnnotationHandler>();
    protected List<ParserTask> _parserTasks;
    protected CounterStatistic _containerPathStats;
    protected CounterStatistic _webInfLibStats;
    protected CounterStatistic _webInfClassesStats;
    protected Pattern _sciExcludePattern;
    protected List<ServletContainerInitializer> _initializers;

    public AnnotationConfiguration() {
        this.addDependencies(WebXmlConfiguration.class, MetaInfConfiguration.class, FragmentConfiguration.class, PlusConfiguration.class);
        this.addDependents(JettyWebXmlConfiguration.class);
        this.protectAndExpose("org.eclipse.jetty.util.annotations.");
        this.hide("org.objectweb.asm.");
    }

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        String tmp = (String)context.getAttribute(SERVLET_CONTAINER_INITIALIZER_EXCLUSION_PATTERN);
        this._sciExcludePattern = tmp == null ? null : Pattern.compile(tmp);
    }

    public void addDiscoverableAnnotationHandler(AbstractDiscoverableAnnotationHandler handler) {
        this._discoverableAnnotationHandlers.add(handler);
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        List initializers;
        context.getObjectFactory().addDecorator(new AnnotationDecorator(context));
        if (!context.getMetaData().isMetaDataComplete() && (context.getServletContext().getEffectiveMajorVersion() >= 3 || context.isConfigurationDiscovered())) {
            this._discoverableAnnotationHandlers.add(new WebServletAnnotationHandler(context));
            this._discoverableAnnotationHandlers.add(new WebFilterAnnotationHandler(context));
            this._discoverableAnnotationHandlers.add(new WebListenerAnnotationHandler(context));
        }
        this.createServletContainerInitializerAnnotationHandlers(context, this.getNonExcludedInitializers(context));
        if (!this._discoverableAnnotationHandlers.isEmpty() || this._classInheritanceHandler != null || !this._containerInitializerAnnotationHandlers.isEmpty()) {
            this.scanForAnnotations(context);
        }
        if ((initializers = (List)context.getAttribute(CONTAINER_INITIALIZERS)) != null && initializers.size() > 0) {
            Map map = (Map)context.getAttribute(CLASS_INHERITANCE_MAP);
            for (ContainerInitializer i2 : initializers) {
                i2.resolveClasses(context, map);
            }
        }
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        ServletContainerInitializersStarter starter;
        ClassInheritanceMap classMap = (ClassInheritanceMap)context.getAttribute(CLASS_INHERITANCE_MAP);
        if (classMap != null) {
            classMap.clear();
        }
        context.removeAttribute(CLASS_INHERITANCE_MAP);
        List initializers = (List)context.getAttribute(CONTAINER_INITIALIZERS);
        if (initializers != null) {
            initializers.clear();
        }
        context.removeAttribute(CONTAINER_INITIALIZERS);
        if (this._discoverableAnnotationHandlers != null) {
            this._discoverableAnnotationHandlers.clear();
        }
        this._classInheritanceHandler = null;
        if (this._containerInitializerAnnotationHandlers != null) {
            this._containerInitializerAnnotationHandlers.clear();
        }
        if (this._parserTasks != null) {
            this._parserTasks.clear();
            this._parserTasks = null;
        }
        if ((starter = (ServletContainerInitializersStarter)context.getAttribute(CONTAINER_INITIALIZER_STARTER)) != null) {
            context.removeBean(starter);
            context.removeAttribute(CONTAINER_INITIALIZER_STARTER);
        }
        if (this._initializers != null) {
            this._initializers.clear();
        }
        super.postConfigure(context);
    }

    protected void scanForAnnotations(WebAppContext context) throws Exception {
        int javaPlatform = 0;
        Object target = context.getAttribute("org.eclipse.jetty.javaTargetPlatform");
        if (target != null) {
            javaPlatform = Integer.parseInt(target.toString());
        }
        AnnotationParser parser = this.createAnnotationParser(javaPlatform);
        this._parserTasks = new ArrayList<ParserTask>();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Annotation scanning commencing: webxml={}, metadatacomplete={}, configurationDiscovered={}, multiThreaded={}, maxScanWait={}", context.getServletContext().getEffectiveMajorVersion(), context.getMetaData().isMetaDataComplete(), context.isConfigurationDiscovered(), this.isUseMultiThreading(context), this.getMaxScanWait(context));
        }
        this.parseContainerPath(context, parser);
        this.parseWebInfClasses(context, parser);
        this.parseWebInfLib(context, parser);
        long start = System.nanoTime();
        final Semaphore task_limit = this.isUseMultiThreading(context) ? new Semaphore(ProcessorUtils.availableProcessors()) : new Semaphore(1);
        final CountDownLatch latch = new CountDownLatch(this._parserTasks.size());
        final MultiException me = new MultiException();
        for (final ParserTask p : this._parserTasks) {
            task_limit.acquire();
            context.getServer().getThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        p.call();
                    }
                    catch (Exception e) {
                        me.add(e);
                    }
                    finally {
                        task_limit.release();
                        latch.countDown();
                    }
                }
            });
        }
        boolean timeout = !latch.await(this.getMaxScanWait(context), TimeUnit.SECONDS);
        long elapsedMs = TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Annotation scanning elapsed time={}ms", (Object)elapsedMs);
            for (ParserTask p : this._parserTasks) {
                LOG.debug("Scanned {} in {}ms", (Object)p.getResource(), (Object)TimeUnit.MILLISECONDS.convert(p.getStatistic().getElapsed(), TimeUnit.NANOSECONDS));
            }
            LOG.debug("Scanned {} container path jars, {} WEB-INF/lib jars, {} WEB-INF/classes dirs in {}ms for context {}", this._containerPathStats == null ? -1L : this._containerPathStats.getTotal(), this._webInfLibStats == null ? -1L : this._webInfLibStats.getTotal(), this._webInfClassesStats == null ? -1L : this._webInfClassesStats.getTotal(), elapsedMs, context);
        }
        if (timeout) {
            me.add(new Exception("Timeout scanning annotations"));
        }
        me.ifExceptionThrow();
    }

    protected AnnotationParser createAnnotationParser(int javaPlatform) {
        return new AnnotationParser(javaPlatform);
    }

    protected boolean isUseMultiThreading(WebAppContext context) {
        Object o = context.getAttribute(MULTI_THREADED);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        o = context.getServer().getAttribute(MULTI_THREADED);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.parseBoolean(System.getProperty(MULTI_THREADED, Boolean.toString(true)));
    }

    protected int getMaxScanWait(WebAppContext context) {
        Object o = context.getAttribute(MAX_SCAN_WAIT);
        if (o != null && o instanceof Number) {
            return ((Number)o).intValue();
        }
        o = context.getServer().getAttribute(MAX_SCAN_WAIT);
        if (o != null && o instanceof Number) {
            return ((Number)o).intValue();
        }
        return Integer.getInteger(MAX_SCAN_WAIT, 60);
    }

    @Override
    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        context.getObjectFactory().addDecorator(new AnnotationDecorator(context));
    }

    public void createServletContainerInitializerAnnotationHandlers(WebAppContext context, List<ServletContainerInitializer> scis) throws Exception {
        if (scis == null || scis.isEmpty()) {
            return;
        }
        ArrayList<ContainerInitializer> initializers = new ArrayList<ContainerInitializer>();
        context.setAttribute(CONTAINER_INITIALIZERS, initializers);
        for (ServletContainerInitializer service : scis) {
            HandlesTypes annotation = service.getClass().getAnnotation(HandlesTypes.class);
            ContainerInitializer initializer = null;
            if (annotation != null) {
                Class<?>[] classes = annotation.value();
                if (classes != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("HandlesTypes {} on initializer {}", (Object)Arrays.asList(classes), (Object)service.getClass());
                    }
                    initializer = new ContainerInitializer(service, classes);
                    if (context.getAttribute(CLASS_INHERITANCE_MAP) == null) {
                        ClassInheritanceMap map = new ClassInheritanceMap();
                        context.setAttribute(CLASS_INHERITANCE_MAP, map);
                        this._classInheritanceHandler = new ClassInheritanceHandler(map);
                    }
                    for (Class<?> c : classes) {
                        if (!c.isAnnotation()) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Registering annotation handler for {}", (Object)c.getName());
                        }
                        this._containerInitializerAnnotationHandlers.add(new ContainerInitializerAnnotationHandler(initializer, c));
                    }
                } else {
                    initializer = new ContainerInitializer(service, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No classes in HandlesTypes on initializer {}", (Object)service.getClass());
                    }
                }
            } else {
                initializer = new ContainerInitializer(service, null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No HandlesTypes annotation on initializer {}", (Object)service.getClass());
                }
            }
            initializers.add(initializer);
        }
        ServletContainerInitializersStarter starter = (ServletContainerInitializersStarter)context.getAttribute(CONTAINER_INITIALIZER_STARTER);
        if (starter != null) {
            throw new IllegalStateException("ServletContainerInitializersStarter already exists");
        }
        starter = new ServletContainerInitializersStarter(context);
        context.setAttribute(CONTAINER_INITIALIZER_STARTER, starter);
        context.addBean(starter, true);
    }

    public Resource getJarFor(ServletContainerInitializer service) throws MalformedURLException, IOException {
        URI uri = TypeUtil.getLocationOfClass(service.getClass());
        if (uri == null) {
            return null;
        }
        return Resource.newResource(uri);
    }

    public boolean isFromExcludedJar(WebAppContext context, ServletContainerInitializer sci, Resource sciResource) throws Exception {
        Resource r;
        if (sci == null) {
            throw new IllegalArgumentException("ServletContainerInitializer null");
        }
        if (context == null) {
            throw new IllegalArgumentException("WebAppContext null");
        }
        if (sciResource == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("!Excluded {} null resource", (Object)sci);
            }
            return false;
        }
        if (this.isFromWebInfClasses(context, sciResource)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("!Excluded {} from web-inf/classes", (Object)sci);
            }
            return false;
        }
        if (this.isFromContainerClassPath(context, sci)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("!Excluded {} from container classpath", (Object)sci);
            }
            return false;
        }
        if (!context.getMetaData().isOrdered()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("!Excluded {} no ordering", (Object)sci);
            }
            return false;
        }
        List<Resource> orderedJars = context.getMetaData().getWebInfResources(true);
        if (orderedJars.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Excluded {} empty ordering", (Object)sci);
            }
            return true;
        }
        URI loadingJarURI = sciResource.getURI();
        boolean included = false;
        Iterator<Resource> iterator = orderedJars.iterator();
        while (iterator.hasNext() && !(included = (r = iterator.next()).getURI().equals(loadingJarURI))) {
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}Excluded {} found={}", included ? "!" : "", sci, included);
        }
        return !included;
    }

    public boolean matchesExclusionPattern(ServletContainerInitializer sci) {
        if (this._sciExcludePattern == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking {} against containerInitializerExclusionPattern", (Object)sci.getClass().getName());
        }
        return this._sciExcludePattern.matcher(sci.getClass().getName()).matches();
    }

    public boolean isFromContainerClassPath(WebAppContext context, ServletContainerInitializer sci) {
        if (sci == null) {
            return false;
        }
        ClassLoader sciLoader = sci.getClass().getClassLoader();
        if (sciLoader == null) {
            return true;
        }
        if (context.getClassLoader() == null) {
            return true;
        }
        for (ClassLoader loader = sciLoader; loader != null; loader = loader.getParent()) {
            if (loader != context.getClassLoader()) continue;
            return false;
        }
        return true;
    }

    public boolean isFromWebInfClasses(WebAppContext context, Resource sci) {
        for (Resource dir : context.getMetaData().getWebInfClassesResources()) {
            if (!dir.equals(sci)) continue;
            return true;
        }
        return false;
    }

    public List<ServletContainerInitializer> getNonExcludedInitializers(WebAppContext context) throws Exception {
        ArrayList<ServletContainerInitializer> nonExcludedInitializers = new ArrayList<ServletContainerInitializer>();
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.nanoTime();
        }
        List scis = TypeUtil.serviceProviderStream(ServiceLoader.load(ServletContainerInitializer.class)).flatMap(provider -> {
            try {
                return Stream.of((ServletContainerInitializer)provider.get());
            }
            catch (Error e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error: {} for {}", e.getMessage(), context, e);
                } else {
                    LOG.info("Error: {} for {}", (Object)e.getMessage(), (Object)context);
                }
                return Stream.of(new ServletContainerInitializer[0]);
            }
        }).collect(Collectors.toList());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Service loaders found in {}ms", (Object)TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        }
        HashMap sciResourceMap = new HashMap();
        ServletContainerInitializerOrdering initializerOrdering = this.getInitializerOrdering(context);
        for (Object sci : scis) {
            if (this.matchesExclusionPattern((ServletContainerInitializer)sci)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} excluded by pattern", sci);
                continue;
            }
            Resource resource = this.getJarFor((ServletContainerInitializer)sci);
            if (this.isFromExcludedJar(context, (ServletContainerInitializer)sci, resource)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} is from excluded jar", sci);
                continue;
            }
            String name = sci.getClass().getName();
            if (initializerOrdering != null && !initializerOrdering.hasWildcard() && initializerOrdering.getIndexOf(name) < 0) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} is excluded by ordering", sci);
                continue;
            }
            sciResourceMap.put(sci, resource);
        }
        if (initializerOrdering != null && !initializerOrdering.isDefaultOrder()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ordering ServletContainerInitializers with {}", (Object)initializerOrdering);
            }
            nonExcludedInitializers.addAll(sciResourceMap.keySet());
            Collections.sort(nonExcludedInitializers, new ServletContainerInitializerComparator(initializerOrdering));
        } else {
            int lastContainerSCI = -1;
            for (Map.Entry entry : sciResourceMap.entrySet()) {
                if (((ServletContainerInitializer)entry.getKey()).getClass().getClassLoader() == context.getClassLoader().getParent()) {
                    nonExcludedInitializers.add(++lastContainerSCI, (ServletContainerInitializer)entry.getKey());
                    continue;
                }
                if (entry.getValue() == null) {
                    nonExcludedInitializers.add((ServletContainerInitializer)entry.getKey());
                    continue;
                }
                for (Resource resource : context.getMetaData().getWebInfClassesResources()) {
                    if (!resource.equals(entry.getValue())) continue;
                    nonExcludedInitializers.add((ServletContainerInitializer)entry.getKey());
                }
            }
            for (ServletContainerInitializer servletContainerInitializer : nonExcludedInitializers) {
                sciResourceMap.remove(servletContainerInitializer);
            }
            if (context.getMetaData().getOrdering() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No web.xml ordering, ServletContainerInitializers in random order");
                }
                nonExcludedInitializers.addAll(sciResourceMap.keySet());
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ordering ServletContainerInitializers with ordering {}", (Object)context.getMetaData().getOrdering());
                }
                for (Resource resource : context.getMetaData().getWebInfResources(true)) {
                    for (Map.Entry entry : sciResourceMap.entrySet()) {
                        if (!resource.equals(entry.getValue())) continue;
                        nonExcludedInitializers.add((ServletContainerInitializer)entry.getKey());
                    }
                }
            }
        }
        if (context.getServletContext().getEffectiveMajorVersion() < 3 && !context.isConfigurationDiscovered()) {
            ListIterator it = nonExcludedInitializers.listIterator();
            while (it.hasNext()) {
                Object sci;
                sci = (ServletContainerInitializer)it.next();
                if (this.isFromContainerClassPath(context, (ServletContainerInitializer)sci)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ignoring SCI {}: old web.xml version {}.{}", sci.getClass().getName(), context.getServletContext().getEffectiveMajorVersion(), context.getServletContext().getEffectiveMinorVersion());
                }
                it.remove();
            }
        }
        if (LOG.isDebugEnabled()) {
            int i2 = 0;
            for (ServletContainerInitializer servletContainerInitializer : nonExcludedInitializers) {
                LOG.debug("ServletContainerInitializer: {} {} from {}", ++i2, servletContainerInitializer.getClass().getName(), sciResourceMap.get(servletContainerInitializer));
            }
        }
        return nonExcludedInitializers;
    }

    public ServletContainerInitializerOrdering getInitializerOrdering(WebAppContext context) {
        if (context == null) {
            return null;
        }
        String tmp = (String)context.getAttribute(SERVLET_CONTAINER_INITIALIZER_ORDER);
        if (StringUtil.isBlank(tmp)) {
            return null;
        }
        return new ServletContainerInitializerOrdering(tmp);
    }

    public void parseContainerPath(WebAppContext context, AnnotationParser parser) throws Exception {
        HashSet<AnnotationParser.AbstractHandler> handlers = new HashSet<AnnotationParser.AbstractHandler>();
        handlers.addAll(this._discoverableAnnotationHandlers);
        handlers.addAll(this._containerInitializerAnnotationHandlers);
        if (this._classInheritanceHandler != null) {
            handlers.add(this._classInheritanceHandler);
        }
        if (LOG.isDebugEnabled()) {
            this._containerPathStats = new CounterStatistic();
        }
        for (Resource r : context.getMetaData().getContainerResources()) {
            if (this._parserTasks == null) continue;
            ParserTask task = new ParserTask(parser, handlers, r);
            this._parserTasks.add(task);
            if (!LOG.isDebugEnabled()) continue;
            this._containerPathStats.increment();
            task.setStatistic(new TimeStatistic());
        }
    }

    public void parseWebInfLib(WebAppContext context, AnnotationParser parser) throws Exception {
        List<Resource> jars = context.getMetaData().getWebInfResources(context.getMetaData().isOrdered());
        if (LOG.isDebugEnabled() && this._webInfLibStats == null) {
            this._webInfLibStats = new CounterStatistic();
        }
        for (Resource r : jars) {
            HashSet<AnnotationParser.AbstractHandler> handlers = new HashSet<AnnotationParser.AbstractHandler>();
            FragmentDescriptor f = context.getMetaData().getFragmentDescriptorForJar(r);
            if (f != null && WebDescriptor.isMetaDataComplete(f) && this._classInheritanceHandler == null && this._containerInitializerAnnotationHandlers.isEmpty()) continue;
            if (this._classInheritanceHandler != null) {
                handlers.add(this._classInheritanceHandler);
            }
            handlers.addAll(this._containerInitializerAnnotationHandlers);
            if (f == null || !WebDescriptor.isMetaDataComplete(f)) {
                handlers.addAll(this._discoverableAnnotationHandlers);
            }
            if (this._parserTasks == null) continue;
            ParserTask task = new ParserTask(parser, handlers, r);
            this._parserTasks.add(task);
            if (!LOG.isDebugEnabled()) continue;
            this._webInfLibStats.increment();
            task.setStatistic(new TimeStatistic());
        }
    }

    public void parseWebInfClasses(WebAppContext context, AnnotationParser parser) throws Exception {
        HashSet<AnnotationParser.AbstractHandler> handlers = new HashSet<AnnotationParser.AbstractHandler>();
        handlers.addAll(this._discoverableAnnotationHandlers);
        if (this._classInheritanceHandler != null) {
            handlers.add(this._classInheritanceHandler);
        }
        handlers.addAll(this._containerInitializerAnnotationHandlers);
        if (LOG.isDebugEnabled()) {
            this._webInfClassesStats = new CounterStatistic();
        }
        for (Resource dir : context.getMetaData().getWebInfClassesResources()) {
            if (this._parserTasks == null) continue;
            ParserTask task = new ParserTask(parser, handlers, dir);
            this._parserTasks.add(task);
            if (!LOG.isDebugEnabled()) continue;
            this._webInfClassesStats.increment();
            task.setStatistic(new TimeStatistic());
        }
    }

    public static class ClassInheritanceMap
    extends ConcurrentHashMap<String, Set<String>> {
        @Override
        public String toString() {
            return String.format("ClassInheritanceMap@%x{size=%d}", this.hashCode(), this.size());
        }
    }

    public class ServletContainerInitializerComparator
    implements Comparator<ServletContainerInitializer> {
        private ServletContainerInitializerOrdering _ordering;

        public ServletContainerInitializerComparator(ServletContainerInitializerOrdering ordering) {
            this._ordering = ordering;
        }

        @Override
        public int compare(ServletContainerInitializer sci1, ServletContainerInitializer sci2) {
            int i2;
            String c2;
            String c1 = sci1 != null ? sci1.getClass().getName() : null;
            String string = c2 = sci2 != null ? sci2.getClass().getName() : null;
            if (c1 == null && c2 == null) {
                return 0;
            }
            int i1 = this._ordering.getIndexOf(c1);
            if (i1 < 0 && this._ordering.hasWildcard()) {
                i1 = this._ordering.getWildcardIndex();
            }
            if ((i2 = this._ordering.getIndexOf(c2)) < 0 && this._ordering.hasWildcard()) {
                i2 = this._ordering.getWildcardIndex();
            }
            return Integer.compare(i1, i2);
        }
    }

    public class ServletContainerInitializerOrdering {
        private Map<String, Integer> _indexMap = new HashMap<String, Integer>();
        private Integer _star = null;
        private String _ordering = null;

        public ServletContainerInitializerOrdering(String ordering) {
            if (ordering != null) {
                this._ordering = ordering;
                String[] tmp = StringUtil.csvSplit(ordering);
                for (int i2 = 0; i2 < tmp.length; ++i2) {
                    String s = tmp[i2].trim();
                    this._indexMap.put(s, i2);
                    if (!"*".equals(s)) continue;
                    if (this._star != null) {
                        throw new IllegalArgumentException("Duplicate wildcards in ServletContainerInitializer ordering " + ordering);
                    }
                    this._star = i2;
                }
            }
        }

        public boolean hasWildcard() {
            return this._star != null;
        }

        public int getWildcardIndex() {
            if (!this.hasWildcard()) {
                return -1;
            }
            return this._star;
        }

        public boolean isDefaultOrder() {
            return this.getSize() == 1 && this.hasWildcard();
        }

        public int getIndexOf(String name) {
            Integer i2 = this._indexMap.get(name);
            if (i2 == null) {
                return -1;
            }
            return i2;
        }

        public int getSize() {
            return this._indexMap.size();
        }

        public String toString() {
            if (this._ordering == null) {
                return "";
            }
            return this._ordering;
        }
    }

    public class ParserTask
    implements Callable<Void> {
        protected Exception _exception;
        protected final AnnotationParser _parser;
        protected final Set<? extends AnnotationParser.Handler> _handlers;
        protected final Resource _resource;
        protected TimeStatistic _stat;

        public ParserTask(AnnotationParser parser, Set<? extends AnnotationParser.Handler> handlers, Resource resource) {
            this._parser = parser;
            this._handlers = handlers;
            this._resource = resource;
        }

        public void setStatistic(TimeStatistic stat) {
            this._stat = stat;
        }

        @Override
        public Void call() throws Exception {
            if (this._stat != null) {
                this._stat.start();
            }
            if (this._parser != null) {
                this._parser.parse(this._handlers, this._resource);
            }
            if (this._stat != null) {
                this._stat.end();
            }
            return null;
        }

        public TimeStatistic getStatistic() {
            return this._stat;
        }

        public Resource getResource() {
            return this._resource;
        }
    }

    public class TimeStatistic {
        public long _start = 0L;
        public long _end = 0L;

        public void start() {
            this._start = System.nanoTime();
        }

        public void end() {
            this._end = System.nanoTime();
        }

        public long getStart() {
            return this._start;
        }

        public long getEnd() {
            return this._end;
        }

        public long getElapsed() {
            return this._end > this._start ? this._end - this._start : 0L;
        }
    }
}

