/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jndi;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.eclipse.jetty.jndi.NamingContext;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextFactory
implements ObjectFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ContextFactory.class);
    private static final Map<ClassLoader, Context> __contextMap = new WeakHashMap<ClassLoader, Context>();
    private static final ThreadLocal<Context> __threadContext = new ThreadLocal();
    private static final ThreadLocal<ClassLoader> __threadClassLoader = new ThreadLocal();
    private static final AutoLock __lock = new AutoLock();

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Context ctx = __threadContext.get();
        if (ctx != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using the Context that is bound on the thread");
            }
            return ctx;
        }
        ClassLoader loader = __threadClassLoader.get();
        if (loader != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using threadlocal classloader");
            }
            try (AutoLock l = __lock.lock();){
                ctx = this.getContextForClassLoader(loader);
                if (ctx == null) {
                    ctx = this.newNamingContext(obj, loader, env, name, nameCtx);
                    __contextMap.put(loader, ctx);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Made context {} for classloader {}", (Object)name.get(0), (Object)loader);
                    }
                }
                Context context = ctx;
                return context;
            }
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        loader = tccl;
        if (loader != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying thread context classloader");
            }
            try (AutoLock l = __lock.lock();){
                while (ctx == null && loader != null) {
                    ctx = this.getContextForClassLoader(loader);
                    if (ctx != null || loader == null) continue;
                    loader = loader.getParent();
                }
                if (ctx == null) {
                    ctx = this.newNamingContext(obj, tccl, env, name, nameCtx);
                    __contextMap.put(tccl, ctx);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Made context {} for classloader {}", (Object)name.get(0), (Object)tccl);
                    }
                }
                Context context = ctx;
                return context;
            }
        }
        if (ContextHandler.getCurrentContext() != null) {
            if (LOG.isDebugEnabled() && loader != null) {
                LOG.debug("Trying classloader of current org.eclipse.jetty.server.handler.ContextHandler");
            }
            try (AutoLock l = __lock.lock();){
                loader = ContextHandler.getCurrentContext().getContextHandler().getClassLoader();
                ctx = __contextMap.get(loader);
                if (ctx == null && loader != null) {
                    ctx = this.newNamingContext(obj, loader, env, name, nameCtx);
                    __contextMap.put(loader, ctx);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Made context {} for classloader {} ", (Object)name.get(0), (Object)loader);
                    }
                }
                Context context = ctx;
                return context;
            }
        }
        return null;
    }

    public NamingContext newNamingContext(Object obj, ClassLoader loader, Hashtable env, Name name, Context parentCtx) throws Exception {
        Reference ref = (Reference)obj;
        StringRefAddr parserAddr = (StringRefAddr)ref.get("parser");
        String parserClassName = parserAddr == null ? null : (String)parserAddr.getContent();
        NameParser parser = parserClassName == null ? null : loader.loadClass(parserClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return new NamingContext(env, name.get(0), (NamingContext)parentCtx, parser);
    }

    public Context getContextForClassLoader(ClassLoader loader) {
        if (loader == null) {
            return null;
        }
        try (AutoLock l = __lock.lock();){
            Context context = __contextMap.get(loader);
            return context;
        }
    }

    public static Context associateContext(Context ctx) {
        Context previous = __threadContext.get();
        __threadContext.set(ctx);
        return previous;
    }

    public static void disassociateContext(Context ctx) {
        __threadContext.set(null);
    }

    public static ClassLoader associateClassLoader(ClassLoader loader) {
        ClassLoader prev = __threadClassLoader.get();
        __threadClassLoader.set(loader);
        return prev;
    }

    public static void disassociateClassLoader() {
        __threadClassLoader.set(null);
    }

    public static void dump(Appendable out, String indent) throws IOException {
        try (AutoLock l = __lock.lock();){
            Dumpable.dumpObjects(out, indent, String.format("o.e.j.jndi.ContextFactory@%x", __contextMap.hashCode()), __contextMap);
        }
    }
}

