/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core;

import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.compression.InflaterPool;
import org.eclipse.jetty.websocket.core.WebSocketExtensionRegistry;

public class WebSocketComponents {
    private final DecoratedObjectFactory objectFactory;
    private final WebSocketExtensionRegistry extensionRegistry;
    private final ByteBufferPool bufferPool;
    private final InflaterPool inflaterPool;
    private final DeflaterPool deflaterPool;

    public WebSocketComponents() {
        this(new WebSocketExtensionRegistry(), new DecoratedObjectFactory(), new MappedByteBufferPool(), new InflaterPool(-1, true), new DeflaterPool(-1, -1, true));
    }

    public WebSocketComponents(WebSocketExtensionRegistry extensionRegistry, DecoratedObjectFactory objectFactory, ByteBufferPool bufferPool, InflaterPool inflaterPool, DeflaterPool deflaterPool) {
        this.extensionRegistry = extensionRegistry;
        this.objectFactory = objectFactory;
        this.bufferPool = bufferPool;
        this.deflaterPool = deflaterPool;
        this.inflaterPool = inflaterPool;
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public WebSocketExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    public DecoratedObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public InflaterPool getInflaterPool() {
        return this.inflaterPool;
    }

    public DeflaterPool getDeflaterPool() {
        return this.deflaterPool;
    }
}

