/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.internal;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.websocket.core.Behavior;
import org.eclipse.jetty.websocket.core.CloseStatus;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.IncomingFrames;
import org.eclipse.jetty.websocket.core.OpCode;
import org.eclipse.jetty.websocket.core.OutgoingFrames;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.WebSocketConstants;
import org.eclipse.jetty.websocket.core.exception.CloseException;
import org.eclipse.jetty.websocket.core.exception.MessageTooLargeException;
import org.eclipse.jetty.websocket.core.exception.ProtocolException;
import org.eclipse.jetty.websocket.core.exception.WebSocketTimeoutException;
import org.eclipse.jetty.websocket.core.exception.WebSocketWriteTimeoutException;
import org.eclipse.jetty.websocket.core.internal.ExtensionStack;
import org.eclipse.jetty.websocket.core.internal.FragmentingFlusher;
import org.eclipse.jetty.websocket.core.internal.FrameFlusher;
import org.eclipse.jetty.websocket.core.internal.Negotiated;
import org.eclipse.jetty.websocket.core.internal.Parser;
import org.eclipse.jetty.websocket.core.internal.WebSocketConnection;
import org.eclipse.jetty.websocket.core.internal.WebSocketSessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketCoreSession
implements IncomingFrames,
CoreSession,
Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketCoreSession.class);
    private static final CloseStatus NO_CODE = new CloseStatus(1005);
    private final WebSocketComponents components;
    private final Behavior behavior;
    private final WebSocketSessionState sessionState = new WebSocketSessionState();
    private final FrameHandler handler;
    private final Negotiated negotiated;
    private final boolean demanding;
    private final Flusher flusher = new Flusher(this);
    private WebSocketConnection connection;
    private boolean autoFragment = true;
    private long maxFrameSize = 65536L;
    private int inputBufferSize = 4096;
    private int outputBufferSize = 4096;
    private long maxBinaryMessageSize = 65536L;
    private long maxTextMessageSize = 65536L;
    private Duration idleTimeout = WebSocketConstants.DEFAULT_IDLE_TIMEOUT;
    private Duration writeTimeout = WebSocketConstants.DEFAULT_WRITE_TIMEOUT;

    public WebSocketCoreSession(FrameHandler handler, Behavior behavior, Negotiated negotiated, WebSocketComponents components) {
        this.components = components;
        this.handler = handler;
        this.behavior = behavior;
        this.negotiated = negotiated;
        this.demanding = handler.isDemanding();
        negotiated.getExtensions().initialize(new IncomingAdaptor(), new OutgoingAdaptor(), this);
    }

    protected void handle(Runnable runnable) {
        runnable.run();
    }

    public boolean isDemanding() {
        return this.demanding;
    }

    public void assertValidIncoming(Frame frame) {
        this.assertValidFrame(frame);
        if (this.maxFrameSize > 0L && (long)frame.getPayloadLength() > this.maxFrameSize) {
            throw new MessageTooLargeException("Cannot handle payload lengths larger than " + this.maxFrameSize);
        }
        switch (this.behavior) {
            case SERVER: {
                if (frame.isMasked()) break;
                throw new ProtocolException("Client MUST mask all frames (RFC-6455: Section 5.1)");
            }
            case CLIENT: {
                if (!frame.isMasked()) break;
                throw new ProtocolException("Server MUST NOT mask any frames (RFC-6455: Section 5.1)");
            }
            default: {
                throw new IllegalStateException(this.behavior.toString());
            }
        }
        if (frame.getOpCode() == 8 && !(frame instanceof Parser.ParsedFrame)) {
            CloseStatus.getCloseStatus(frame);
        }
    }

    public void assertValidOutgoing(Frame frame) throws CloseException {
        CloseStatus closeStatus;
        this.assertValidFrame(frame);
        if (!this.autoFragment && this.maxFrameSize > 0L && (long)frame.getPayloadLength() > this.maxFrameSize) {
            throw new MessageTooLargeException("Cannot handle payload lengths larger than " + this.maxFrameSize);
        }
        if (frame.getOpCode() == 8 && !(frame instanceof Parser.ParsedFrame) && !CloseStatus.isTransmittableStatusCode((closeStatus = CloseStatus.getCloseStatus(frame)).getCode()) && closeStatus.getCode() != 1005) {
            throw new ProtocolException("Frame has non-transmittable status code");
        }
    }

    public void assertValidFrame(Frame frame) {
        if (!OpCode.isKnown(frame.getOpCode())) {
            throw new ProtocolException("Unknown opcode: " + frame.getOpCode());
        }
        int payloadLength = frame.getPayloadLength();
        if (frame.isControlFrame()) {
            if (!frame.isFin()) {
                throw new ProtocolException("Fragmented Control Frame [" + OpCode.name(frame.getOpCode()) + "]");
            }
            if (payloadLength > 125) {
                throw new ProtocolException("Invalid control frame payload length, [" + payloadLength + "] cannot exceed [125]");
            }
            if (frame.isRsv1()) {
                throw new ProtocolException("Cannot have RSV1==true on Control frames");
            }
            if (frame.isRsv2()) {
                throw new ProtocolException("Cannot have RSV2==true on Control frames");
            }
            if (frame.isRsv3()) {
                throw new ProtocolException("Cannot have RSV3==true on Control frames");
            }
        } else {
            ExtensionStack extensionStack = this.negotiated.getExtensions();
            if (frame.isRsv1() && !extensionStack.isRsv1Used()) {
                throw new ProtocolException("RSV1 not allowed to be set");
            }
            if (frame.isRsv2() && !extensionStack.isRsv2Used()) {
                throw new ProtocolException("RSV2 not allowed to be set");
            }
            if (frame.isRsv3() && !extensionStack.isRsv3Used()) {
                throw new ProtocolException("RSV3 not allowed to be set");
            }
        }
    }

    public ExtensionStack getExtensionStack() {
        return this.negotiated.getExtensions();
    }

    public FrameHandler getHandler() {
        return this.handler;
    }

    @Override
    public String getNegotiatedSubProtocol() {
        return this.negotiated.getSubProtocol();
    }

    @Override
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public void setIdleTimeout(Duration timeout) {
        this.idleTimeout = timeout;
        if (this.connection != null) {
            this.connection.getEndPoint().setIdleTimeout(timeout.toMillis());
        }
    }

    @Override
    public Duration getWriteTimeout() {
        return this.writeTimeout;
    }

    @Override
    public void setWriteTimeout(Duration timeout) {
        this.writeTimeout = timeout;
        if (this.getConnection() != null) {
            this.getConnection().getFrameFlusher().setIdleTimeout(timeout.toMillis());
        }
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.getConnection().getEndPoint().getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.getConnection().getEndPoint().getRemoteAddress();
    }

    @Override
    public boolean isOutputOpen() {
        return this.sessionState.isOutputOpen();
    }

    public boolean isClosed() {
        return this.sessionState.isClosed();
    }

    public void setWebSocketConnection(WebSocketConnection connection) {
        connection.getEndPoint().setIdleTimeout(this.idleTimeout.toMillis());
        connection.getFrameFlusher().setIdleTimeout(this.writeTimeout.toMillis());
        this.connection = connection;
    }

    @Override
    public void close(Callback callback) {
        this.close(NO_CODE, callback);
    }

    @Override
    public void close(int statusCode, String reason, Callback callback) {
        this.close(new CloseStatus(statusCode, reason), callback);
    }

    private void close(CloseStatus closeStatus, Callback callback) {
        this.sendFrame(closeStatus.toFrame(), callback, false);
    }

    @Override
    public ByteBufferPool getByteBufferPool() {
        return this.connection.getBufferPool();
    }

    public void onEof() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onEof() {}", (Object)this);
        }
        if (this.sessionState.onEof()) {
            this.closeConnection(this.sessionState.getCloseStatus(), Callback.NOOP);
        }
    }

    public void closeConnection(CloseStatus closeStatus, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("closeConnection() {} {} {}", (Object)closeStatus, (Object)this);
        }
        this.abort();
        if (closeStatus.isAbnormal() && closeStatus.getCause() != null) {
            Callback errorCallback = Callback.from(() -> {
                try {
                    this.handle(() -> this.handler.onClosed(closeStatus, callback));
                }
                catch (Throwable e) {
                    LOG.warn("Failure from onClosed on handler {}", (Object)this.handler, (Object)e);
                    callback.failed(e);
                }
            });
            Throwable cause = closeStatus.getCause();
            try {
                this.handle(() -> this.handler.onError(cause, errorCallback));
            }
            catch (Throwable e) {
                if (e != cause) {
                    cause.addSuppressed(e);
                }
                LOG.warn("Failure from onError on handler {}", (Object)this.handler, (Object)cause);
                errorCallback.failed(cause);
            }
        } else {
            try {
                this.handle(() -> this.handler.onClosed(closeStatus, callback));
            }
            catch (Throwable e) {
                LOG.warn("Failure from onClosed on handler {}", (Object)this.handler, (Object)e);
                callback.failed(e);
            }
        }
    }

    public void processConnectionError(Throwable cause, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processConnectionError {} {}", (Object)this, (Object)cause);
        }
        int code = cause instanceof CloseException ? ((CloseException)cause).getStatusCode() : (cause instanceof Utf8Appendable.NotUtf8Exception ? 1007 : (cause instanceof WebSocketWriteTimeoutException ? 1006 : (cause instanceof WebSocketTimeoutException || cause instanceof TimeoutException || cause instanceof SocketTimeoutException ? 1001 : 1006)));
        CloseStatus closeStatus = new CloseStatus(code, cause);
        if (CloseStatus.isTransmittableStatusCode(code)) {
            this.close(closeStatus, callback);
        } else if (this.sessionState.onClosed(closeStatus)) {
            this.closeConnection(closeStatus, callback);
        }
    }

    public void processHandlerError(Throwable cause, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processHandlerError {} {}", (Object)this, (Object)cause);
        }
        int code = cause instanceof CloseException ? ((CloseException)cause).getStatusCode() : (cause instanceof Utf8Appendable.NotUtf8Exception ? 1007 : (cause instanceof WebSocketTimeoutException || cause instanceof TimeoutException || cause instanceof SocketTimeoutException ? 1001 : (this.behavior == Behavior.CLIENT ? 1008 : 1011)));
        this.close(new CloseStatus(code, cause), callback);
    }

    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onOpen() {}", (Object)this);
        }
        this.sessionState.onConnected();
        if (LOG.isDebugEnabled()) {
            LOG.debug("ConnectionState: Transition to CONNECTED");
        }
        Callback openCallback = Callback.from(() -> {
            this.sessionState.onOpen();
            if (!this.demanding) {
                this.connection.demand(1L);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("ConnectionState: Transition to OPEN");
            }
        }, x -> {
            LOG.warn("Error during OPEN", (Throwable)x);
            this.processHandlerError(new CloseException(1011, (Throwable)x), Callback.NOOP);
        });
        try {
            this.handle(() -> this.handler.onOpen(this, openCallback));
        }
        catch (Throwable t) {
            openCallback.failed(t);
            throw new RuntimeException(t);
        }
    }

    @Override
    public void demand(long n) {
        if (!this.demanding) {
            throw new IllegalStateException("FrameHandler is not demanding: " + this);
        }
        if (!this.sessionState.isInputOpen()) {
            throw new IllegalStateException("FrameHandler input not open: " + this);
        }
        this.connection.demand(n);
    }

    public WebSocketConnection getConnection() {
        return this.connection;
    }

    public Executor getExecutor() {
        return this.connection.getExecutor();
    }

    @Override
    public void onFrame(Frame frame, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFrame({})", (Object)frame);
        }
        try {
            this.assertValidIncoming(frame);
        }
        catch (Throwable t) {
            callback.failed(t);
            return;
        }
        this.negotiated.getExtensions().onFrame(frame, callback);
    }

    @Override
    public void sendFrame(Frame frame, Callback callback, boolean batch) {
        try {
            this.assertValidOutgoing(frame);
        }
        catch (Throwable t2) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Invalid outgoing frame: " + frame, t2);
            }
            callback.failed(t2);
            return;
        }
        try {
            boolean closeConnection;
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendFrame({}, {}, {})", frame, callback, batch);
            }
            if (closeConnection = this.sessionState.onOutgoingFrame(frame)) {
                Callback closeConnectionCallback = Callback.from(() -> this.closeConnection(this.sessionState.getCloseStatus(), callback), t -> this.closeConnection(this.sessionState.getCloseStatus(), Callback.from(callback, t)));
                this.flusher.sendFrame(frame, closeConnectionCallback, false);
            } else {
                this.flusher.sendFrame(frame, callback, batch);
            }
        }
        catch (Throwable t3) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed sendFrame()", t3);
            }
            if (frame.getOpCode() == 8) {
                CloseStatus closeStatus = CloseStatus.getCloseStatus(frame);
                if (closeStatus.isAbnormal() && this.sessionState.onClosed(closeStatus)) {
                    this.closeConnection(closeStatus, Callback.from(callback, t3));
                } else {
                    callback.failed(t3);
                }
            }
            callback.failed(t3);
        }
    }

    @Override
    public void flush(Callback callback) {
        this.flusher.sendFrame(FrameFlusher.FLUSH_FRAME, callback, false);
    }

    @Override
    public void abort() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("abort(): {}", (Object)this);
        }
        this.connection.cancelDemand();
        this.connection.getEndPoint().close();
    }

    @Override
    public boolean isAutoFragment() {
        return this.autoFragment;
    }

    @Override
    public void setAutoFragment(boolean autoFragment) {
        this.autoFragment = autoFragment;
    }

    @Override
    public long getMaxFrameSize() {
        return this.maxFrameSize;
    }

    @Override
    public void setMaxFrameSize(long maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    @Override
    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    @Override
    public void setOutputBufferSize(int outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
    }

    @Override
    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    @Override
    public void setInputBufferSize(int inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
        if (this.connection != null) {
            this.connection.setInputBufferSize(inputBufferSize);
        }
    }

    @Override
    public long getMaxBinaryMessageSize() {
        return this.maxBinaryMessageSize;
    }

    @Override
    public void setMaxBinaryMessageSize(long maxSize) {
        this.maxBinaryMessageSize = maxSize;
    }

    @Override
    public long getMaxTextMessageSize() {
        return this.maxTextMessageSize;
    }

    @Override
    public void setMaxTextMessageSize(long maxSize) {
        this.maxTextMessageSize = maxSize;
    }

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, "subprotocol=" + this.negotiated.getSubProtocol(), this.negotiated.getExtensions(), this.handler);
    }

    @Override
    public List<ExtensionConfig> getNegotiatedExtensions() {
        return this.negotiated.getExtensions().getNegotiatedExtensions();
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        return this.negotiated.getParameterMap();
    }

    @Override
    public String getProtocolVersion() {
        return this.negotiated.getProtocolVersion();
    }

    @Override
    public URI getRequestURI() {
        return this.negotiated.getRequestURI();
    }

    @Override
    public boolean isSecure() {
        return this.negotiated.isSecure();
    }

    @Override
    public Behavior getBehavior() {
        return this.behavior;
    }

    @Override
    public WebSocketComponents getWebSocketComponents() {
        return this.components;
    }

    public String toString() {
        return String.format("WSCoreSession@%x{%s,%s,%s,af=%b,i/o=%d/%d,fs=%d}->%s", new Object[]{this.hashCode(), this.behavior, this.sessionState, this.negotiated, this.autoFragment, this.inputBufferSize, this.outputBufferSize, this.maxFrameSize, this.handler});
    }

    private class Flusher
    extends FragmentingFlusher {
        public Flusher(Configuration configuration) {
            super(configuration);
        }

        @Override
        void forwardFrame(Frame frame, Callback callback, boolean batch) {
            WebSocketCoreSession.this.negotiated.getExtensions().sendFrame(frame, callback, batch);
        }
    }

    private class OutgoingAdaptor
    implements OutgoingFrames {
        private OutgoingAdaptor() {
        }

        @Override
        public void sendFrame(Frame frame, Callback callback, boolean batch) {
            try {
                WebSocketCoreSession.this.connection.enqueueFrame(frame, callback, batch);
            }
            catch (ProtocolException e) {
                callback.failed(e);
            }
        }
    }

    private class IncomingAdaptor
    implements IncomingFrames {
        private IncomingAdaptor() {
        }

        @Override
        public void onFrame(Frame frame, Callback callback) {
            Callback closeCallback = null;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("receiveFrame({}, {}) - connectionState={}, handler={}", frame, callback, WebSocketCoreSession.this.sessionState, WebSocketCoreSession.this.handler);
                }
                boolean closeConnection = WebSocketCoreSession.this.sessionState.onIncomingFrame(frame);
                if (frame.getOpCode() != 8) {
                    WebSocketCoreSession.this.handle(() -> WebSocketCoreSession.this.handler.onFrame(frame, callback));
                    return;
                }
                WebSocketCoreSession.this.connection.cancelDemand();
                closeCallback = closeConnection ? Callback.from(() -> WebSocketCoreSession.this.closeConnection(WebSocketCoreSession.this.sessionState.getCloseStatus(), callback), t -> {
                    WebSocketCoreSession.this.sessionState.onError((Throwable)t);
                    WebSocketCoreSession.this.closeConnection(WebSocketCoreSession.this.sessionState.getCloseStatus(), callback);
                }) : Callback.from(() -> {
                    if (WebSocketCoreSession.this.sessionState.isOutputOpen()) {
                        CloseStatus closeStatus = CloseStatus.getCloseStatus(frame);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("ConnectionState: sending close response {}", (Object)closeStatus);
                        }
                        WebSocketCoreSession.this.close(closeStatus == null ? CloseStatus.NO_CODE_STATUS : closeStatus, callback);
                    } else {
                        callback.succeeded();
                    }
                }, x -> WebSocketCoreSession.this.processHandlerError((Throwable)x, callback));
                WebSocketCoreSession.this.handler.onFrame(frame, closeCallback);
            }
            catch (Throwable t2) {
                if (closeCallback != null) {
                    closeCallback.failed(t2);
                }
                callback.failed(t2);
            }
        }
    }
}

