/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.List;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContainerInitializersStarter
extends AbstractLifeCycle
implements ServletContextHandler.ServletContainerInitializerCaller {
    private static final Logger LOG = LoggerFactory.getLogger(ServletContainerInitializersStarter.class);
    WebAppContext _context;

    public ServletContainerInitializersStarter(WebAppContext context) {
        this._context = context;
    }

    @Override
    public void doStart() {
        List initializers = (List)this._context.getAttribute("org.eclipse.jetty.containerInitializers");
        if (initializers == null) {
            return;
        }
        for (ContainerInitializer i2 : initializers) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Calling ServletContainerInitializer " + i2.getTarget().getClass().getName());
                }
                i2.callStartup(this._context);
            }
            catch (Exception e) {
                LOG.warn("Failed to call startup on {}", (Object)i2, (Object)e);
                throw new RuntimeException(e);
            }
        }
    }
}

