/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.internal;

import java.nio.channels.ClosedChannelException;
import org.eclipse.jetty.websocket.core.CloseStatus;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.OpCode;
import org.eclipse.jetty.websocket.core.exception.ProtocolException;

public class WebSocketSessionState {
    private State _sessionState = State.CONNECTING;
    private byte _incomingContinuation = (byte)-1;
    private byte _outgoingContinuation = (byte)-1;
    CloseStatus _closeStatus = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected() {
        WebSocketSessionState webSocketSessionState = this;
        synchronized (webSocketSessionState) {
            if (this._sessionState != State.CONNECTING) {
                throw new IllegalStateException(this._sessionState.toString());
            }
            this._sessionState = State.CONNECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen() {
        WebSocketSessionState webSocketSessionState = this;
        synchronized (webSocketSessionState) {
            switch (this._sessionState) {
                case CONNECTED: {
                    this._sessionState = State.OPEN;
                    break;
                }
                case OSHUT: 
                case CLOSED: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this._sessionState.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        WebSocketSessionState webSocketSessionState = this;
        synchronized (webSocketSessionState) {
            return this._sessionState;
        }
    }

    public boolean isClosed() {
        return this.getState() == State.CLOSED;
    }

    public boolean isInputOpen() {
        State state = this.getState();
        return state == State.OPEN || state == State.OSHUT;
    }

    public boolean isOutputOpen() {
        State state = this.getState();
        return state == State.CONNECTED || state == State.OPEN || state == State.ISHUT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseStatus getCloseStatus() {
        WebSocketSessionState webSocketSessionState = this;
        synchronized (webSocketSessionState) {
            return this._closeStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onClosed(CloseStatus closeStatus) {
        WebSocketSessionState webSocketSessionState = this;
        synchronized (webSocketSessionState) {
            if (this._sessionState == State.CLOSED) {
                return false;
            }
            this._closeStatus = closeStatus;
            this._sessionState = State.CLOSED;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        WebSocketSessionState webSocketSessionState = this;
        synchronized (webSocketSessionState) {
            if (this._sessionState != State.CLOSED || this._closeStatus == null) {
                throw new IllegalArgumentException();
            }
            if (!this._closeStatus.isAbnormal()) {
                this._closeStatus = new CloseStatus(1011, t);
            }
            if (this._closeStatus.getCause() == null) {
                this._closeStatus = new CloseStatus(this._closeStatus.getCode(), this._closeStatus.getReason(), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onEof() {
        WebSocketSessionState webSocketSessionState = this;
        synchronized (webSocketSessionState) {
            switch (this._sessionState) {
                case CLOSED: 
                case ISHUT: {
                    return false;
                }
            }
            if (this._closeStatus == null || CloseStatus.isOrdinary(this._closeStatus.getCode())) {
                this._closeStatus = new CloseStatus(1006, "Session Closed", new ClosedChannelException());
            }
            this._sessionState = State.CLOSED;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onOutgoingFrame(Frame frame) throws Exception {
        byte opcode = frame.getOpCode();
        boolean fin = frame.isFin();
        WebSocketSessionState webSocketSessionState = this;
        synchronized (webSocketSessionState) {
            if (!this.isOutputOpen()) {
                throw new ClosedChannelException();
            }
            if (opcode == 8) {
                this._closeStatus = CloseStatus.getCloseStatus(frame);
                if (this._closeStatus.isAbnormal()) {
                    this._sessionState = State.CLOSED;
                    return true;
                }
                switch (this._sessionState) {
                    case CONNECTED: 
                    case OPEN: {
                        this._sessionState = State.OSHUT;
                        return false;
                    }
                    case ISHUT: {
                        this._sessionState = State.CLOSED;
                        return true;
                    }
                }
                throw new IllegalStateException(this._sessionState.toString());
            }
            if (frame.isDataFrame()) {
                this._outgoingContinuation = WebSocketSessionState.checkDataSequence(opcode, fin, this._outgoingContinuation);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onIncomingFrame(Frame frame) throws ProtocolException {
        byte opcode = frame.getOpCode();
        boolean fin = frame.isFin();
        WebSocketSessionState webSocketSessionState = this;
        synchronized (webSocketSessionState) {
            if (!this.isInputOpen()) {
                throw new IllegalStateException(this._sessionState.toString());
            }
            if (opcode == 8) {
                this._closeStatus = CloseStatus.getCloseStatus(frame);
                switch (this._sessionState) {
                    case OPEN: {
                        this._sessionState = State.ISHUT;
                        return false;
                    }
                    case OSHUT: {
                        this._sessionState = State.CLOSED;
                        return true;
                    }
                }
                throw new IllegalStateException(this._sessionState.toString());
            }
            if (frame.isDataFrame()) {
                this._incomingContinuation = WebSocketSessionState.checkDataSequence(opcode, fin, this._incomingContinuation);
            }
        }
        return false;
    }

    public String toString() {
        return String.format("%s@%x{%s,i=%s,o=%s,c=%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._sessionState, OpCode.name(this._incomingContinuation), OpCode.name(this._outgoingContinuation), this._closeStatus});
    }

    private static byte checkDataSequence(byte opcode, boolean fin, byte lastOpCode) throws ProtocolException {
        switch (opcode) {
            case 1: 
            case 2: {
                if (lastOpCode != -1) {
                    throw new ProtocolException("DataFrame before fin==true");
                }
                if (!fin) {
                    return opcode;
                }
                return -1;
            }
            case 0: {
                if (lastOpCode == -1) {
                    throw new ProtocolException("CONTINUATION after fin==true");
                }
                if (fin) {
                    return -1;
                }
                return lastOpCode;
            }
        }
        return lastOpCode;
    }

    static enum State {
        CONNECTING,
        CONNECTED,
        OPEN,
        ISHUT,
        OSHUT,
        CLOSED;

    }
}

